/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.impl.db.entity;

import java.util.List;
import org.apache.fulcrum.security.TurbineSecurity;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.impl.db.entity.BaseTurbineUserPeer;
import org.apache.fulcrum.security.impl.db.entity.UserPeer;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.torque.TorqueException;
import org.apache.torque.util.BasePeer;
import org.apache.torque.util.Criteria;

public class TurbineUserPeer
extends BaseTurbineUserPeer
implements UserPeer {
    public static final String USERNAME = BaseTurbineUserPeer.LOGIN_NAME;
    public static Class userClass = null;

    public static Class getOMClass() throws TorqueException {
        if (userClass == null) {
            String className = TurbineSecurity.getService().getConfiguration().getString("user.class", "org.apache.fulcrum.security.impl.db.entity.TurbineUser");
            try {
                userClass = Class.forName(className);
            }
            catch (Exception e) {
                throw new TorqueException((Throwable)e);
            }
        }
        return userClass;
    }

    public static String getColumnName(String name) {
        StringBuffer sb = new StringBuffer();
        sb.append("TURBINE_USER");
        sb.append(".");
        sb.append(name);
        return sb.toString();
    }

    public String getFullColumnName(String name) {
        return TurbineUserPeer.getColumnName(name);
    }

    public static String getTableName() {
        return "TURBINE_USER";
    }

    public static boolean checkExists(User user) throws DataBackendException, Exception {
        Criteria criteria = new Criteria();
        criteria.addSelectColumn(BaseTurbineUserPeer.USER_ID);
        criteria.add(USERNAME, (Object)user.getUserName());
        List results = BasePeer.doSelect((Criteria)criteria);
        if (results.size() > 1) {
            throw new DataBackendException("Multiple users named '" + user.getUserName() + "' exist!");
        }
        return results.size() == 1;
    }

    public static List selectAllUsers() throws Exception {
        Criteria criteria = new Criteria();
        criteria.addAscendingOrderByColumn(LAST_NAME);
        criteria.addAscendingOrderByColumn(FIRST_NAME);
        criteria.setIgnoreCase(true);
        return TurbineUserPeer.doSelect(criteria);
    }

    public static List selectAllConfirmedUsers() throws Exception {
        Criteria criteria = new Criteria();
        criteria.add("CONFIRM_VALUE", (Object)"CONFIRMED");
        criteria.addAscendingOrderByColumn(LAST_NAME);
        criteria.addAscendingOrderByColumn(FIRST_NAME);
        criteria.setIgnoreCase(true);
        return TurbineUserPeer.doSelect(criteria);
    }
}

