/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.impl.db.entity;

import java.util.List;
import org.apache.fulcrum.security.TurbineSecurity;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.impl.db.DBSecurityService;
import org.apache.fulcrum.security.impl.db.entity.BaseTurbineRolePeer;
import org.apache.fulcrum.security.impl.db.entity.TurbineUserGroupRolePeer;
import org.apache.fulcrum.security.impl.db.entity.TurbineUserPeer;
import org.apache.fulcrum.security.impl.db.entity.UserPeer;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.RoleSet;
import org.apache.torque.om.Persistent;
import org.apache.torque.util.BasePeer;
import org.apache.torque.util.Criteria;

public class TurbineRolePeer
extends BaseTurbineRolePeer {
    public static final String NAME = BaseTurbineRolePeer.ROLE_NAME;

    public static boolean checkExists(Role role) throws DataBackendException, Exception {
        Criteria criteria = new Criteria();
        criteria.addSelectColumn(BaseTurbineRolePeer.ROLE_ID);
        criteria.add(NAME, (Object)role.getName());
        List results = BasePeer.doSelect((Criteria)criteria);
        if (results.size() > 1) {
            throw new DataBackendException("Multiple roles named '" + role.getName() + "' exist!");
        }
        return results.size() == 1;
    }

    public static String getColumnName(String name) {
        StringBuffer sb = new StringBuffer();
        sb.append("TURBINE_ROLE");
        sb.append(".");
        sb.append(name);
        return sb.toString();
    }

    public static String getTableName() {
        return "TURBINE_ROLE";
    }

    public static RoleSet retrieveSet(Criteria criteria) throws Exception {
        List results = BaseTurbineRolePeer.doSelect(criteria);
        RoleSet rs = new RoleSet();
        int i = 0;
        while (i < results.size()) {
            rs.add((Role)results.get(i));
            ++i;
        }
        return rs;
    }

    public static RoleSet retrieveSet(User user, Group group) throws Exception {
        Criteria criteria = new Criteria();
        UserPeer up = ((DBSecurityService)TurbineSecurity.getService()).getUserPeerInstance();
        criteria.add(TurbineUserPeer.USERNAME, (Object)user.getUserName());
        criteria.add(TurbineUserGroupRolePeer.GROUP_ID, (Object)((Persistent)group).getPrimaryKey());
        criteria.addJoin(TurbineUserPeer.USER_ID, TurbineUserGroupRolePeer.USER_ID);
        criteria.addJoin(TurbineUserGroupRolePeer.ROLE_ID, ROLE_ID);
        return TurbineRolePeer.retrieveSet(criteria);
    }
}

