/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.naming;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.apache.fulcrum.BaseService;
import org.apache.fulcrum.InitializationException;
import org.apache.fulcrum.naming.NamingService;

public class TurbineNamingService
extends BaseService
implements NamingService {
    private static Hashtable contextPropsList = null;
    private Hashtable initialContexts = new Hashtable();

    public void init() throws InitializationException {
        try {
            Iterator contextKeys = this.getConfiguration().getKeys("context");
            contextPropsList = new Hashtable();
            while (contextKeys.hasNext()) {
                String key = (String)contextKeys.next();
                int start = key.indexOf(".") + 1;
                int end = key.indexOf(".", start);
                String contextName = key.substring(start, end);
                Properties contextProps = null;
                contextProps = contextPropsList.containsKey(contextName) ? (Properties)contextPropsList.get(contextName) : new Properties();
                contextProps.put(key.substring(end + 1), this.getConfiguration().getString(key));
                contextPropsList.put(contextName, contextProps);
            }
            Enumeration contextPropsKeys = contextPropsList.keys();
            while (contextPropsKeys.hasMoreElements()) {
                String key = (String)contextPropsKeys.nextElement();
                Properties contextProps = (Properties)contextPropsList.get(key);
                InitialContext context = new InitialContext(contextProps);
                this.initialContexts.put(key, context);
            }
            this.setInit(true);
        }
        catch (Exception e) {
            this.getCategory().error((Object)"Failed to initialize JDNI contexts!", (Throwable)e);
            throw new InitializationException("Failed to initialize JDNI contexts!");
        }
    }

    public Context getContext(String contextName) {
        Properties contextProps = null;
        contextProps = contextPropsList.containsKey(contextName) ? (Properties)contextPropsList.get(contextName) : new Properties();
        try {
            return new InitialContext(contextProps);
        }
        catch (Exception e) {
            return null;
        }
    }
}

