/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.validator;

import java.math.BigDecimal;
import java.util.Map;
import org.apache.fulcrum.ServiceException;
import org.apache.fulcrum.intake.validator.Constraint;
import org.apache.fulcrum.intake.validator.DefaultValidator;
import org.apache.fulcrum.intake.validator.ValidationException;

public class NumberValidator
extends DefaultValidator {
    private static String INVALID_NUMBER = "Entry was not a valid number";
    private BigDecimal minValue;
    protected String minValueMessage;
    private BigDecimal maxValue;
    protected String maxValueMessage;
    protected String invalidNumberMessage = this.getDefaultInvalidNumberMessage();

    public NumberValidator(Map paramMap) throws ServiceException {
        this();
        this.init(paramMap);
    }

    public NumberValidator() {
    }

    public void init(Map paramMap) throws ServiceException {
        super.init(paramMap);
        this.minValueMessage = null;
        this.maxValueMessage = null;
        this.doInit(paramMap);
        Constraint constraint = (Constraint)paramMap.get("notANumberMessage");
        if (constraint != null) {
            String param = constraint.getValue();
            if (param != null && param.length() != 0) {
                this.invalidNumberMessage = param;
            } else if (constraint.getMessage().length() != 0) {
                this.invalidNumberMessage = constraint.getMessage();
            }
        }
    }

    protected void doInit(Map paramMap) {
        String param;
        this.minValue = null;
        this.maxValue = null;
        Constraint constraint = (Constraint)paramMap.get("minValue");
        if (constraint != null) {
            param = constraint.getValue();
            this.minValue = new BigDecimal(param);
            this.minValueMessage = constraint.getMessage();
        }
        if ((constraint = (Constraint)paramMap.get("maxValue")) != null) {
            param = constraint.getValue();
            this.maxValue = new BigDecimal(param);
            this.maxValueMessage = constraint.getMessage();
        }
    }

    protected String getDefaultInvalidNumberMessage() {
        return INVALID_NUMBER;
    }

    protected void doAssertValidity(String testValue) throws ValidationException {
        BigDecimal bd = null;
        try {
            bd = new BigDecimal(testValue);
        }
        catch (RuntimeException e) {
            this.message = this.invalidNumberMessage;
            throw new ValidationException(this.invalidNumberMessage);
        }
        if (this.minValue != null && bd.compareTo(this.minValue) < 0) {
            this.message = this.minValueMessage;
            throw new ValidationException(this.minValueMessage);
        }
        if (this.maxValue != null && bd.compareTo(this.maxValue) > 0) {
            this.message = this.maxValueMessage;
            throw new ValidationException(this.maxValueMessage);
        }
    }

    public BigDecimal getMinValueAsBigDecimal() {
        return this.minValue;
    }

    public void setMinValue(BigDecimal v) {
        this.minValue = v;
    }

    public String getMinValueMessage() {
        return this.minValueMessage;
    }

    public void setMinValueMessage(String v) {
        this.minValueMessage = v;
    }

    public BigDecimal getMaxValueAsBigDecimal() {
        return this.maxValue;
    }

    public void setMaxValue(BigDecimal v) {
        this.maxValue = v;
    }

    public String getMaxValueMessage() {
        return this.maxValueMessage;
    }

    public void setMaxValueMessage(String v) {
        this.maxValueMessage = v;
    }

    public String getInvalidNumberMessage() {
        return this.invalidNumberMessage;
    }

    public void setInvalidNumberMessage(String v) {
        this.invalidNumberMessage = v;
    }
}

