/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.model;

import java.lang.reflect.Method;
import java.util.Locale;
import org.apache.fulcrum.ServiceException;
import org.apache.fulcrum.TurbineServices;
import org.apache.fulcrum.intake.Retrievable;
import org.apache.fulcrum.intake.TurbineIntake;
import org.apache.fulcrum.intake.model.Group;
import org.apache.fulcrum.intake.validator.InitableByConstraintMap;
import org.apache.fulcrum.intake.validator.ValidationException;
import org.apache.fulcrum.intake.validator.Validator;
import org.apache.fulcrum.intake.xmlmodel.Rule;
import org.apache.fulcrum.intake.xmlmodel.XmlField;
import org.apache.fulcrum.localization.Localization;
import org.apache.fulcrum.util.parser.ParameterParser;
import org.apache.fulcrum.util.parser.ValueParser;
import org.apache.log4j.Category;

public abstract class Field {
    private static final String EMPTY = "";
    private static final String VALUE_IF_ABSENT_KEY = "_vifa_";
    protected final String name;
    protected final String key;
    protected String displayName;
    protected final String mapToObject;
    protected Validator validator;
    protected final Method getter;
    protected final Method setter;
    protected final String ifRequiredMessage;
    protected final boolean isMultiValued;
    protected final Group group;
    protected boolean alwaysRequired;
    protected Object onError;
    protected Object defaultValue;
    protected boolean set_flag;
    protected boolean valid_flag;
    protected boolean required;
    protected boolean initialized;
    protected String message;
    protected Retrievable retrievable;
    private Locale locale;
    private String stringValue;
    private String[] stringValues;
    private Object validValue;
    private Object testValue;
    private Object[] valArray;
    protected ValueParser pp;
    Category category = Category.getInstance((String)this.getClass().getName());

    public Field(XmlField field, Group group) throws Exception {
        Rule reqRule;
        this.group = group;
        this.key = field.getKey();
        this.name = field.getName();
        this.displayName = field.getDisplayName();
        this.isMultiValued = field.isMultiValued();
        this.setDefaultValue(field.getDefaultValue());
        String className = field.getValidator();
        if (className == null && field.getRules().size() > 0) {
            className = this.getDefaultValidator();
        } else if (className != null && className.indexOf(46) == -1) {
            className = "org.apache.fulcrum.intake.validator." + className;
        }
        if (className != null) {
            this.validator = (Validator)Class.forName(className).newInstance();
            if (this.validator instanceof InitableByConstraintMap) {
                ((InitableByConstraintMap)((Object)this.validator)).init(field.getRuleMap());
            }
        }
        if ((reqRule = (Rule)field.getRuleMap().get("required")) != null) {
            this.alwaysRequired = new Boolean(reqRule.getValue());
        }
        this.mapToObject = field.getMapToObject();
        String propName = field.getMapToProperty();
        Method tmpGetter = null;
        Method tmpSetter = null;
        if (this.mapToObject != null && this.mapToObject.length() != 0) {
            tmpGetter = TurbineIntake.getFieldGetter(this.mapToObject, propName);
            tmpSetter = TurbineIntake.getFieldSetter(this.mapToObject, propName);
        }
        this.getter = tmpGetter;
        this.setter = tmpSetter;
        this.ifRequiredMessage = field.getIfRequiredMessage();
        this.valArray = new Object[1];
    }

    public Field init(ValueParser pp) throws ServiceException {
        this.pp = pp;
        this.valid_flag = true;
        if (TurbineServices.getInstance().isRegistered("LocalizationService")) {
            this.locale = pp instanceof ParameterParser ? Localization.getLocale(((ParameterParser)pp).getRequest()) : Localization.getLocale((String)null);
        }
        if (pp.containsKey(this.getKey()) && pp.getString(this.getKey()) != null) {
            this.set_flag = true;
            if (this.validate(pp)) {
                // empty if block
            }
        } else if (pp.containsKey(this.getValueIfAbsent()) && pp.getString(this.getValueIfAbsent()) != null) {
            pp.add(this.getKey(), pp.getString(this.getValueIfAbsent()));
            this.set_flag = true;
            this.validate(pp);
        }
        this.initialized = true;
        return this;
    }

    public Field init(Retrievable obj) {
        if (!this.initialized) {
            this.valid_flag = true;
        }
        this.retrievable = obj;
        return this;
    }

    protected Locale getLocale() {
        return this.locale;
    }

    protected String getDefaultValidator() {
        return "org.apache.fulcrum.intake.validator.DefaultValidator";
    }

    public Validator getValidator() {
        return this.validator;
    }

    public boolean isRequired() {
        return this.alwaysRequired || this.required;
    }

    public void setRequired(boolean v) {
        this.setRequired(v, this.ifRequiredMessage);
    }

    public void setRequired(boolean v, String message) {
        this.required = v;
        if (v && !this.set_flag) {
            this.valid_flag = false;
            this.message = message;
        }
    }

    public void removeFromRequest() {
        this.pp.remove(this.getKey());
    }

    public void dispose() {
        this.pp = null;
        this.initialized = false;
        this.set_flag = false;
        this.valid_flag = false;
        this.required = false;
        this.message = null;
        this.retrievable = null;
        this.locale = null;
        this.stringValue = null;
        this.stringValues = null;
        this.validValue = null;
        this.testValue = null;
        this.valArray[0] = null;
    }

    public String getKey() {
        if (this.group == null) {
            return this.key;
        }
        return this.group.getObjectKey() + this.key;
    }

    public String getValueIfAbsent() {
        return this.getKey() + VALUE_IF_ABSENT_KEY;
    }

    public boolean isValid() {
        return this.valid_flag;
    }

    public boolean isSet() {
        return this.set_flag;
    }

    public String getDisplayName() {
        return this.displayName == null ? this.name : this.displayName;
    }

    public void setDisplayName(String newDisplayName) {
        this.displayName = newDisplayName;
    }

    public String getMessage() {
        if (this.message == null) {
            return EMPTY;
        }
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
        this.valid_flag = false;
    }

    protected boolean validate(ValueParser pp) {
        return this.validate();
    }

    protected boolean validate() {
        if (this.isMultiValued) {
            this.stringValues = this.pp.getStrings(this.getKey());
            if (this.stringValues.length == 0 || this.stringValues.length == 1 && this.stringValues[0] == null) {
                this.set_flag = false;
            }
            if (this.validator != null) {
                this.setTestValue(this.pp.getStrings(this.getKey()));
                int i = 0;
                while (i < this.stringValues.length) {
                    try {
                        this.validator.assertValidity(this.stringValues[i]);
                    }
                    catch (ValidationException ve) {
                        this.setMessage(ve.getMessage());
                    }
                    ++i;
                }
            }
            if (this.set_flag && this.valid_flag) {
                this.doSetValue(this.pp);
            }
        } else {
            this.stringValue = this.pp.getString(this.getKey());
            if (this.validator != null) {
                this.setTestValue(this.pp.getString(this.getKey()));
                try {
                    this.validator.assertValidity(this.stringValue);
                    if (this.set_flag) {
                        this.doSetValue(this.pp);
                    }
                }
                catch (ValidationException ve) {
                    this.setMessage(ve.getMessage());
                }
            } else if (this.set_flag) {
                this.doSetValue(this.pp);
            }
        }
        return this.valid_flag;
    }

    protected abstract void setDefaultValue(String var1);

    protected void doSetValue(ValueParser pp) {
        this.doSetValue();
    }

    protected abstract void doSetValue();

    void setInitialValue(Object obj) {
        this.validValue = obj;
    }

    public Object getInitialValue() throws Exception {
        if (this.validValue == null) {
            if (this.retrievable != null) {
                this.getProperty(this.retrievable);
            } else {
                this.getDefault();
            }
        }
        return this.validValue;
    }

    void setTestValue(Object obj) {
        this.testValue = obj;
    }

    public Object getTestValue() {
        return this.testValue;
    }

    public Object getValue() {
        Object val = null;
        try {
            val = this.getInitialValue();
        }
        catch (Exception e) {
            this.category.error((Object)e);
        }
        if (this.getTestValue() != null) {
            val = this.getTestValue();
        }
        if (val == null) {
            val = this.onError;
        }
        return val;
    }

    public String toString() {
        if (this.stringValue != null) {
            return this.stringValue;
        }
        if (this.getValue() != null) {
            return this.getValue().toString();
        }
        return EMPTY;
    }

    public void getProperty(Object obj) throws Exception {
        this.validValue = this.getter.invoke(obj, null);
    }

    public void getDefault() {
        this.validValue = this.getDefaultValue();
    }

    public void setProperty(Object obj) throws ServiceException {
        if (!this.isValid()) {
            throw new ServiceException("Attempted to assign an invalid input.");
        }
        if (this.isSet() && this.getTestValue() != null) {
            try {
                this.valArray[0] = this.getTestValue();
                this.setter.invoke(obj, this.valArray);
            }
            catch (Exception e) {
                throw new ServiceException("An exception prevented the setting property " + this.name + " of " + obj + " to " + this.valArray[0], e);
            }
        }
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    static {
        EMPTY = EMPTY;
        VALUE_IF_ABSENT_KEY = VALUE_IF_ABSENT_KEY;
    }
}

