/*
 * Decompiled with CFR 0.152.
 */
package test.ojb.broker;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import ojb.broker.Identity;
import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.PersistenceBrokerFactory;
import ojb.broker.accesslayer.ConnectionFactory;
import ojb.broker.accesslayer.ConnectionFactoryFactory;
import ojb.broker.accesslayer.SqlGenerator;
import ojb.broker.metadata.ClassDescriptor;
import ojb.broker.metadata.JdbcConnectionDescriptor;
import ojb.broker.query.Criteria;
import ojb.broker.query.QueryByCriteria;
import ojb.broker.singlevm.PersistenceBrokerImpl;
import ojb.broker.util.Logger;
import ojb.broker.util.LoggerFactory;
import test.ojb.broker.PerformanceArticle;

public class PerformanceJdbcReferenceTest
extends TestCase {
    PersistenceBroker broker;
    private static Class CLASS = class$test$ojb$broker$PerformanceJdbcReferenceTest == null ? (class$test$ojb$broker$PerformanceJdbcReferenceTest = PerformanceJdbcReferenceTest.class$("test.ojb.broker.PerformanceJdbcReferenceTest")) : class$test$ojb$broker$PerformanceJdbcReferenceTest;
    private Logger logger = LoggerFactory.getLogger("performance");
    private PerformanceArticle[] arr;
    static int articleCount = 10000;
    static int iterations = 2;
    int offsetId = 10000;
    static /* synthetic */ Class class$test$ojb$broker$PerformanceJdbcReferenceTest;
    static /* synthetic */ Class class$test$ojb$broker$PerformanceArticle;

    public PerformanceJdbcReferenceTest(String name) {
        super(name);
    }

    private PerformanceArticle createArticle(int id) {
        PerformanceArticle a = new PerformanceArticle();
        a.setArticleId(id);
        a.setArticleName("New Performance Article " + id);
        a.setMinimumStock(100);
        a.setOrderedUnits(17);
        a.setPrice(100.0);
        a.setProductGroupId(111);
        a.setStock(234);
        a.setSupplierId(4);
        a.setUnit("bottle");
        return a;
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            articleCount = Integer.parseInt(args[0]);
        }
        if (args.length > 1) {
            iterations = Integer.parseInt(args[1]);
        }
        String[] arr = new String[]{CLASS.getName()};
        TestRunner.main((String[])arr);
    }

    private PerformanceArticle readArticleByIdentity(int id) throws PersistenceBrokerException {
        Object[] pks = new Object[]{new Integer(id)};
        Identity oid = new Identity(class$test$ojb$broker$PerformanceArticle == null ? (class$test$ojb$broker$PerformanceArticle = PerformanceJdbcReferenceTest.class$("test.ojb.broker.PerformanceArticle")) : class$test$ojb$broker$PerformanceArticle, pks);
        return (PerformanceArticle)this.broker.getObjectByIdentity(oid);
    }

    public void setUp() {
        this.broker = PersistenceBrokerFactory.createPersistenceBroker();
        this.arr = new PerformanceArticle[articleCount];
        int i = 0;
        while (i < articleCount) {
            PerformanceArticle a;
            this.arr[i] = a = this.createArticle(this.offsetId + i);
            ++i;
        }
    }

    public void tearDown() {
    }

    protected void deleteArticles() throws PersistenceBrokerException {
        ClassDescriptor cld = this.broker.getClassDescriptor(class$test$ojb$broker$PerformanceArticle == null ? (class$test$ojb$broker$PerformanceArticle = PerformanceJdbcReferenceTest.class$("test.ojb.broker.PerformanceArticle")) : class$test$ojb$broker$PerformanceArticle);
        JdbcConnectionDescriptor jcd = cld.getConnectionDescriptor();
        ConnectionFactory cf = ConnectionFactoryFactory.getConnectionFactory();
        Connection conn = cf.newConnection(jcd, (PersistenceBrokerImpl)this.broker);
        String sql = SqlGenerator.getInstance().getPreparedDeleteStatement(cld);
        this.logger.debug("delete stmt: " + sql);
        long start = System.currentTimeMillis();
        try {
            conn.setAutoCommit(false);
            PreparedStatement stmt = conn.prepareStatement(sql);
            int i = 0;
            while (i < articleCount) {
                PerformanceArticle a = this.arr[i];
                stmt.setInt(1, a.articleId);
                stmt.execute();
                ++i;
            }
            conn.commit();
        }
        catch (Throwable t) {
            this.logger.error(t);
            Assert.fail((String)t.getMessage());
        }
        long stop = System.currentTimeMillis();
        this.logger.info("deleting " + articleCount + " Objects: " + (stop - start) + " msec");
    }

    protected void insertNewArticles() throws PersistenceBrokerException {
        ClassDescriptor cld = this.broker.getClassDescriptor(class$test$ojb$broker$PerformanceArticle == null ? (class$test$ojb$broker$PerformanceArticle = PerformanceJdbcReferenceTest.class$("test.ojb.broker.PerformanceArticle")) : class$test$ojb$broker$PerformanceArticle);
        JdbcConnectionDescriptor jcd = cld.getConnectionDescriptor();
        ConnectionFactory cf = ConnectionFactoryFactory.getConnectionFactory();
        Connection conn = cf.newConnection(jcd, (PersistenceBrokerImpl)this.broker);
        String sql = SqlGenerator.getInstance().getPreparedInsertStatement(cld);
        this.logger.debug("insert stmt: " + sql);
        long start = System.currentTimeMillis();
        try {
            conn.setAutoCommit(false);
            PreparedStatement stmt = conn.prepareStatement(sql);
            int i = 0;
            while (i < articleCount) {
                PerformanceArticle a = this.arr[i];
                stmt.setInt(1, a.articleId);
                stmt.setString(2, a.articleName);
                stmt.setInt(3, a.supplierId);
                stmt.setInt(4, a.productGroupId);
                stmt.setString(5, a.unit);
                stmt.setDouble(6, a.price);
                stmt.setInt(7, a.stock);
                stmt.setInt(8, a.orderedUnits);
                stmt.setInt(9, a.minimumStock);
                stmt.execute();
                ++i;
            }
            conn.commit();
        }
        catch (Throwable t) {
            this.logger.error(t);
            Assert.fail((String)t.getMessage());
        }
        long stop = System.currentTimeMillis();
        this.logger.info("inserting " + articleCount + " Objects: " + (stop - start) + " msec");
    }

    protected void readArticles() throws PersistenceBrokerException {
        ClassDescriptor cld = this.broker.getClassDescriptor(class$test$ojb$broker$PerformanceArticle == null ? (class$test$ojb$broker$PerformanceArticle = PerformanceJdbcReferenceTest.class$("test.ojb.broker.PerformanceArticle")) : class$test$ojb$broker$PerformanceArticle);
        JdbcConnectionDescriptor jcd = cld.getConnectionDescriptor();
        ConnectionFactory cf = ConnectionFactoryFactory.getConnectionFactory();
        Connection conn = cf.newConnection(jcd, (PersistenceBrokerImpl)this.broker);
        String sql = SqlGenerator.getInstance().getPreparedSelectByPkStatement(cld);
        this.logger.debug("select stmt: " + sql);
        long start = System.currentTimeMillis();
        try {
            conn.setAutoCommit(false);
            PreparedStatement stmt = conn.prepareStatement(sql);
            int i = 0;
            while (i < articleCount) {
                stmt.setInt(1, this.offsetId + i);
                ResultSet rs = stmt.executeQuery();
                rs.next();
                PerformanceArticle a = new PerformanceArticle();
                a.articleId = rs.getInt(1);
                a.articleName = rs.getString(2);
                a.supplierId = rs.getInt(3);
                a.productGroupId = rs.getInt(4);
                a.unit = rs.getString(5);
                a.price = rs.getDouble(6);
                a.stock = rs.getInt(7);
                a.orderedUnits = rs.getInt(8);
                a.minimumStock = rs.getInt(9);
                ++i;
            }
        }
        catch (Throwable t) {
            this.logger.error(t);
            Assert.fail((String)t.getMessage());
        }
        long stop = System.currentTimeMillis();
        this.logger.info("querying " + articleCount + " Objects: " + (stop - start) + " msec");
    }

    protected void readArticlesByCursor() throws PersistenceBrokerException {
        ClassDescriptor cld = this.broker.getClassDescriptor(class$test$ojb$broker$PerformanceArticle == null ? (class$test$ojb$broker$PerformanceArticle = PerformanceJdbcReferenceTest.class$("test.ojb.broker.PerformanceArticle")) : class$test$ojb$broker$PerformanceArticle);
        JdbcConnectionDescriptor jcd = cld.getConnectionDescriptor();
        ConnectionFactory cf = ConnectionFactoryFactory.getConnectionFactory();
        Connection conn = cf.newConnection(jcd, (PersistenceBrokerImpl)this.broker);
        Criteria c = new Criteria();
        c.addBetween("articleId", new Integer(this.offsetId), new Integer(this.offsetId + articleCount));
        QueryByCriteria q = new QueryByCriteria(class$test$ojb$broker$PerformanceArticle == null ? (class$test$ojb$broker$PerformanceArticle = PerformanceJdbcReferenceTest.class$("test.ojb.broker.PerformanceArticle")) : class$test$ojb$broker$PerformanceArticle, c);
        String sql = SqlGenerator.getInstance().getPreparedSelectStatement(q, cld);
        this.logger.debug("select stmt: " + sql);
        int fetchCount = 0;
        long start = System.currentTimeMillis();
        try {
            conn.setAutoCommit(false);
            PreparedStatement stmt = conn.prepareStatement(sql);
            stmt.setInt(1, this.offsetId);
            stmt.setInt(2, this.offsetId + articleCount);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                ++fetchCount;
                PerformanceArticle a = new PerformanceArticle();
                a.articleId = rs.getInt(1);
                a.articleName = rs.getString(2);
                a.supplierId = rs.getInt(3);
                a.productGroupId = rs.getInt(4);
                a.unit = rs.getString(5);
                a.price = rs.getDouble(6);
                a.stock = rs.getInt(7);
                a.orderedUnits = rs.getInt(8);
                a.minimumStock = rs.getInt(9);
            }
        }
        catch (Throwable t) {
            this.logger.error(t);
            Assert.fail((String)t.getMessage());
        }
        long stop = System.currentTimeMillis();
        this.logger.info("fetching " + fetchCount + " Objects: " + (stop - start) + " msec");
    }

    protected void updateExistingArticles() throws PersistenceBrokerException {
        ClassDescriptor cld = this.broker.getClassDescriptor(class$test$ojb$broker$PerformanceArticle == null ? (class$test$ojb$broker$PerformanceArticle = PerformanceJdbcReferenceTest.class$("test.ojb.broker.PerformanceArticle")) : class$test$ojb$broker$PerformanceArticle);
        JdbcConnectionDescriptor jcd = cld.getConnectionDescriptor();
        ConnectionFactory cf = ConnectionFactoryFactory.getConnectionFactory();
        Connection conn = cf.newConnection(jcd, (PersistenceBrokerImpl)this.broker);
        String sql = SqlGenerator.getInstance().getPreparedUpdateStatement(cld);
        this.logger.debug("update stmt: " + sql);
        int i = 0;
        while (i < articleCount) {
            this.arr[i].setPrice(this.arr[i].getPrice() * 1.95583);
            ++i;
        }
        long start = System.currentTimeMillis();
        try {
            conn.setAutoCommit(false);
            PreparedStatement stmt = conn.prepareStatement(sql);
            int i2 = 0;
            while (i2 < articleCount) {
                PerformanceArticle a = this.arr[i2];
                stmt.setString(1, a.articleName);
                stmt.setInt(2, a.supplierId);
                stmt.setInt(3, a.productGroupId);
                stmt.setString(4, a.unit);
                stmt.setDouble(5, a.price);
                stmt.setInt(6, a.stock);
                stmt.setInt(7, a.orderedUnits);
                stmt.setInt(8, a.minimumStock);
                stmt.setInt(9, a.articleId);
                stmt.execute();
                ++i2;
            }
            conn.commit();
        }
        catch (Throwable t) {
            this.logger.error(t);
            Assert.fail((String)t.getMessage());
        }
        long stop = System.currentTimeMillis();
        this.logger.info("updating " + articleCount + " Objects: " + (stop - start) + " msec");
    }

    public void testScenario2() {
        try {
            int i = 0;
            while (i < iterations) {
                this.logger.info("");
                this.insertNewArticles();
                this.updateExistingArticles();
                this.readArticles();
                this.readArticles();
                this.readArticlesByCursor();
                this.deleteArticles();
                ++i;
            }
        }
        catch (Throwable t) {
            this.logger.error(t);
            Assert.fail((String)t.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

