/*
 * Decompiled with CFR 0.152.
 */
package ojb.odmg.states;

import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerException;
import ojb.odmg.ObjectEnvelope;
import ojb.odmg.states.ModificationState;
import ojb.odmg.states.StateOldClean;
import ojb.odmg.states.StateOldDelete;

public class StateOldDirty
extends ModificationState {
    private static StateOldDirty _instance = new StateOldDirty();

    public ModificationState markClean() {
        return this;
    }

    public ModificationState markDelete() {
        return StateOldDelete.getInstance();
    }

    public ModificationState markDirty() {
        return this;
    }

    public ModificationState markNew() {
        return this;
    }

    public ModificationState markOld() {
        return this;
    }

    private StateOldDirty() {
    }

    public static StateOldDirty getInstance() {
        return _instance;
    }

    public void checkpoint(ObjectEnvelope mod, PersistenceBroker broker) throws PersistenceBrokerException {
        broker.store(mod.getObject(), mod);
        mod.manage(mod.getObject());
        mod.setModificationState(StateOldClean.getInstance());
    }

    public void commit(ObjectEnvelope mod, PersistenceBroker broker) throws PersistenceBrokerException {
        broker.store(mod.getObject(), mod);
        mod.manage(mod.getObject());
        mod.setModificationState(StateOldClean.getInstance());
    }

    public void rollback(ObjectEnvelope mod, PersistenceBroker broker) {
        this.removeFromCache(mod.getObject(), broker);
    }

    public boolean needsUpdate() {
        return true;
    }
}

