/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.util.conf;

import java.io.IOException;
import org.apache.slide.util.conf.ConfigurationException;
import org.apache.slide.util.conf.Element;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class Populate
implements ContentHandler,
ErrorHandler {
    private Element _root;
    private Element _current;
    private Locator _locator;

    public void characters(char[] ch, int start, int length) throws SAXParseException {
        if (ch == null || length == 0) {
            return;
        }
        if (this._current == null) {
            throw new SAXParseException("Attempt to place character before or after the root element.", this._locator);
        }
        String data = this._current.getData();
        if (data == null || !(data instanceof String) || data.length() == 0) {
            this._current.setData(new String(ch, start, length));
        } else {
            StringBuffer buf = new StringBuffer(data);
            buf.append(ch, start, length);
            this._current.setData(buf.toString());
        }
    }

    public void endDocument() throws SAXParseException {
        if (this._current != null) {
            throw new SAXParseException("Not all elements have been closed at end of document.", this._locator);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXParseException {
        if (this._current == null) {
            throw new SAXParseException("Attempt to close the element " + qName + " when root element is already closed.", this._locator);
        }
        if (!this._current.getName().equals(qName)) {
            throw new SAXParseException("Attempt to close the element " + qName + " when the element " + this._current.getName() + " should be closed.", this._locator);
        }
        this._current = this._current.getParent();
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void error(SAXParseException except) {
        System.out.println(except.getMessage());
    }

    public void fatalError(SAXParseException except) {
        System.out.println(except.getMessage());
    }

    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    public Element load(InputSource is, XMLReader parser) throws SAXException, IOException, ConfigurationException {
        parser.setContentHandler(this);
        parser.parse(is);
        return this._root;
    }

    public void processingInstruction(String target, String pi) {
    }

    public void reset() {
        this._root = null;
    }

    public void setDocumentLocator(Locator locator) {
        this._locator = locator;
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startDocument() throws SAXParseException {
        if (this._root != null) {
            throw new SAXParseException("Cannot start processing a new document without a reset", this._locator);
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attr) {
        if (this._current == null) {
            this._root = this._current = new Element(qName, null);
        } else {
            Element parent = this._current;
            this._current = new Element(qName, parent);
            parent.addChild(this._current);
        }
        this._current.setName(qName);
        int i = 0;
        while (i < attr.getLength()) {
            this._current.setAttribute(attr.getQName(i), attr.getValue(i));
            ++i;
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void warning(SAXParseException except) {
        System.out.println(except.getMessage());
    }
}

