/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.util;

import org.apache.slide.util.AbstractObjectCache;
import org.apache.slide.util.HashMap;

public class HashMapObjectCache
extends AbstractObjectCache {
    protected HashMap cache;

    public HashMapObjectCache() {
        this.cache = new HashMap(this.initialSize);
    }

    public HashMapObjectCache(int initialSize, int maxSize, double desiredHitRatio) {
        super(initialSize, maxSize, desiredHitRatio);
        this.cache = new HashMap(this.initialSize / 3);
    }

    public void clear() {
        HashMap hashMap = this.cache;
        synchronized (hashMap) {
            this.cache.clear();
        }
    }

    public Object get(Object key) {
        HashMap hashMap = this.cache;
        synchronized (hashMap) {
            Object result = this.cache.get(key);
            this.cacheRequests += 1.0;
            if (result != null) {
                this.cacheHits += 1.0;
            } else {
                this.shouldResize();
            }
            Object object = result;
            Object var4_5 = null;
            return object;
        }
    }

    protected int getSize() {
        return this.cache.size();
    }

    public void put(Object key, Object value) {
        HashMap hashMap = this.cache;
        synchronized (hashMap) {
            this.cache.put(key, value);
        }
    }

    public void remove(Object key) {
        HashMap hashMap = this.cache;
        synchronized (hashMap) {
            this.cache.remove(key);
        }
    }

    protected void removeSomeObjects() {
        this.clear();
    }

    protected void resize() {
        HashMap hashMap = this.cache;
        synchronized (hashMap) {
            if (this.getSize() < this.maxSize) {
                int size = this.getSize();
                this.cache.clear();
                this.cache = new HashMap(size / 3 * 2);
            }
        }
    }
}

