/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store.impl.rdbms;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import org.apache.slide.common.Service;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.ServiceParameterErrorException;
import org.apache.slide.common.ServiceParameterMissingException;
import org.apache.slide.common.Uri;
import org.apache.slide.content.NodeRevisionContent;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.RevisionAlreadyExistException;
import org.apache.slide.content.RevisionNotFoundException;
import org.apache.slide.store.ContentStore;
import org.apache.slide.store.impl.rdbms.J2EEStore;
import org.apache.slide.store.impl.rdbms.JDBCAwareInputStream;
import org.apache.slide.store.impl.rdbms.StoreContentZip;

public class J2EEContentStore
extends J2EEStore
implements ContentStore {
    public static final int BUFFER_SIZE = 2048;
    private boolean compressContent = false;

    public void createRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws ServiceAccessException, RevisionAlreadyExistException {
        Connection connection = this.getCurrentConnection();
        String revisionUri = uri.toString();
        String revisionNumber = revisionDescriptor.getRevisionNumber().toString();
        long contentLength = revisionDescriptor.getContentLength();
        Statement selectStatement = null;
        try {
            try {
                long versionid = this.getVersionID(this.getUriId(revisionUri), revisionDescriptor.getBranchName(), revisionNumber);
                selectStatement = connection.createStatement();
                StringBuffer theSQL = new StringBuffer("select 1 from VERSION_CONTENT where VERSION_ID = ");
                theSQL.append(versionid);
                ResultSet rs = selectStatement.executeQuery(theSQL.toString());
                if (rs.next()) {
                    rs.close();
                    throw new RevisionAlreadyExistException(uri.toString(), revisionDescriptor.getRevisionNumber());
                }
                rs.close();
                this.storeContent(revisionUri, revisionNumber, revisionDescriptor, revisionContent);
            }
            catch (SQLException e) {
                this.getLogger().log(e, this.LOG_CHANNEL, 2);
                throw new ServiceAccessException((Service)this, e.getMessage());
            }
            catch (IOException e) {
                this.getLogger().log(e, this.LOG_CHANNEL, 2);
                throw new ServiceAccessException((Service)this, e.getMessage());
            }
            catch (RevisionAlreadyExistException e) {
                this.getLogger().log("RevisionAlreadyExistException encountered for " + revisionUri + " revision " + revisionNumber, this.LOG_CHANNEL, 4);
                throw e;
            }
            catch (Exception e) {
                this.getLogger().log(e, this.LOG_CHANNEL, 2);
                throw new ServiceAccessException((Service)this, e.getMessage());
            }
            Object var11_18 = null;
        }
        catch (Throwable throwable) {
            Object var11_19 = null;
            try {
                selectStatement.close();
            }
            catch (SQLException e) {
                this.getLogger().log(e, this.LOG_CHANNEL, 2);
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            throw throwable;
        }
        try {
            selectStatement.close();
        }
        catch (SQLException e) {
            this.getLogger().log(e, this.LOG_CHANNEL, 2);
            throw new ServiceAccessException((Service)this, (Throwable)e);
        }
    }

    protected long getBranchID(String branchName) throws SQLException {
        Connection connection = this.getCurrentConnection();
        Statement getStatement = connection.createStatement();
        StringBuffer theSQL = new StringBuffer("select BRANCH_ID from BRANCH where BRANCH_STRING = '");
        theSQL.append(branchName).append("'");
        ResultSet rslt = getStatement.executeQuery(theSQL.toString());
        if (rslt.next()) {
            return rslt.getLong("BRANCH_ID");
        }
        return 0L;
    }

    protected long getVersionID(long uri_id, String branch_name, String sXNumber) throws SQLException {
        Connection connection = this.getCurrentConnection();
        Statement getStatement = connection.createStatement();
        StringBuffer theSQL = new StringBuffer("select A.VERSION_ID from VERSION_HISTORY A, BRANCH B ");
        theSQL.append("where  A.URI_ID= ");
        theSQL.append(uri_id).append(" and A.BRANCH_ID = B.BRANCH_ID and B.BRANCH_STRING = '").append(branch_name).append("' and A.REVISION_NO= '").append(sXNumber).append("'");
        ResultSet rslt = getStatement.executeQuery(theSQL.toString());
        if (rslt.next()) {
            return rslt.getLong("VERSION_ID");
        }
        return 0L;
    }

    protected void removeContent(long version_id) throws SQLException {
        Connection connection = this.getCurrentConnection();
        Statement deleteStatement = connection.createStatement();
        StringBuffer theSQL = new StringBuffer("delete from VERSION_CONTENT where VERSION_ID = ");
        theSQL.append(version_id);
        deleteStatement.execute(theSQL.toString());
        deleteStatement.close();
    }

    public void removeRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException {
        String revisionUri = uri.toString();
        String revisionNumber = revisionDescriptor.getRevisionNumber().toString();
        try {
            long versionid = this.getVersionID(this.getUriId(revisionUri), revisionDescriptor.getBranchName(), revisionNumber);
            this.removeContent(versionid);
        }
        catch (Exception e) {
            this.getLogger().log(e, this.LOG_CHANNEL, 2);
            throw new ServiceAccessException((Service)this, e.getMessage());
        }
    }

    public NodeRevisionContent retrieveRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException, RevisionNotFoundException {
        Connection connection = this.getCurrentConnection();
        NodeRevisionContent result = null;
        String revisionUri = uri.toString();
        String revisionNumber = revisionDescriptor.getRevisionNumber() == null ? "NULL" : revisionDescriptor.getRevisionNumber().toString();
        Statement selectStatement = null;
        try {
            long versionid = this.getVersionID(this.getUriId(revisionUri), revisionDescriptor.getBranchName(), revisionNumber);
            selectStatement = connection.createStatement();
            StringBuffer theSQL = new StringBuffer("select CONTENT from VERSION_CONTENT where VERSION_ID = ");
            theSQL.append(versionid);
            ResultSet rs = selectStatement.executeQuery(theSQL.toString());
            if (!rs.next()) {
                rs.close();
                selectStatement.close();
                throw new RevisionNotFoundException(uri.toString(), revisionDescriptor.getRevisionNumber());
            }
            InputStream is = rs.getBinaryStream("CONTENT");
            if (is == null) {
                rs.close();
                selectStatement.close();
                throw new RevisionNotFoundException(uri.toString(), revisionDescriptor.getRevisionNumber());
            }
            result = new NodeRevisionContent();
            if (this.compressContent) {
                this.getLogger().log("DeCompressing the data", this.LOG_CHANNEL, 6);
                StoreContentZip ziputil = new StoreContentZip();
                ziputil.UnZip(is);
                revisionDescriptor.setContentLength(ziputil.getContentLength());
                is = ziputil.getInputStream();
            }
            result.setContent(is);
            result.setContent(new JDBCAwareInputStream(is, selectStatement));
            selectStatement.close();
        }
        catch (SQLException e) {
            this.getLogger().log(e, this.LOG_CHANNEL, 2);
            throw new ServiceAccessException((Service)this, e.getMessage());
        }
        catch (RevisionNotFoundException e) {
            this.getLogger().log("RevisionNotFoundException encountered for " + revisionUri + " revision " + revisionNumber, this.LOG_CHANNEL, 4);
            throw e;
        }
        catch (Exception e) {
            this.getLogger().log(e, this.LOG_CHANNEL, 2);
            throw new ServiceAccessException((Service)this, e.getMessage());
        }
        return result;
    }

    public synchronized void setParameters(Hashtable parameters) throws ServiceParameterErrorException, ServiceParameterMissingException {
        try {
            this.compressContent = ((String)parameters.get("compress")).equals("true");
            super.setParameters(parameters);
        }
        catch (Exception e) {
            this.getLogger().log(e.toString(), this.LOG_CHANNEL, 2);
        }
    }

    protected void setVersionID(long uri_id, long branch_id, String sXNumber) throws SQLException {
        Connection connection = this.getCurrentConnection();
        Statement insStatement = connection.createStatement();
        StringBuffer theSQL = new StringBuffer("SELECT 1 FROM VERSION WHERE URI_ID =");
        theSQL.append(uri_id);
        this.getLogger().log("Inside VersionID ==" + theSQL.toString(), this.LOG_CHANNEL, 7);
        ResultSet res = insStatement.executeQuery(theSQL.toString());
        if (!res.next()) {
            theSQL = new StringBuffer("insert into VERSION (URI_ID,IS_VERSIONED) values( ");
            theSQL.append(uri_id).append(", ").append(0).append(")");
            insStatement.execute(theSQL.toString());
        }
        theSQL = new StringBuffer("insert into VERSION_HISTORY (URI_ID,BRANCH_ID,REVISION_NO)");
        theSQL.append("values(");
        theSQL.append(uri_id).append(", ").append(branch_id).append(", '").append(sXNumber).append("')");
        insStatement.execute(theSQL.toString());
        insStatement.close();
    }

    protected void storeContent(String revisionUri, String revisionNumber, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws IOException, SQLException {
        Connection connection = this.getCurrentConnection();
        long versionid = this.getVersionID(this.getUriId(revisionUri), revisionDescriptor.getBranchName(), revisionNumber);
        if (versionid == 0L) {
            this.setVersionID(this.getUriId(revisionUri), this.getBranchID(revisionDescriptor.getBranchName()), revisionNumber);
            versionid = this.getVersionID(this.getUriId(revisionUri), revisionDescriptor.getBranchName(), revisionNumber);
        }
        PreparedStatement insertStatement = connection.prepareStatement("insert into VERSION_CONTENT values(?, ?)");
        insertStatement.setLong(1, versionid);
        InputStream is = revisionContent.streamContent();
        if (is != null) {
            long contentLength = 0L;
            if (this.compressContent) {
                this.getLogger().log("Compressing the data", this.LOG_CHANNEL, 6);
                StoreContentZip ziputil = new StoreContentZip();
                ziputil.Zip(is);
                is = ziputil.getInputStream();
                contentLength = ziputil.getContentLength();
            } else {
                contentLength = revisionDescriptor.getContentLength();
            }
            Object os = null;
            byte[] buffer = new byte[2048];
            long position = 0L;
            File tempFile = null;
            String tempFileName = null;
            if (contentLength == -1L) {
                try {
                    int nChar;
                    tempFileName = String.valueOf(revisionUri) + "-" + revisionNumber;
                    tempFileName = tempFileName.replace('/', '.');
                    int tempFileNameLength = tempFileName.length();
                    if (tempFileNameLength > 200) {
                        tempFileName = tempFileName.substring(tempFileNameLength - 200, tempFileNameLength);
                    }
                    tempFile = File.createTempFile(tempFileName, null);
                    FileOutputStream fos = new FileOutputStream(tempFile);
                    while ((nChar = is.read(buffer)) != -1) {
                        fos.write(buffer, 0, nChar);
                        position += (long)nChar;
                    }
                    fos.close();
                    is = new FileInputStream(tempFile);
                    contentLength = tempFile.length();
                }
                catch (IOException ex) {
                    this.getLogger().log(String.valueOf(ex.toString()) + " during the calculation of the content length.", this.LOG_CHANNEL, 2);
                    this.getLogger().log("tempFileName: " + tempFileName, this.LOG_CHANNEL, 2);
                    this.getLogger().log("tempFile: " + tempFile.getAbsolutePath(), this.LOG_CHANNEL, 2);
                    throw ex;
                }
            }
            insertStatement.setBinaryStream(2, is, (int)contentLength - 1);
            insertStatement.executeUpdate();
            revisionDescriptor.setContentLength(contentLength);
            if (tempFile != null) {
                is.close();
                tempFile.delete();
            }
        }
        insertStatement.close();
    }

    public void storeRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws ServiceAccessException, RevisionNotFoundException {
        Connection connection = this.getCurrentConnection();
        String revisionUri = uri.toString();
        String revisionNumber = revisionDescriptor.getRevisionNumber().toString();
        Statement selectStatement = null;
        try {
            try {
                long versionid = this.getVersionID(this.getUriId(revisionUri), revisionDescriptor.getBranchName(), revisionNumber);
                selectStatement = connection.createStatement();
                StringBuffer theSQL = new StringBuffer("select 1 from VERSION_CONTENT where VERSION_ID = ");
                theSQL.append(versionid);
                ResultSet rs = selectStatement.executeQuery(theSQL.toString());
                if (!rs.next()) {
                    rs.close();
                    throw new RevisionNotFoundException(uri.toString(), revisionDescriptor.getRevisionNumber());
                }
                rs.close();
                this.removeRevisionContent(uri, revisionDescriptor);
                this.storeContent(revisionUri, revisionNumber, revisionDescriptor, revisionContent);
            }
            catch (SQLException e) {
                this.getLogger().log(e, this.LOG_CHANNEL, 2);
                throw new ServiceAccessException((Service)this, e.getMessage());
            }
            catch (IOException e) {
                this.getLogger().log(e, this.LOG_CHANNEL, 2);
                throw new ServiceAccessException((Service)this, e.getMessage());
            }
            catch (RevisionNotFoundException e) {
                this.getLogger().log("RevisionNotFoundException encountered for " + revisionUri + " revision " + revisionNumber, this.LOG_CHANNEL, 4);
                throw e;
            }
            catch (Exception e) {
                this.getLogger().log(e, this.LOG_CHANNEL, 2);
                throw new ServiceAccessException((Service)this, e.getMessage());
            }
            Object var9_17 = null;
        }
        catch (Throwable throwable) {
            Object var9_18 = null;
            try {
                selectStatement.close();
            }
            catch (SQLException e) {
                this.getLogger().log(e, this.LOG_CHANNEL, 2);
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            throw throwable;
        }
        try {
            selectStatement.close();
        }
        catch (SQLException e) {
            this.getLogger().log(e, this.LOG_CHANNEL, 2);
            throw new ServiceAccessException((Service)this, (Throwable)e);
        }
    }
}

