/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.lock;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import org.apache.slide.common.ObjectValidationFailedException;
import org.apache.slide.structure.ActionNode;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.SubjectNode;
import org.apache.slide.util.Messages;
import org.apache.util.MD5Encoder;

public final class NodeLock
implements Cloneable,
Serializable {
    protected String objectUri;
    protected String subjectUri;
    protected String typeUri;
    protected Date expirationDate;
    protected boolean inheritance;
    protected boolean exclusive;
    protected String lockId;
    protected static MessageDigest md5Helper;
    protected static final MD5Encoder md5Encoder;
    static /* synthetic */ Class class$org$apache$slide$lock$NodeLock;

    static {
        md5Encoder = new MD5Encoder();
        try {
            md5Helper = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new IllegalStateException();
        }
    }

    public NodeLock() {
    }

    public NodeLock(String lockId, String objectUri, String subjectUri, String typeUri, Date expirationDate, boolean inheritance, boolean exclusive) {
        this.objectUri = objectUri;
        this.subjectUri = subjectUri;
        this.typeUri = typeUri;
        this.expirationDate = expirationDate;
        this.inheritance = inheritance;
        this.lockId = lockId;
        this.exclusive = exclusive;
    }

    public NodeLock(String objectUri, String subjectUri, String typeUri, Date expirationDate, boolean inheritance) {
        this(objectUri, subjectUri, typeUri, expirationDate, inheritance, true);
    }

    public NodeLock(String objectUri, String subjectUri, String typeUri, Date expirationDate, boolean inheritance, boolean exclusive) {
        this.objectUri = objectUri;
        this.subjectUri = subjectUri;
        this.typeUri = typeUri;
        this.expirationDate = expirationDate;
        this.inheritance = inheritance;
        this.lockId = String.valueOf(objectUri.hashCode()) + "_" + subjectUri.hashCode() + "_" + typeUri.hashCode() + "_" + expirationDate.getTime() + "_" + new Date().getTime();
        this.lockId = md5Encoder.encode(md5Helper.digest(this.lockId.getBytes()));
        this.exclusive = exclusive;
    }

    public NodeLock(NodeLock lock, String typeUri) {
        this(lock.getLockId(), lock.getObjectUri(), lock.getSubjectUri(), typeUri, lock.getExpirationDate(), lock.isInheritable(), lock.isExclusive());
    }

    public NodeLock(ObjectNode locked, SubjectNode user, ActionNode lockType, Date expirationDate, boolean inheritance) {
        this(locked.getUri(), user.getUri(), lockType.getUri(), expirationDate, inheritance);
    }

    public NodeLock(ObjectNode locked, SubjectNode user, ActionNode lockType, Date expirationDate, boolean inheritance, boolean exclusive) {
        this(locked.getUri(), user.getUri(), lockType.getUri(), expirationDate, inheritance, exclusive);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public NodeLock cloneObject() {
        NodeLock result = null;
        try {
            result = (NodeLock)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj != null && obj instanceof NodeLock) {
            NodeLock lock = (NodeLock)obj;
            result = this.getLockId().equals(lock.getLockId());
        }
        return result;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public String getLockId() {
        return this.lockId;
    }

    public String getObjectUri() {
        return this.objectUri;
    }

    public String getSubjectUri() {
        return this.subjectUri;
    }

    public String getTypeUri() {
        return this.typeUri;
    }

    public boolean hasExpired() {
        Date currentTime = new Date();
        return this.expirationDate.before(new Date());
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public boolean isInheritable() {
        return this.inheritance;
    }

    public boolean isShared() {
        return this.exclusive ^ true;
    }

    void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }

    void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    void setInheritable(boolean inheritance) {
        this.inheritance = inheritance;
    }

    void setObjectUri(String objectUri) {
        this.objectUri = objectUri;
    }

    void setSubjectUri(String subjectUri) {
        this.subjectUri = subjectUri;
    }

    void setTypeUri(String typeUri) {
        this.typeUri = typeUri;
    }

    public void validate(String expectedUri) {
        if (this.objectUri == null) {
            throw new ObjectValidationFailedException(expectedUri, Messages.message(String.valueOf((class$org$apache$slide$lock$NodeLock != null ? class$org$apache$slide$lock$NodeLock : (class$org$apache$slide$lock$NodeLock = NodeLock.class$("org.apache.slide.lock.NodeLock"))).getName()) + ".nullObjectUri"));
        }
        if (!this.objectUri.equals(expectedUri)) {
            throw new ObjectValidationFailedException(expectedUri, Messages.message(String.valueOf((class$org$apache$slide$lock$NodeLock != null ? class$org$apache$slide$lock$NodeLock : (class$org$apache$slide$lock$NodeLock = NodeLock.class$("org.apache.slide.lock.NodeLock"))).getName()) + ".incorrectObjectUri"));
        }
        if (this.subjectUri == null) {
            throw new ObjectValidationFailedException(expectedUri, Messages.message(String.valueOf((class$org$apache$slide$lock$NodeLock != null ? class$org$apache$slide$lock$NodeLock : (class$org$apache$slide$lock$NodeLock = NodeLock.class$("org.apache.slide.lock.NodeLock"))).getName()) + ".nullSubjectUri"));
        }
        if (this.typeUri == null) {
            throw new ObjectValidationFailedException(expectedUri, Messages.message(String.valueOf((class$org$apache$slide$lock$NodeLock != null ? class$org$apache$slide$lock$NodeLock : (class$org$apache$slide$lock$NodeLock = NodeLock.class$("org.apache.slide.lock.NodeLock"))).getName()) + ".nullTypeUri"));
        }
        if (this.expirationDate == null) {
            throw new ObjectValidationFailedException(expectedUri, Messages.message(String.valueOf((class$org$apache$slide$lock$NodeLock != null ? class$org$apache$slide$lock$NodeLock : (class$org$apache$slide$lock$NodeLock = NodeLock.class$("org.apache.slide.lock.NodeLock"))).getName()) + ".nullExpirationDate"));
        }
        if (this.lockId == null) {
            throw new ObjectValidationFailedException(expectedUri, Messages.message(String.valueOf((class$org$apache$slide$lock$NodeLock != null ? class$org$apache$slide$lock$NodeLock : (class$org$apache$slide$lock$NodeLock = NodeLock.class$("org.apache.slide.lock.NodeLock"))).getName()) + ".nullLockId"));
        }
    }
}

