/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.lock;

import java.util.Date;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import org.apache.slide.common.Namespace;
import org.apache.slide.common.NamespaceConfig;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.common.Uri;
import org.apache.slide.lock.Lock;
import org.apache.slide.lock.LockTokenNotFoundException;
import org.apache.slide.lock.NodeLock;
import org.apache.slide.lock.ObjectIsAlreadyLockedException;
import org.apache.slide.lock.ObjectLockedException;
import org.apache.slide.security.AccessDeniedException;
import org.apache.slide.security.Security;
import org.apache.slide.structure.ActionNode;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.structure.SubjectNode;
import org.apache.slide.util.Configuration;

public final class LockImpl
implements Lock {
    private Namespace namespace;
    private NamespaceConfig namespaceConfig;
    private Security securityHelper;

    public LockImpl(Namespace namespace, NamespaceConfig namespaceConfig, Security securityHelper) {
        this.namespace = namespace;
        this.namespaceConfig = namespaceConfig;
        this.securityHelper = securityHelper;
    }

    public void checkLock(SlideToken token, ObjectNode object, ActionNode action) throws ServiceAccessException, ObjectNotFoundException, ObjectLockedException {
        if (Configuration.useIntegratedLocking()) {
            Uri objectUri = this.namespace.getUri(token, object.getUri());
            ObjectNode realObject = objectUri.getStore().retrieveObject(objectUri);
            Uri subjectUri = null;
            subjectUri = this.namespace.getUri(token, String.valueOf(this.namespaceConfig.getUsersPath()) + "/" + token.getCredentialsToken().getPublicCredentials());
            SubjectNode subject = (SubjectNode)subjectUri.getStore().retrieveObject(subjectUri);
            this.checkLock(token, realObject, subject, action);
        }
    }

    public void checkLock(SlideToken slideToken, ObjectNode subject, SubjectNode user, ActionNode action) throws ServiceAccessException, ObjectNotFoundException, ObjectLockedException {
        if (Configuration.useIntegratedLocking() && this.isLocked(slideToken, subject, user, action, false)) {
            throw new ObjectLockedException(subject.getUri());
        }
    }

    private boolean checkLockToken(SlideToken slideToken, NodeLock token) {
        if (!slideToken.isEnforceLockTokens()) {
            return true;
        }
        return slideToken.checkLockToken(token.getLockId());
    }

    public Enumeration enumerateLocks(SlideToken slideToken, String objectUri) throws ServiceAccessException, ObjectNotFoundException, LockTokenNotFoundException {
        return this.enumerateLocks(slideToken, objectUri, true);
    }

    public Enumeration enumerateLocks(SlideToken slideToken, String objectUri, boolean inherited) throws ServiceAccessException, ObjectNotFoundException, LockTokenNotFoundException {
        Uri subjectUri = this.namespace.getUri(slideToken, objectUri);
        Enumeration scopes = null;
        if (inherited) {
            scopes = subjectUri.getScopes();
        } else {
            Vector<String> scopeVector = new Vector<String>();
            scopeVector.add(subjectUri.toString());
            scopes = scopeVector.elements();
        }
        Vector<NodeLock> locksVector = new Vector<NodeLock>();
        while (scopes.hasMoreElements()) {
            String currentScope = (String)scopes.nextElement();
            Uri currentScopeUri = this.namespace.getUri(slideToken, currentScope);
            Enumeration currentLocks = currentScopeUri.getStore().enumerateLocks(currentScopeUri);
            while (currentLocks.hasMoreElements()) {
                NodeLock currentLockToken = (NodeLock)currentLocks.nextElement();
                if (currentLockToken.hasExpired()) {
                    try {
                        currentScopeUri.getStore().removeLock(currentScopeUri, currentLockToken);
                    }
                    catch (LockTokenNotFoundException lockTokenNotFoundException) {}
                    continue;
                }
                locksVector.addElement(currentLockToken);
            }
        }
        return locksVector.elements();
    }

    private boolean isCompatible(SlideToken slideToken, NodeLock token1, NodeLock token2, boolean tryToLock) {
        boolean compatible = true;
        if (token2.hasExpired()) {
            try {
                Uri token2Uri = this.namespace.getUri(slideToken, token2.getObjectUri());
                token2Uri.getStore().removeLock(token2Uri, token2);
            }
            catch (SlideException e) {
                e.printStackTrace();
            }
        } else {
            boolean condition1 = tryToLock && token2.getTypeUri().equals(token1.getTypeUri());
            boolean condition2 = token1.getSubjectUri().startsWith(token2.getSubjectUri());
            boolean condition3 = token2.getTypeUri().startsWith(token1.getTypeUri());
            boolean condition4 = token1.isExclusive();
            boolean condition5 = this.checkLockToken(slideToken, token2);
            boolean condition6 = slideToken.isEnforceLockTokens();
            if (condition1 && condition4 || condition3 && !condition2 && !condition6 || condition3 && !condition5 && condition6) {
                compatible = false;
            }
        }
        return compatible;
    }

    public boolean isLocked(SlideToken slideToken, NodeLock token, boolean tryToLock) throws ServiceAccessException, ObjectNotFoundException {
        return this.isLockedInternal(slideToken, token, tryToLock, null);
    }

    public boolean isLocked(SlideToken slideToken, ObjectNode subject, SubjectNode user, ActionNode action, boolean tryToLock) throws ServiceAccessException, ObjectNotFoundException {
        NodeLock token = new NodeLock(subject, user, action, new Date(), false);
        return this.isLocked(slideToken, token, tryToLock);
    }

    public boolean isLocked(SlideToken slideToken, ObjectNode subject, SubjectNode user, ActionNode action, boolean inheritance, boolean tryToLock) throws ServiceAccessException, ObjectNotFoundException {
        NodeLock token = new NodeLock(subject, user, action, new Date(), inheritance);
        return this.isLocked(slideToken, token, tryToLock);
    }

    private boolean isLockedInternal(SlideToken slideToken, NodeLock token, boolean tryToLock, ObjectIsAlreadyLockedException nestedException) throws ServiceAccessException, ObjectNotFoundException {
        Uri objectUri = this.namespace.getUri(slideToken, token.getObjectUri(), false);
        ObjectNode initialObject = objectUri.getStore().retrieveObject(objectUri);
        Enumeration scopes = objectUri.getScopes();
        boolean isLocked = false;
        while (!isLocked && scopes.hasMoreElements()) {
            String currentScope = (String)scopes.nextElement();
            Uri currentScopeUri = this.namespace.getUri(slideToken, currentScope, false);
            Enumeration locks = currentScopeUri.getStore().enumerateLocks(currentScopeUri);
            while (locks.hasMoreElements()) {
                NodeLock currentLockToken = (NodeLock)locks.nextElement();
                if (this.isCompatible(slideToken, token, currentLockToken, tryToLock)) continue;
                isLocked = true;
                if (nestedException == null) continue;
                nestedException.addException(new ObjectLockedException(currentScopeUri.toString()));
            }
        }
        if (token.isInheritable()) {
            Stack<ObjectNode> childrenStack = new Stack<ObjectNode>();
            childrenStack.push(initialObject);
            while (!isLocked && !childrenStack.empty()) {
                ObjectNode currentObject = (ObjectNode)childrenStack.pop();
                Uri currentObjectUri = this.namespace.getUri(slideToken, currentObject.getUri(), false);
                Enumeration locks = currentObjectUri.getStore().enumerateLocks(currentObjectUri);
                while (locks.hasMoreElements()) {
                    NodeLock currentLockToken = (NodeLock)locks.nextElement();
                    if (this.isCompatible(slideToken, token, currentLockToken, tryToLock)) continue;
                    isLocked = true;
                    if (nestedException == null) continue;
                    nestedException.addException(new ObjectLockedException(currentObjectUri.toString()));
                }
                Vector<ObjectNode> childrenVector = new Vector<ObjectNode>();
                Enumeration childrenUri = currentObject.enumerateChildren();
                while (childrenUri.hasMoreElements()) {
                    String childUri = (String)childrenUri.nextElement();
                    Uri tempUri = this.namespace.getUri(slideToken, childUri, false);
                    ObjectNode child = tempUri.getStore().retrieveObject(tempUri);
                    childrenVector.addElement(child);
                }
                Enumeration children = childrenVector.elements();
                while (children.hasMoreElements()) {
                    ObjectNode tempObject = (ObjectNode)children.nextElement();
                    childrenStack.push(tempObject);
                }
            }
        }
        return isLocked;
    }

    public void kill(SlideToken slideToken, SubjectNode subject) throws ServiceAccessException, AccessDeniedException, LockTokenNotFoundException, ObjectNotFoundException {
        Uri subjectUri = this.namespace.getUri(slideToken, subject.getUri());
        Enumeration locks = subjectUri.getStore().enumerateLocks(subjectUri);
        while (locks.hasMoreElements()) {
            this.securityHelper.checkCredentials(slideToken, subject, this.namespaceConfig.getKillLockAction());
            subjectUri.getStore().killLock(subjectUri, (NodeLock)locks.nextElement());
        }
    }

    public void lock(SlideToken slideToken, NodeLock token) throws ServiceAccessException, ObjectIsAlreadyLockedException, AccessDeniedException, ObjectNotFoundException {
        ObjectIsAlreadyLockedException nestedException = new ObjectIsAlreadyLockedException(token.getObjectUri());
        Uri objectUri = this.namespace.getUri(slideToken, token.getObjectUri(), true);
        boolean canLock = this.isLockedInternal(slideToken, token, true, nestedException) ^ true;
        if (!canLock) {
            throw nestedException;
        }
        ObjectNode lockedObject = objectUri.getStore().retrieveObject(objectUri);
        this.securityHelper.checkCredentials(slideToken, lockedObject, this.namespaceConfig.getLockObjectAction());
        objectUri.getStore().putLock(objectUri, token);
    }

    public void renew(SlideToken slideToken, String objectUri, String lockId, Date newExpirationDate) throws ServiceAccessException, LockTokenNotFoundException, ObjectNotFoundException {
        Enumeration locksList = this.enumerateLocks(slideToken, objectUri, false);
        while (locksList.hasMoreElements()) {
            NodeLock currentLock = (NodeLock)locksList.nextElement();
            if (!currentLock.getLockId().equals(lockId)) continue;
            this.renew(slideToken, currentLock, newExpirationDate);
        }
    }

    public void renew(SlideToken slideToken, NodeLock token, Date newExpirationDate) throws ServiceAccessException, LockTokenNotFoundException {
        token.setExpirationDate(newExpirationDate);
        Uri lockedUri = this.namespace.getUri(slideToken, token.getObjectUri());
        lockedUri.getStore().renewLock(lockedUri, token);
    }

    public void unlock(SlideToken slideToken, String objectUri, String lockId) throws ServiceAccessException, LockTokenNotFoundException, ObjectNotFoundException {
        Enumeration locksList = this.enumerateLocks(slideToken, objectUri, false);
        while (locksList.hasMoreElements()) {
            NodeLock currentLock = (NodeLock)locksList.nextElement();
            if (!currentLock.getLockId().equals(lockId)) continue;
            if (slideToken.isEnforceLockTokens()) {
                slideToken.addLockToken(lockId);
            }
            this.unlock(slideToken, currentLock);
        }
    }

    public boolean unlock(SlideToken slideToken, NodeLock token) throws ServiceAccessException, LockTokenNotFoundException {
        try {
            if (!slideToken.isEnforceLockTokens()) {
                ObjectNode principal = this.securityHelper.getPrincipal(slideToken);
                if (!token.getSubjectUri().startsWith(principal.getUri())) {
                    return false;
                }
            } else if (!this.checkLockToken(slideToken, token)) {
                return false;
            }
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            return false;
        }
        Uri lockedUri = this.namespace.getUri(slideToken, token.getObjectUri(), true);
        lockedUri.getStore().removeLock(lockedUri, token);
        return true;
    }
}

