/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.common;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.slide.authenticate.CredentialsToken;
import org.apache.slide.common.CacheInfoToken;
import org.apache.slide.common.SlideToken;

public final class SlideTokenImpl
implements SlideToken {
    private CredentialsToken credentialsToken;
    private CacheInfoToken cacheInfoToken;
    private boolean enforceLockTokens = false;
    private boolean forceStoreEnlistment = false;
    private Hashtable lockTokens = new Hashtable();
    private Hashtable parameters = new Hashtable();

    public SlideTokenImpl() {
    }

    public SlideTokenImpl(CredentialsToken credentialsToken) {
        this.credentialsToken = credentialsToken;
    }

    public SlideTokenImpl(CredentialsToken credentialsToken, Hashtable parameters) {
        this.credentialsToken = credentialsToken;
        this.parameters = parameters;
    }

    public void addLockToken(String lockId) {
        this.lockTokens.put(lockId, lockId);
    }

    public void addParameter(String parameterName, Object parameterValue) {
        this.parameters.put(parameterName, parameterValue);
    }

    public boolean checkLockToken(String lockToken) {
        return this.lockTokens.containsKey(lockToken);
    }

    public void clearLockTokens() {
        this.lockTokens.clear();
    }

    public void clearParameters() {
        this.parameters.clear();
    }

    public CacheInfoToken getCacheInfoToken() {
        return this.cacheInfoToken;
    }

    public CredentialsToken getCredentialsToken() {
        return this.credentialsToken;
    }

    public Enumeration getParameterNames() {
        return this.parameters.keys();
    }

    public boolean isEnforceLockTokens() {
        return this.enforceLockTokens;
    }

    public boolean isForceStoreEnlistment() {
        return this.forceStoreEnlistment;
    }

    public void removeLockToken(String lockId) {
        this.lockTokens.remove(lockId);
    }

    public void removeParameter(String parameterName) {
        this.parameters.remove(parameterName);
    }

    public void setCacheInfoToken(CacheInfoToken cacheInfoToken) {
        this.cacheInfoToken = cacheInfoToken;
    }

    public void setCredentialsToken(CredentialsToken credentialsToken) {
        this.credentialsToken = credentialsToken;
    }

    public void setEnforceLockTokens(boolean enforceLockTokens) {
        this.enforceLockTokens = enforceLockTokens;
    }

    public void setForceStoreEnlistment(boolean forceStoreEnlistment) {
        this.forceStoreEnlistment = forceStoreEnlistment;
    }
}

