/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;

public abstract class Lock {
    public abstract boolean obtain() throws IOException;

    public abstract void release();

    public static abstract class With {
        private Lock lock;
        private int sleepInterval = 1000;
        private int maxSleeps = 10;

        public With(Lock lock) {
            this.lock = lock;
        }

        protected abstract Object doBody() throws IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object run() throws IOException {
            boolean locked = false;
            try {
                locked = this.lock.obtain();
                int sleepCount = 0;
                while (!locked) {
                    if (++sleepCount == this.maxSleeps) {
                        throw new IOException("Timed out waiting for: " + this.lock);
                    }
                    try {
                        Thread.sleep(this.sleepInterval);
                    }
                    catch (InterruptedException e) {
                        throw new IOException(e.toString());
                    }
                    locked = this.lock.obtain();
                }
                Object object = this.doBody();
                Object var5_5 = null;
                if (locked) {
                    this.lock.release();
                }
                return object;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var5_6 = null;
                    if (!locked) break block7;
                    this.lock.release();
                }
                throw throwable;
            }
        }
    }
}

