/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.TermScorer;
import org.apache.lucene.search.Weight;

public class TermQuery
extends Query {
    private Term term;

    public TermQuery(Term t) {
        this.term = t;
    }

    public Term getTerm() {
        return this.term;
    }

    protected Weight createWeight(Searcher searcher) {
        return new TermWeight(searcher);
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        if (!this.term.field().equals(field)) {
            buffer.append(this.term.field());
            buffer.append(":");
        }
        buffer.append(this.term.text());
        if (this.getBoost() != 1.0f) {
            buffer.append("^");
            buffer.append(Float.toString(this.getBoost()));
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof TermQuery)) {
            return false;
        }
        TermQuery other = (TermQuery)o;
        return this.getBoost() == other.getBoost() && this.term.equals(other.term);
    }

    public int hashCode() {
        return Float.floatToIntBits(this.getBoost()) ^ this.term.hashCode();
    }

    private class TermWeight
    implements Weight {
        private Searcher searcher;
        private float value;
        private float idf;
        private float queryNorm;
        private float queryWeight;

        public TermWeight(Searcher searcher) {
            this.searcher = searcher;
        }

        public Query getQuery() {
            return TermQuery.this;
        }

        public float getValue() {
            return this.value;
        }

        public float sumOfSquaredWeights() throws IOException {
            this.idf = this.searcher.getSimilarity().idf(TermQuery.this.term, this.searcher);
            this.queryWeight = this.idf * TermQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        public void normalize(float queryNorm) {
            this.queryNorm = queryNorm;
            this.queryWeight *= queryNorm;
            this.value = this.queryWeight * this.idf;
        }

        public Scorer scorer(IndexReader reader) throws IOException {
            TermDocs termDocs = reader.termDocs(TermQuery.this.term);
            if (termDocs == null) {
                return null;
            }
            return new TermScorer(this, termDocs, this.searcher.getSimilarity(), reader.norms(TermQuery.this.term.field()));
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            Explanation result = new Explanation();
            result.setDescription("weight(" + this.getQuery() + " in " + doc + "), product of:");
            Explanation idfExpl = new Explanation(this.idf, "idf(docFreq=" + this.searcher.docFreq(TermQuery.this.term) + ")");
            Explanation queryExpl = new Explanation();
            queryExpl.setDescription("queryWeight(" + this.getQuery() + "), product of:");
            Explanation boostExpl = new Explanation(TermQuery.this.getBoost(), "boost");
            if (TermQuery.this.getBoost() != 1.0f) {
                queryExpl.addDetail(boostExpl);
            }
            queryExpl.addDetail(idfExpl);
            Explanation queryNormExpl = new Explanation(this.queryNorm, "queryNorm");
            queryExpl.addDetail(queryNormExpl);
            queryExpl.setValue(boostExpl.getValue() * idfExpl.getValue() * queryNormExpl.getValue());
            result.addDetail(queryExpl);
            String field = TermQuery.this.term.field();
            Explanation fieldExpl = new Explanation();
            fieldExpl.setDescription("fieldWeight(" + TermQuery.this.term + " in " + doc + "), product of:");
            Explanation tfExpl = this.scorer(reader).explain(doc);
            fieldExpl.addDetail(tfExpl);
            fieldExpl.addDetail(idfExpl);
            Explanation fieldNormExpl = new Explanation();
            fieldNormExpl.setValue(Similarity.decodeNorm(reader.norms(field)[doc]));
            fieldNormExpl.setDescription("fieldNorm(field=" + field + ", doc=" + doc + ")");
            fieldExpl.addDetail(fieldNormExpl);
            fieldExpl.setValue(tfExpl.getValue() * idfExpl.getValue() * fieldNormExpl.getValue());
            result.addDetail(fieldExpl);
            result.setValue(queryExpl.getValue() * fieldExpl.getValue());
            if (queryExpl.getValue() == 1.0f) {
                return fieldExpl;
            }
            return result;
        }
    }
}

