/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class RangeQuery
extends Query {
    private Term lowerTerm;
    private Term upperTerm;
    private boolean inclusive;

    public RangeQuery(Term lowerTerm, Term upperTerm, boolean inclusive) {
        if (lowerTerm == null && upperTerm == null) {
            throw new IllegalArgumentException("At least one term must be non-null");
        }
        if (lowerTerm != null && upperTerm != null && lowerTerm.field() != upperTerm.field()) {
            throw new IllegalArgumentException("Both terms must be for the same field");
        }
        this.lowerTerm = lowerTerm;
        this.upperTerm = upperTerm;
        this.inclusive = inclusive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query rewrite(IndexReader reader) throws IOException {
        BooleanQuery query = new BooleanQuery();
        if (this.lowerTerm == null) {
            this.lowerTerm = new Term(this.getField(), "");
        }
        TermEnum termEnum = reader.terms(this.lowerTerm);
        try {
            Term term;
            String lowerText = null;
            boolean checkLower = false;
            if (!this.inclusive) {
                if (this.lowerTerm != null) {
                    lowerText = this.lowerTerm.text();
                    checkLower = true;
                }
                if (this.upperTerm != null) {
                    TermEnum uppEnum = reader.terms(this.upperTerm);
                    this.upperTerm = uppEnum.term();
                }
            }
            String testField = this.getField();
            while ((term = termEnum.term()) != null && term.field() == testField) {
                if (!checkLower || term.text().compareTo(lowerText) > 0) {
                    int compare;
                    checkLower = false;
                    if (this.upperTerm != null && ((compare = this.upperTerm.compareTo(term)) < 0 || !this.inclusive && compare == 0)) break;
                    TermQuery tq = new TermQuery(term);
                    tq.setBoost(this.getBoost());
                    query.add(tq, false, false);
                }
                if (termEnum.next()) continue;
                break;
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            termEnum.close();
            throw throwable;
        }
        termEnum.close();
        return query;
    }

    public Query combine(Query[] queries) {
        return Query.mergeBooleanQueries(queries);
    }

    private String getField() {
        return this.lowerTerm != null ? this.lowerTerm.field() : this.upperTerm.field();
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        if (!this.getField().equals(field)) {
            buffer.append(this.getField());
            buffer.append(":");
        }
        buffer.append(this.inclusive ? "[" : "{");
        buffer.append(this.lowerTerm != null ? this.lowerTerm.text() : "null");
        buffer.append("-");
        buffer.append(this.upperTerm != null ? this.upperTerm.text() : "null");
        buffer.append(this.inclusive ? "]" : "}");
        if (this.getBoost() != 1.0f) {
            buffer.append("^");
            buffer.append(Float.toString(this.getBoost()));
        }
        return buffer.toString();
    }
}

