/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.PhrasePositions;
import org.apache.lucene.search.PhraseQueue;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

abstract class PhraseScorer
extends Scorer {
    private Weight weight;
    protected byte[] norms;
    protected float value;
    protected PhraseQueue pq;
    protected PhrasePositions first;
    protected PhrasePositions last;
    private float freq;

    PhraseScorer(Weight weight, TermPositions[] tps, Similarity similarity, byte[] norms) throws IOException {
        super(similarity);
        this.norms = norms;
        this.weight = weight;
        this.value = weight.getValue();
        this.pq = new PhraseQueue(tps.length);
        int i = 0;
        while (i < tps.length) {
            this.pq.put(new PhrasePositions(tps[i], i));
            ++i;
        }
        this.pqToList();
    }

    /*
     * Unable to fully structure code
     */
    public final void score(HitCollector results, int end) throws IOException {
        similarity = this.getSimilarity();
        ** GOTO lbl15
lbl-1000:
        // 2 sources

        {
            this.first.next();
            if (this.first.doc < this.last.doc) ** GOTO lbl-1000
            this.firstToLast();
            if (this.last.doc >= end) {
                return;
            }
            do {
                if (this.first.doc < this.last.doc) continue block0;
                this.freq = this.phraseFreq();
                if ((double)this.freq > 0.0) {
                    score = similarity.tf(this.freq) * this.value;
                    results.collect(this.first.doc, score *= Similarity.decodeNorm(this.norms[this.first.doc]));
                }
                this.last.next();
lbl15:
                // 2 sources

            } while (this.last.doc < end);
        }
    }

    protected abstract float phraseFreq() throws IOException;

    protected final void pqToList() {
        this.first = null;
        this.last = null;
        while (this.pq.top() != null) {
            PhrasePositions pp = (PhrasePositions)this.pq.pop();
            if (this.last != null) {
                this.last.next = pp;
            } else {
                this.first = pp;
            }
            this.last = pp;
            pp.next = null;
        }
    }

    protected final void firstToLast() {
        this.last.next = this.first;
        this.last = this.first;
        this.first = this.first.next;
        this.last.next = null;
    }

    public Explanation explain(int doc) throws IOException {
        Explanation tfExplanation = new Explanation();
        this.score(new HitCollector(){

            public final void collect(int d, float score) {
            }
        }, doc + 1);
        float phraseFreq = this.first.doc == doc ? this.freq : 0.0f;
        tfExplanation.setValue(this.getSimilarity().tf(phraseFreq));
        tfExplanation.setDescription("tf(phraseFreq=" + phraseFreq + ")");
        return tfExplanation;
    }
}

