/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.BitSet;
import java.util.Date;
import org.apache.lucene.document.DateField;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.Filter;

public class DateFilter
extends Filter {
    String field;
    String start = DateField.MIN_DATE_STRING();
    String end = DateField.MAX_DATE_STRING();

    private DateFilter(String f) {
        this.field = f;
    }

    public DateFilter(String f, Date from, Date to) {
        this.field = f;
        this.start = DateField.dateToString(from);
        this.end = DateField.dateToString(to);
    }

    public DateFilter(String f, long from, long to) {
        this.field = f;
        this.start = DateField.timeToString(from);
        this.end = DateField.timeToString(to);
    }

    public static DateFilter Before(String field, Date date) {
        DateFilter result = new DateFilter(field);
        result.end = DateField.dateToString(date);
        return result;
    }

    public static DateFilter Before(String field, long time) {
        DateFilter result = new DateFilter(field);
        result.end = DateField.timeToString(time);
        return result;
    }

    public static DateFilter After(String field, Date date) {
        DateFilter result = new DateFilter(field);
        result.start = DateField.dateToString(date);
        return result;
    }

    public static DateFilter After(String field, long time) {
        DateFilter result = new DateFilter(field);
        result.start = DateField.timeToString(time);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BitSet bits(IndexReader reader) throws IOException {
        BitSet bits = new BitSet(reader.maxDoc());
        TermEnum termEnum = reader.terms(new Term(this.field, this.start));
        TermDocs termDocs = reader.termDocs();
        if (termEnum.term() == null) {
            return bits;
        }
        try {
            Term stop = new Term(this.field, this.end);
            while (termEnum.term().compareTo(stop) <= 0) {
                Object var7_6;
                termDocs.seek(termEnum.term());
                try {
                    while (termDocs.next()) {
                        bits.set(termDocs.doc());
                    }
                    var7_6 = null;
                }
                catch (Throwable throwable) {
                    var7_6 = null;
                    termDocs.close();
                    throw throwable;
                }
                termDocs.close();
                if (termEnum.next()) continue;
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            termEnum.close();
            throw throwable;
        }
        termEnum.close();
        return bits;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.field);
        buffer.append(":");
        buffer.append(DateField.stringToDate(this.start).toString());
        buffer.append("-");
        buffer.append(DateField.stringToDate(this.end).toString());
        return buffer.toString();
    }
}

