/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.SegmentsTermDocs;
import org.apache.lucene.index.SegmentsTermEnum;
import org.apache.lucene.index.SegmentsTermPositions;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.store.Directory;

final class SegmentsReader
extends IndexReader {
    protected SegmentReader[] readers;
    protected int[] starts;
    private Hashtable normsCache = new Hashtable();
    private int maxDoc = 0;
    private int numDocs = -1;

    SegmentsReader(Directory directory, SegmentReader[] r) throws IOException {
        super(directory);
        this.readers = r;
        this.starts = new int[this.readers.length + 1];
        int i = 0;
        while (i < this.readers.length) {
            this.starts[i] = this.maxDoc;
            this.maxDoc += this.readers[i].maxDoc();
            ++i;
        }
        this.starts[this.readers.length] = this.maxDoc;
    }

    public final synchronized int numDocs() {
        if (this.numDocs == -1) {
            int n = 0;
            int i = 0;
            while (i < this.readers.length) {
                n += this.readers[i].numDocs();
                ++i;
            }
            this.numDocs = n;
        }
        return this.numDocs;
    }

    public final int maxDoc() {
        return this.maxDoc;
    }

    public final Document document(int n) throws IOException {
        int i = this.readerIndex(n);
        return this.readers[i].document(n - this.starts[i]);
    }

    public final boolean isDeleted(int n) {
        int i = this.readerIndex(n);
        return this.readers[i].isDeleted(n - this.starts[i]);
    }

    final synchronized void doDelete(int n) throws IOException {
        this.numDocs = -1;
        int i = this.readerIndex(n);
        this.readers[i].doDelete(n - this.starts[i]);
    }

    /*
     * Unable to fully structure code
     */
    private final int readerIndex(int n) {
        lo = 0;
        hi = this.readers.length - 1;
        while (hi >= lo) {
            mid = lo + hi >> 1;
            midValue = this.starts[mid];
            if (n < midValue) {
                hi = mid - 1;
                continue;
            }
            if (n <= midValue) ** GOTO lbl13
            lo = mid + 1;
            continue;
lbl-1000:
            // 1 sources

            {
                ++mid;
lbl13:
                // 2 sources

                ** while (mid + 1 < this.readers.length && this.starts[mid + 1] == midValue)
            }
lbl14:
            // 1 sources

            return mid;
        }
        return hi;
    }

    public final synchronized byte[] norms(String field) throws IOException {
        byte[] bytes = (byte[])this.normsCache.get(field);
        if (bytes != null) {
            return bytes;
        }
        bytes = new byte[this.maxDoc()];
        int i = 0;
        while (i < this.readers.length) {
            this.readers[i].norms(field, bytes, this.starts[i]);
            ++i;
        }
        this.normsCache.put(field, bytes);
        return bytes;
    }

    public final TermEnum terms() throws IOException {
        return new SegmentsTermEnum(this.readers, this.starts, null);
    }

    public final TermEnum terms(Term term) throws IOException {
        return new SegmentsTermEnum(this.readers, this.starts, term);
    }

    public final int docFreq(Term t) throws IOException {
        int total = 0;
        int i = 0;
        while (i < this.readers.length) {
            total += this.readers[i].docFreq(t);
            ++i;
        }
        return total;
    }

    public final TermDocs termDocs() throws IOException {
        return new SegmentsTermDocs(this.readers, this.starts);
    }

    public final TermPositions termPositions() throws IOException {
        return new SegmentsTermPositions(this.readers, this.starts);
    }

    final synchronized void doClose() throws IOException {
        int i = 0;
        while (i < this.readers.length) {
            this.readers[i].close();
            ++i;
        }
    }

    public Collection getFieldNames() throws IOException {
        HashSet<String> fieldSet = new HashSet<String>();
        int i = 0;
        while (i < this.readers.length) {
            SegmentReader reader = this.readers[i];
            Collection names = reader.getFieldNames();
            Iterator iterator = names.iterator();
            while (iterator.hasNext()) {
                String s = (String)iterator.next();
                fieldSet.add(s);
            }
            ++i;
        }
        return fieldSet;
    }
}

