/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.util.Hashtable;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public final class StopFilter
extends TokenFilter {
    private Hashtable table;

    public StopFilter(TokenStream in, String[] stopWords) {
        super(in);
        this.table = StopFilter.makeStopTable(stopWords);
    }

    public StopFilter(TokenStream in, Hashtable stopTable) {
        super(in);
        this.table = stopTable;
    }

    public static final Hashtable makeStopTable(String[] stopWords) {
        Hashtable<String, String> stopTable = new Hashtable<String, String>(stopWords.length);
        int i = 0;
        while (i < stopWords.length) {
            stopTable.put(stopWords[i], stopWords[i]);
            ++i;
        }
        return stopTable;
    }

    public final Token next() throws IOException {
        Token token = this.input.next();
        while (token != null) {
            if (this.table.get(token.termText) == null) {
                return token;
            }
            token = this.input.next();
        }
        return null;
    }
}

