/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.dbcp.DbcpException;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.jocl.JOCLContentHandler;
import org.apache.commons.pool.ObjectPool;

public class PoolingDriver
implements Driver {
    protected static HashMap _pools;
    protected static String URL_PREFIX;
    protected static int URL_PREFIX_LEN;
    protected static int MAJOR_VERSION;
    protected static int MINOR_VERSION;
    static /* synthetic */ Class class$java$lang$String;

    static {
        try {
            DriverManager.registerDriver(new PoolingDriver());
        }
        catch (Exception exception) {}
        _pools = new HashMap();
        URL_PREFIX = "jdbc:apache:commons:dbcp:";
        URL_PREFIX_LEN = URL_PREFIX.length();
        MAJOR_VERSION = 1;
        MINOR_VERSION = 0;
    }

    public boolean acceptsURL(String url) throws SQLException {
        try {
            return url.startsWith(URL_PREFIX);
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public Connection connect(String url, Properties info) throws SQLException {
        if (this.acceptsURL(url)) {
            ObjectPool pool = this.getPool(url.substring(URL_PREFIX_LEN));
            if (pool == null) {
                throw new SQLException("No pool found for " + url + ".");
            }
            try {
                return (Connection)pool.borrowObject();
            }
            catch (SQLException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SQLException(e.toString());
            }
        }
        return null;
    }

    public int getMajorVersion() {
        return MAJOR_VERSION;
    }

    public int getMinorVersion() {
        return MINOR_VERSION;
    }

    public synchronized ObjectPool getPool(String name) {
        InputStream in;
        ObjectPool pool = (ObjectPool)_pools.get(name);
        if (pool == null && (in = this.getClass().getResourceAsStream(String.valueOf(String.valueOf(name)) + ".jocl")) != null) {
            JOCLContentHandler jocl = null;
            try {
                jocl = JOCLContentHandler.parse(in);
            }
            catch (Exception e) {
                throw new DbcpException(e);
            }
            if (jocl.getType(0).equals(class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = PoolingDriver.class$("java.lang.String")))) {
                pool = this.getPool((String)jocl.getValue(0));
                if (pool != null) {
                    this.registerPool(name, pool);
                }
            } else {
                pool = ((PoolableConnectionFactory)jocl.getValue(0)).getPool();
                if (pool != null) {
                    this.registerPool(name, pool);
                }
            }
        }
        return pool;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        return new DriverPropertyInfo[0];
    }

    public boolean jdbcCompliant() {
        return true;
    }

    public synchronized void registerPool(String name, ObjectPool pool) {
        _pools.put(name, pool);
    }
}

