/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.utils.locking;

import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.utils.locking.ReadWriteLock;
import org.apache.jcs.utils.locking.RwLockGC;
import org.apache.jcs.utils.locking.RwLockHolder;

public class ReadWriteLockManager {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$utils$locking$ReadWriteLockManager == null ? (class$org$apache$jcs$utils$locking$ReadWriteLockManager = ReadWriteLockManager.class$("org.apache.jcs.utils.locking.ReadWriteLockManager")) : class$org$apache$jcs$utils$locking$ReadWriteLockManager));
    private static RwLockGC gc;
    private Hashtable locks = new Hashtable();
    static /* synthetic */ Class class$org$apache$jcs$utils$locking$ReadWriteLockManager;

    public final void readLock(String id) throws InterruptedException {
        this.lock(id, false);
    }

    public final void writeLock(String id) throws InterruptedException {
        this.lock(id, true);
    }

    private void lock(String id, boolean isWrite) throws InterruptedException {
        RwLockHolder holder;
        Hashtable ht;
        String lockType;
        String string = lockType = isWrite ? "write" : "read";
        if (log.isDebugEnabled()) {
            log.debug((Object)("about to get " + lockType + " lock for id: " + id));
        }
        this.ensureGarbageCollectorCreated();
        Hashtable hashtable = ht = this.getLocks();
        synchronized (hashtable) {
            holder = (RwLockHolder)ht.get(id);
            if (holder != null) {
                ++holder.lcount;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Incrementing holder count to " + holder.lcount + " on " + lockType + " lock for id = " + id));
                }
            }
        }
        if (holder == null) {
            RwLockHolder newHolder = new RwLockHolder(new ReadWriteLock());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating new lock holder, lock type: " + lockType));
            }
            Hashtable hashtable2 = ht;
            synchronized (hashtable2) {
                holder = ht.put(id, newHolder);
                if (holder != null) {
                    ++holder.lcount;
                    ht.put(id, holder);
                }
            }
            if (holder == null) {
                holder = newHolder;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(lockType + " lock created for " + id));
            }
        }
        if (isWrite) {
            holder.writeLock();
        } else {
            holder.readLock();
        }
    }

    private synchronized void ensureGarbageCollectorCreated() {
        if (gc == null) {
            gc = new RwLockGC(this.getLocks());
            gc.setDaemon(true);
            gc.start();
        }
    }

    public final void done(String id) {
        int lcount;
        Hashtable ht = this.getLocks();
        RwLockHolder holder = (RwLockHolder)ht.get(id);
        if (holder == null) {
            String message = "done called without an outstanding lock for id: " + id;
            if (log.isDebugEnabled()) {
                log.debug((Object)message);
            }
            throw new IllegalStateException(message);
        }
        holder.done();
        if (log.isDebugEnabled()) {
            log.debug((Object)("lock done for id = " + id));
        }
        Hashtable hashtable = ht;
        synchronized (hashtable) {
            lcount = --holder.lcount;
        }
        if (lcount > 0) {
            return;
        }
        if (lcount == 0) {
            holder.lastInactiveTime = System.currentTimeMillis();
            gc.notifyGarbage();
            return;
        }
        throw new IllegalStateException("holder.lcount went down below zero (" + holder.lcount + ") for id=" + id);
    }

    protected Hashtable getLocks() {
        return this.locks;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

