/*
 * Decompiled with CFR 0.152.
 */
package slidestore.reference;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.slide.common.AbstractService;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.ServiceConnectionFailedException;
import org.apache.slide.common.ServiceDisconnectionFailedException;
import org.apache.slide.common.ServiceInitializationFailedException;
import org.apache.slide.common.ServiceParameterErrorException;
import org.apache.slide.common.ServiceParameterMissingException;
import org.apache.slide.common.ServiceResetFailedException;
import org.apache.slide.common.Uri;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.lock.LockTokenNotFoundException;
import org.apache.slide.lock.NodeLock;
import org.apache.slide.security.NodePermission;
import org.apache.slide.store.LockStore;
import org.apache.slide.store.NodeStore;
import org.apache.slide.store.RevisionDescriptorStore;
import org.apache.slide.store.RevisionDescriptorsStore;
import org.apache.slide.store.SecurityStore;
import org.apache.slide.structure.ObjectAlreadyExistsException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;

public class MemoryDescriptorsStore
extends AbstractService
implements LockStore,
NodeStore,
RevisionDescriptorsStore,
RevisionDescriptorStore,
SecurityStore {
    private Hashtable objects;
    private Hashtable permissions;
    private Hashtable locks;
    private Hashtable descriptors;
    private Hashtable descriptor;

    public boolean cacheResults() {
        return false;
    }

    public void commit() throws ServiceAccessException {
    }

    public synchronized void connect() throws ServiceConnectionFailedException {
        if (this.objects == null) {
            this.objects = new Hashtable();
            this.permissions = new Hashtable();
            this.locks = new Hashtable();
            this.descriptors = new Hashtable();
            this.descriptor = new Hashtable();
        }
    }

    public void createObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectAlreadyExistsException {
        try {
            if (this.objects.containsKey(uri.toString())) {
                throw new ObjectAlreadyExistsException(uri.toString());
            }
            this.storeObject(uri, object);
        }
        catch (ObjectNotFoundException objectNotFoundException) {}
    }

    public void createRevisionDescriptor(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException {
        this.descriptor.put(String.valueOf(String.valueOf(uri)) + "-" + revisionDescriptor.getRevisionNumber(), revisionDescriptor.cloneObject());
    }

    public void createRevisionDescriptors(Uri uri, NodeRevisionDescriptors revisionDescriptors) throws ServiceAccessException {
        this.descriptors.put(uri.toString(), revisionDescriptors.cloneObject());
    }

    public void disconnect() throws ServiceDisconnectionFailedException {
    }

    public Enumeration enumerateLocks(Uri uri) throws ServiceAccessException {
        Object value = this.locks.get(uri.toString());
        Vector locksVector = null;
        locksVector = value == null ? new Vector() : (Vector)value;
        return locksVector.elements();
    }

    public Enumeration enumeratePermissions(Uri uri) throws ServiceAccessException {
        Object value = this.permissions.get(uri.toString());
        Vector permissionsVector = null;
        permissionsVector = value != null ? (Vector)value : new Vector();
        return permissionsVector.elements();
    }

    public void grantPermission(Uri uri, NodePermission permission) throws ServiceAccessException {
        Object value = this.permissions.get(uri.toString());
        Vector<NodePermission> permissionsVector = null;
        if (value == null) {
            permissionsVector = new Vector<NodePermission>();
            this.permissions.put(uri.toString(), permissionsVector);
        } else {
            permissionsVector = (Vector<NodePermission>)value;
        }
        permissionsVector.addElement(permission.cloneObject());
    }

    public synchronized void initialize(NamespaceAccessToken token) throws ServiceInitializationFailedException {
        super.initialize(token);
        this.objects = new Hashtable();
        this.permissions = new Hashtable();
        this.locks = new Hashtable();
        this.descriptors = new Hashtable();
        this.descriptor = new Hashtable();
    }

    public boolean isConnected() throws ServiceAccessException {
        return true;
    }

    public void killLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        this.removeLock(uri, lock);
    }

    public void putLock(Uri uri, NodeLock lock) throws ServiceAccessException {
        Object value = this.locks.get(uri.toString());
        Vector<NodeLock> locksVector = null;
        if (value == null) {
            locksVector = new Vector<NodeLock>();
            this.locks.put(uri.toString(), locksVector);
        } else {
            locksVector = (Vector<NodeLock>)value;
        }
        locksVector.addElement(lock.cloneObject());
    }

    public void removeLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        Object value = this.locks.get(uri.toString());
        Vector locksVector = null;
        if (value == null) {
            throw new LockTokenNotFoundException(lock);
        }
        locksVector = (Vector)value;
        boolean wasPresent = locksVector.removeElement(lock);
        if (!wasPresent) {
            throw new LockTokenNotFoundException(lock);
        }
    }

    public void removeObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException {
        if (!this.objects.containsKey(uri.toString())) {
            throw new ObjectNotFoundException(uri);
        }
        this.objects.remove(uri.toString());
    }

    public void removeRevisionDescriptor(Uri uri, NodeRevisionNumber number) throws ServiceAccessException {
        this.descriptor.remove(String.valueOf(String.valueOf(uri)) + "-" + number);
    }

    public void removeRevisionDescriptors(Uri uri) throws ServiceAccessException {
        this.descriptors.remove(uri.toString());
    }

    public void renewLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        Object value = this.locks.get(uri.toString());
        Vector locksVector = null;
        if (value == null) {
            throw new LockTokenNotFoundException(lock);
        }
        locksVector = (Vector)value;
        boolean wasPresent = locksVector.removeElement(lock);
        if (!wasPresent) {
            throw new LockTokenNotFoundException(lock);
        }
        locksVector.addElement(lock.cloneObject());
    }

    public synchronized void reset() throws ServiceResetFailedException {
        this.objects = new Hashtable();
        this.permissions = new Hashtable();
        this.locks = new Hashtable();
        this.descriptors = new Hashtable();
        this.descriptor = new Hashtable();
    }

    public ObjectNode retrieveObject(Uri uri) throws ServiceAccessException, ObjectNotFoundException {
        Object tempObject = this.objects.get(uri.toString());
        if (tempObject == null) {
            throw new ObjectNotFoundException(uri);
        }
        return ((ObjectNode)tempObject).cloneObject();
    }

    public NodeRevisionDescriptor retrieveRevisionDescriptor(Uri uri, NodeRevisionNumber revisionNumber) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        Object result = this.descriptor.get(String.valueOf(String.valueOf(uri)) + "-" + revisionNumber);
        if (result == null) {
            throw new RevisionDescriptorNotFoundException(uri.toString());
        }
        return ((NodeRevisionDescriptor)result).cloneObject();
    }

    public NodeRevisionDescriptors retrieveRevisionDescriptors(Uri uri) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        Object tempObject = this.descriptors.get(uri.toString());
        if (tempObject == null) {
            throw new RevisionDescriptorNotFoundException(uri.toString());
        }
        return ((NodeRevisionDescriptors)tempObject).cloneObject();
    }

    public void revokePermission(Uri uri, NodePermission permission) throws ServiceAccessException {
        Object value = this.permissions.get(uri.toString());
        Vector permissionsVector = null;
        if (value != null) {
            permissionsVector = (Vector)value;
            permissionsVector.removeElement(permission);
        }
    }

    public void revokePermissions(Uri uri) throws ServiceAccessException {
        Object value = this.permissions.get(uri.toString());
        Vector permissionsVector = null;
        if (value != null) {
            permissionsVector = (Vector)value;
            permissionsVector.removeAllElements();
        }
    }

    public void setParameters(Hashtable parameters) throws ServiceParameterErrorException, ServiceParameterMissingException {
    }

    public void storeObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException {
        this.objects.put(uri.toString(), object.cloneObject());
    }

    public void storeRevisionDescriptor(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        String key = String.valueOf(String.valueOf(uri)) + "-" + revisionDescriptor.getRevisionNumber();
        if (!this.descriptor.containsKey(key)) {
            throw new RevisionDescriptorNotFoundException(uri.toString());
        }
        this.descriptor.put(key, revisionDescriptor.cloneObject());
    }

    public void storeRevisionDescriptors(Uri uri, NodeRevisionDescriptors revisionDescriptors) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        if (!this.descriptors.containsKey(uri.toString())) {
            throw new RevisionDescriptorNotFoundException(uri.toString());
        }
        this.descriptors.put(uri.toString(), revisionDescriptors.cloneObject());
    }
}

