/*
 * Decompiled with CFR 0.152.
 */
package slidestore.j2ee;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.slide.common.AbstractServiceBase;
import org.apache.slide.common.AbstractXAService;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.Service;
import org.apache.slide.common.ServiceConnectionFailedException;
import org.apache.slide.common.ServiceDisconnectionFailedException;
import org.apache.slide.common.ServiceInitializationFailedException;
import org.apache.slide.common.ServiceParameterErrorException;
import org.apache.slide.common.ServiceParameterMissingException;
import org.apache.slide.common.ServiceResetFailedException;

public abstract class J2EEStore
extends AbstractXAService {
    public static final int TX_IDLE = 0;
    public static final int TX_PREPARED = 1;
    public static final int TX_SUSPENDED = 1;
    protected DataSource ds;
    protected String datasource;
    protected Hashtable connectionMap = new Hashtable();
    protected Connection globalConnection;

    protected void closeStatement(Statement statement) {
        block2: {
            if (statement == null) break block2;
            try {
                statement.close();
            }
            catch (SQLException e) {
                this.getLogger().log((Object)e, ((AbstractServiceBase)this).LOG_CHANNEL, 2);
            }
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.getLogger().log((Object)("commit() for thread " + Thread.currentThread() + ", removing from map"), ((AbstractServiceBase)this).LOG_CHANNEL, 7);
        TransactionId id = (TransactionId)this.connectionMap.remove(Thread.currentThread());
        if (id == null) {
            this.getLogger().log((Object)"Error committing: no transaction associated with current thread", ((AbstractServiceBase)this).LOG_CHANNEL, 2);
            throw new XAException(-4);
        }
        if (xid == null) {
            throw new XAException(-5);
        }
        if (!onePhase && id.status != 1) {
            throw new XAException(-6);
        }
        if (onePhase && id.status != 0 && id.status != 1) {
            throw new XAException(-6);
        }
        Connection conn = id.connection;
        if (conn == null) {
            this.getLogger().log((Object)("commit(): No connection in connectionMap for id \"" + id + "\""), ((AbstractServiceBase)this).LOG_CHANNEL, 2);
            throw new XAException(-4);
        }
        try {
            try {
                if (id.rollbackOnly) {
                    conn.rollback();
                } else {
                    conn.commit();
                }
            }
            catch (SQLException sQLException) {
                throw new XAException(101);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                conn.close();
            }
            catch (SQLException e) {
                this.getLogger().log((Object)e, ((AbstractServiceBase)this).LOG_CHANNEL, 2);
            }
            throw throwable;
        }
        try {
            conn.close();
        }
        catch (SQLException e) {
            this.getLogger().log((Object)e, ((AbstractServiceBase)this).LOG_CHANNEL, 2);
        }
    }

    public synchronized void connect() throws ServiceConnectionFailedException {
        this.getLogger().log((Object)"Trying connect to database", ((AbstractServiceBase)this).LOG_CHANNEL, 7);
        try {
            this.globalConnection = this.ds.getConnection();
        }
        catch (SQLException sQLException) {
            this.getLogger().log((Object)"Couldn't get global transaction.", ((AbstractServiceBase)this).LOG_CHANNEL, 2);
        }
        this.getLogger().log((Object)("Done connecting to database. globalConnection is " + this.globalConnection), ((AbstractServiceBase)this).LOG_CHANNEL, 7);
    }

    public void disconnect() throws ServiceDisconnectionFailedException {
        try {
            this.globalConnection.close();
        }
        catch (SQLException e) {
            this.getLogger().log((Object)("Failed to close special global connection: " + e.getMessage()), ((AbstractServiceBase)this).LOG_CHANNEL, 2);
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        this.getLogger().log((Object)("end() for thread: " + Thread.currentThread()), ((AbstractServiceBase)this).LOG_CHANNEL, 7);
        TransactionId id = (TransactionId)this.connectionMap.get(Thread.currentThread());
        if (id == null || id.xid == null) {
            throw new XAException(-4);
        }
        if (xid == null) {
            throw new XAException(-5);
        }
        if (flags == 0x2000000) {
            id.status = 1;
        }
        if (flags == 0x20000000) {
            id.rollbackOnly = true;
        }
    }

    public void forget(Xid xid) throws XAException {
        this.getLogger().log((Object)("forget() for thread: " + Thread.currentThread()), ((AbstractServiceBase)this).LOG_CHANNEL, 7);
        TransactionId id = (TransactionId)this.connectionMap.get(Thread.currentThread());
        if (id == null || id.xid == null) {
            throw new XAException(-4);
        }
        if (xid == null) {
            throw new XAException(-5);
        }
        try {
            id.connection.close();
        }
        catch (SQLException sQLException) {
            this.getLogger().log((Object)"Couldn't close connection.", ((AbstractServiceBase)this).LOG_CHANNEL, 2);
        }
        this.getLogger().log((Object)("forget(): removing from map: " + Thread.currentThread()), ((AbstractServiceBase)this).LOG_CHANNEL, 7);
        this.connectionMap.remove(Thread.currentThread());
    }

    protected Connection getCurrentConnection() {
        TransactionId id = (TransactionId)this.connectionMap.get(Thread.currentThread());
        if (id == null) {
            this.getLogger().log((Object)("No id for current thread (" + Thread.currentThread() + ") - called outside transaction?"), ((AbstractServiceBase)this).LOG_CHANNEL, 6);
            return this.globalConnection;
        }
        Connection conn = id.connection;
        if (conn == null) {
            this.getLogger().log((Object)"No connection for current id - shouldn't be possible", ((AbstractServiceBase)this).LOG_CHANNEL, 2);
            return this.globalConnection;
        }
        this.getLogger().log((Object)"Returning current valid connection from map", ((AbstractServiceBase)this).LOG_CHANNEL, 7);
        return conn;
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    public synchronized void initialize(NamespaceAccessToken token) throws ServiceInitializationFailedException {
        try {
            token.getLogger().log((Object)("Loading and registering datasource " + this.datasource), ((AbstractServiceBase)this).LOG_CHANNEL, 6);
            InitialContext initCtx = new InitialContext();
            Context envCtx = (Context)initCtx.lookup("java:comp/env");
            this.ds = (DataSource)envCtx.lookup(this.datasource);
        }
        catch (ClassCastException e) {
            token.getLogger().log((Object)("Loading and registering datasource " + this.datasource + " failed"), ((AbstractServiceBase)this).LOG_CHANNEL, 2);
            token.getLogger().log((Object)e.toString(), ((AbstractServiceBase)this).LOG_CHANNEL, 2);
            throw new ServiceInitializationFailedException((Service)this, e.getMessage());
        }
        catch (NamingException e) {
            token.getLogger().log((Object)("Loading and registering datasource " + this.datasource + " failed"), ((AbstractServiceBase)this).LOG_CHANNEL, 2);
            token.getLogger().log((Object)e.toString(), ((AbstractServiceBase)this).LOG_CHANNEL, 2);
            throw new ServiceInitializationFailedException((Service)this, e.getMessage());
        }
        catch (Exception e) {
            token.getLogger().log((Object)("Loading and registering datasource " + this.datasource + " failed"), ((AbstractServiceBase)this).LOG_CHANNEL, 2);
            token.getLogger().log((Object)e.toString(), ((AbstractServiceBase)this).LOG_CHANNEL, 2);
            throw new ServiceInitializationFailedException((Service)this, e.getMessage());
        }
        if (this.ds == null) {
            token.getLogger().log((Object)"Datasource is null, can't initialise store");
            throw new ServiceInitializationFailedException((Service)this, "Null datasource from context");
        }
    }

    public boolean isConnected() {
        try {
            return this.ds != null && this.globalConnection != null && !this.globalConnection.isClosed();
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        if (xares == null) {
            return false;
        }
        return this == xares;
    }

    public int prepare(Xid xid) throws XAException {
        this.getLogger().log((Object)("prepare() for thread: " + Thread.currentThread()), ((AbstractServiceBase)this).LOG_CHANNEL, 7);
        TransactionId id = (TransactionId)this.connectionMap.get(Thread.currentThread());
        if (id == null) {
            throw new XAException(-4);
        }
        if (xid == null) {
            throw new XAException(-5);
        }
        if (id.status != 0 && id.status != 1) {
            throw new XAException(-6);
        }
        if (id.rollbackOnly) {
            throw new XAException(100);
        }
        id.status = 1;
        return 0;
    }

    public Xid[] recover(int flag) throws XAException {
        this.getLogger().log((Object)("recover() for thread: " + Thread.currentThread()), ((AbstractServiceBase)this).LOG_CHANNEL, 7);
        TransactionId id = (TransactionId)this.connectionMap.get(Thread.currentThread());
        if (id != null && id.status == 1) {
            Xid[] xids = new Xid[]{id.xid};
            return xids;
        }
        return new Xid[0];
    }

    public synchronized void reset() throws ServiceResetFailedException {
    }

    public void rollback(Xid xid) throws XAException {
        this.getLogger().log((Object)("rollback() for thread " + Thread.currentThread() + ", removing from map"), ((AbstractServiceBase)this).LOG_CHANNEL, 7);
        TransactionId id = (TransactionId)this.connectionMap.remove(Thread.currentThread());
        if (id == null) {
            this.getLogger().log((Object)"No transaction associated with current thread, can't rollback", ((AbstractServiceBase)this).LOG_CHANNEL, 2);
            throw new XAException(-4);
        }
        Connection conn = id.connection;
        if (conn == null) {
            this.getLogger().log((Object)("rollback(): No connection in connectionMap for id \"" + id + "\""), ((AbstractServiceBase)this).LOG_CHANNEL, 2);
            throw new XAException(-4);
        }
        try {
            try {
                conn.rollback();
            }
            catch (SQLException sQLException) {
                throw new XAException(7);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                conn.close();
            }
            catch (SQLException e) {
                this.getLogger().log((Object)e, ((AbstractServiceBase)this).LOG_CHANNEL, 2);
            }
            throw throwable;
        }
        try {
            conn.close();
        }
        catch (SQLException e) {
            this.getLogger().log((Object)e, ((AbstractServiceBase)this).LOG_CHANNEL, 2);
        }
    }

    public void setParameters(Hashtable parameters) throws ServiceParameterErrorException, ServiceParameterMissingException {
        this.datasource = (String)parameters.get("datasource");
    }

    public boolean setTransactionTimeout(int timeout) throws XAException {
        return false;
    }

    public void start(Xid xid, int flags) throws XAException {
        this.getLogger().log((Object)("start(): beginning transaction with xid " + xid), ((AbstractServiceBase)this).LOG_CHANNEL, 7);
        TransactionId id = (TransactionId)this.connectionMap.get(Thread.currentThread());
        switch (flags) {
            case 0: {
                if (id != null) {
                    throw new XAException(-5);
                }
                id = new TransactionId(xid, 0);
                this.getLogger().log((Object)("start(): adding to map for " + Thread.currentThread()), ((AbstractServiceBase)this).LOG_CHANNEL, 7);
                this.connectionMap.put(Thread.currentThread(), id);
                break;
            }
            case 0x200000: {
                this.getLogger().log((Object)("TMJOIN for transaction in thread: " + Thread.currentThread()), ((AbstractServiceBase)this).LOG_CHANNEL, 7);
                if (id != null) break;
                throw new XAException(-4);
            }
            case 0x8000000: {
                this.getLogger().log((Object)("TMRESUME for transaction in thread: " + Thread.currentThread()), ((AbstractServiceBase)this).LOG_CHANNEL, 7);
                if (id == null) {
                    throw new XAException(-4);
                }
                if (id.status != 1) {
                    throw new XAException(-5);
                }
                id.status = 0;
                break;
            }
        }
    }

    private class TransactionId {
        public Xid xid;
        public int status;
        public boolean rollbackOnly;
        Connection connection;

        public TransactionId(Xid xid, int status) {
            this.xid = xid;
            this.status = status;
            this.rollbackOnly = false;
            try {
                this.connection = J2EEStore.this.ds.getConnection();
                if (this.connection == null) {
                    System.out.println("CONNDEBUG: Got null connection from datasource");
                    this.connection = J2EEStore.this.globalConnection;
                    return;
                }
                this.connection.setAutoCommit(false);
                System.out.println("CONNDEBUG: Got connection successfully");
            }
            catch (SQLException e) {
                System.out.println("CONNDEBUG: Couldn't get connection: " + e.getMessage());
                this.connection = J2EEStore.this.globalConnection;
                e.printStackTrace();
            }
        }
    }
}

