/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.task;

import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.torque.engine.database.model.TypeMap;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.DocumentTypeImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TorqueJDBCTransformTask
extends Task {
    protected String xmlSchema;
    protected String dbUrl;
    protected String dbDriver;
    protected String dbUser;
    protected String dbPassword;
    protected String dbSchema;
    protected DocumentImpl doc;
    protected Node databaseNode;
    protected Hashtable primaryKeys;
    protected Hashtable columnTableMap;
    protected boolean sameJavaName;
    private XMLSerializer xmlSerializer;

    public String getDbSchema() {
        return this.dbSchema;
    }

    public void setDbSchema(String dbSchema) {
        this.dbSchema = dbSchema;
    }

    public void setDbUrl(String v) {
        this.dbUrl = v;
    }

    public void setDbDriver(String v) {
        this.dbDriver = v;
    }

    public void setDbUser(String v) {
        this.dbUser = v;
    }

    public void setDbPassword(String v) {
        this.dbPassword = v;
    }

    public void setOutputFile(String v) {
        this.xmlSchema = v;
    }

    public void setSameJavaName(boolean v) {
        this.sameJavaName = v;
    }

    public boolean isSameJavaName() {
        return this.sameJavaName;
    }

    public void execute() throws BuildException {
        this.log("Torque - JDBCToXMLSchema starting\n");
        this.log("Your DB settings are:");
        this.log("driver : " + this.dbDriver);
        this.log("URL : " + this.dbUrl);
        this.log("user : " + this.dbUser);
        this.log("schema : " + this.dbSchema);
        DocumentTypeImpl docType = new DocumentTypeImpl(null, "database", null, "http://jakarta.apache.org/turbine/dtd/database.dtd");
        this.doc = new DocumentImpl((DocumentType)docType);
        this.doc.appendChild((Node)this.doc.createComment(" Autogenerated by JDBCToXMLSchema! "));
        try {
            this.generateXML();
            this.log(this.xmlSchema);
            this.xmlSerializer = new XMLSerializer((Writer)new PrintWriter(new FileOutputStream(this.xmlSchema)), new OutputFormat("xml", null, true));
            this.xmlSerializer.serialize((Document)this.doc);
        }
        catch (Exception e) {
            this.log(e.toString());
            e.printStackTrace();
        }
        this.log("\nTorque - JDBCToXMLSchema finished");
    }

    public void generateXML() throws Exception {
        Class.forName(this.dbDriver);
        this.log("DB driver sucessfuly instantiated");
        Connection con = DriverManager.getConnection(this.dbUrl, this.dbUser, this.dbPassword);
        this.log("DB connection established");
        DatabaseMetaData dbMetaData = con.getMetaData();
        List tableList = this.getTableNames(dbMetaData);
        this.databaseNode = this.doc.createElement("database");
        this.columnTableMap = new Hashtable();
        this.log("Building column/table map...");
        int i = 0;
        while (i < tableList.size()) {
            String curTable = (String)tableList.get(i);
            List columns = this.getColumns(dbMetaData, curTable);
            int j = 0;
            while (j < columns.size()) {
                List col = (List)columns.get(j);
                String name = (String)col.get(0);
                this.columnTableMap.put(name, curTable);
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < tableList.size()) {
            String curTable = (String)tableList.get(i2);
            this.log("Processing table: " + curTable);
            Element table = this.doc.createElement("table");
            table.setAttribute("name", curTable);
            if (this.isSameJavaName()) {
                table.setAttribute("javaName", curTable);
            }
            List columns = this.getColumns(dbMetaData, curTable);
            List primKeys = this.getPrimaryKeys(dbMetaData, curTable);
            Collection forgnKeys = this.getForeignKeys(dbMetaData, curTable);
            this.primaryKeys = new Hashtable();
            int k = 0;
            while (k < primKeys.size()) {
                String curPrimaryKey = (String)primKeys.get(k);
                this.primaryKeys.put(curPrimaryKey, curPrimaryKey);
                ++k;
            }
            int j = 0;
            while (j < columns.size()) {
                List col = (List)columns.get(j);
                String name = (String)col.get(0);
                Integer type = (Integer)col.get(1);
                int size = (Integer)col.get(2);
                Integer nullType = (Integer)col.get(3);
                String defValue = (String)col.get(4);
                Element column = this.doc.createElement("column");
                column.setAttribute("name", name);
                if (this.isSameJavaName()) {
                    column.setAttribute("javaName", name);
                }
                column.setAttribute("type", TypeMap.getTorqueType(type));
                if (size > 0 && (type == 1 || type == 12 || type == -1 || type == 3 || type == 2)) {
                    column.setAttribute("size", new Integer(size).toString());
                }
                if (nullType == 0) {
                    column.setAttribute("required", "true");
                }
                if (this.primaryKeys.containsKey(name)) {
                    column.setAttribute("primaryKey", "true");
                }
                if (defValue != null) {
                    if (defValue.startsWith("(") && defValue.endsWith(")")) {
                        defValue = defValue.substring(1, defValue.length() - 1);
                    }
                    if (defValue.startsWith("'") && defValue.endsWith("'")) {
                        defValue = defValue.substring(1, defValue.length() - 1);
                    }
                    column.setAttribute("default", defValue);
                }
                table.appendChild(column);
                ++j;
            }
            Iterator l = forgnKeys.iterator();
            while (l.hasNext()) {
                Object[] forKey = (Object[])l.next();
                String foreignKeyTable = (String)forKey[0];
                List refs = (List)forKey[1];
                Element fk = this.doc.createElement("foreign-key");
                fk.setAttribute("foreignTable", foreignKeyTable);
                int m = 0;
                while (m < refs.size()) {
                    Element ref = this.doc.createElement("reference");
                    String[] refData = (String[])refs.get(m);
                    ref.setAttribute("local", refData[0]);
                    ref.setAttribute("foreign", refData[1]);
                    fk.appendChild(ref);
                    ++m;
                }
                table.appendChild(fk);
            }
            this.databaseNode.appendChild(table);
            ++i2;
        }
        this.doc.appendChild(this.databaseNode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List getTableNames(DatabaseMetaData dbMeta) throws SQLException {
        this.log("Getting table list...");
        ArrayList<String> tables = new ArrayList<String>();
        ResultSet tableNames = null;
        String[] types = new String[]{"TABLE", "VIEW"};
        try {
            tableNames = dbMeta.getTables(null, this.dbSchema, "%", types);
            while (tableNames.next()) {
                String name = tableNames.getString(3);
                String type = tableNames.getString(4);
                tables.add(name);
            }
            Object var8_7 = null;
            if (tableNames == null) return tables;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (tableNames == null) throw throwable;
            tableNames.close();
            throw throwable;
        }
        tableNames.close();
        return tables;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List getColumns(DatabaseMetaData dbMeta, String tableName) throws SQLException {
        ArrayList columns = new ArrayList();
        ResultSet columnSet = null;
        try {
            columnSet = dbMeta.getColumns(null, this.dbSchema, tableName, null);
            while (columnSet.next()) {
                String name = columnSet.getString(4);
                Integer sqlType = new Integer(columnSet.getString(5));
                Integer size = new Integer(columnSet.getInt(7));
                Integer nullType = new Integer(columnSet.getInt(11));
                String defValue = columnSet.getString(13);
                ArrayList<Object> col = new ArrayList<Object>(5);
                col.add(name);
                col.add(sqlType);
                col.add(size);
                col.add(nullType);
                col.add(defValue);
                columns.add(col);
            }
            Object var12_11 = null;
            if (columnSet == null) return columns;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            if (columnSet == null) throw throwable;
            columnSet.close();
            throw throwable;
        }
        columnSet.close();
        return columns;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List getPrimaryKeys(DatabaseMetaData dbMeta, String tableName) throws SQLException {
        ArrayList<String> pk = new ArrayList<String>();
        ResultSet parts = null;
        try {
            parts = dbMeta.getPrimaryKeys(null, this.dbSchema, tableName);
            while (parts.next()) {
                pk.add(parts.getString(4));
            }
            Object var6_5 = null;
            if (parts == null) return pk;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (parts == null) throw throwable;
            parts.close();
            throw throwable;
        }
        parts.close();
        return pk;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Collection getForeignKeys(DatabaseMetaData dbMeta, String tableName) throws SQLException {
        Hashtable<String, Object[]> fks = new Hashtable<String, Object[]>();
        ResultSet foreignKeys = null;
        try {
            foreignKeys = dbMeta.getImportedKeys(null, this.dbSchema, tableName);
            while (foreignKeys.next()) {
                ArrayList<String[]> refs;
                Object[] fk;
                String fkName = foreignKeys.getString(12);
                if (fkName == null) {
                    fkName = foreignKeys.getString(3);
                }
                if ((fk = (Object[])fks.get(fkName)) == null) {
                    fk = new Object[]{foreignKeys.getString(3), refs = new ArrayList<String[]>()};
                    fks.put(fkName, fk);
                } else {
                    refs = (ArrayList<String[]>)fk[1];
                }
                String[] ref = new String[]{foreignKeys.getString(8), foreignKeys.getString(4)};
                refs.add(ref);
            }
            Object var10_9 = null;
            if (foreignKeys == null) return fks.values();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (foreignKeys == null) throw throwable;
            foreignKeys.close();
            throw throwable;
        }
        foreignKeys.close();
        return fks.values();
    }
}

