/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.engine.database.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.torque.engine.EngineException;
import org.apache.torque.engine.database.model.Column;
import org.apache.torque.engine.database.model.NameFactory;
import org.apache.torque.engine.database.model.Table;
import org.xml.sax.Attributes;

public class Index {
    private static final boolean DEBUG = false;
    private String indexName;
    private Table parentTable;
    private List indexColumns = new ArrayList(3);

    public Index() {
    }

    protected Index(Table table, List indexColumns) throws EngineException {
        this();
        this.setTable(table);
        if (indexColumns.size() <= 0) {
            throw new EngineException("Cannot create a new Index using an empty list Column object");
        }
        this.indexColumns = indexColumns;
        this.createName();
    }

    private void createName() throws EngineException {
        Table table = this.getTable();
        ArrayList<Object> inputs = new ArrayList<Object>(4);
        inputs.add(table.getDatabase());
        inputs.add(table.getName());
        if (this.isUnique()) {
            inputs.add("U");
        } else {
            inputs.add("I");
        }
        inputs.add(new Integer(table.getIndices().length + 1));
        this.indexName = NameFactory.generateName(NameFactory.CONSTRAINT_GENERATOR, inputs);
    }

    public void loadFromXML(Attributes attrib) {
        this.indexName = attrib.getValue("name");
    }

    public boolean getIsUnique() {
        return this.isUnique();
    }

    public boolean isUnique() {
        return false;
    }

    public String getIndexName() {
        return this.getName();
    }

    public String getName() {
        if (this.indexName == null) {
            try {
                this.createName();
            }
            catch (EngineException engineException) {
                // empty catch block
            }
        }
        return this.indexName;
    }

    public void setIndexName(String name) {
        this.setName(name);
    }

    public void setName(String name) {
        this.indexName = name;
    }

    public void setTable(Table parent) {
        this.parentTable = parent;
    }

    public Table getTable() {
        return this.parentTable;
    }

    public String getTableName() {
        return this.parentTable.getName();
    }

    public void addColumn(Attributes attrib) {
        this.indexColumns.add(attrib.getValue("name"));
    }

    public String getIndexColumnList() {
        return this.getColumnList();
    }

    public String getColumnList() {
        return Column.makeList(this.getColumns());
    }

    public List getIndexColumns() {
        return this.getColumns();
    }

    public List getColumns() {
        return this.indexColumns;
    }

    protected List getColumnNames() {
        ArrayList<String> names = new ArrayList<String>(this.indexColumns.size() + 2);
        Iterator i = this.getColumns().iterator();
        while (i.hasNext()) {
            Column c = (Column)i.next();
            names.add(c.getName());
        }
        return names;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(" <index name=\"").append(this.getName()).append("\"");
        result.append(">\n");
        int i = 0;
        while (i < this.indexColumns.size()) {
            result.append("  <index-column name=\"").append(this.indexColumns.get(i)).append("\"/>\n");
            ++i;
        }
        result.append(" </index>\n");
        return result.toString();
    }
}

