/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.ant;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.CallTarget;

public class StartServerHelper
implements Runnable {
    private URL testURL;
    private String startTarget;
    private Task task;
    private boolean isServerAlreadyStarted = false;

    public boolean isServerAlreadyStarted() {
        return this.isServerAlreadyStarted;
    }

    public StartServerHelper(Task theTask) {
        this.task = theTask;
    }

    public void execute() throws BuildException {
        if (this.testURL == null) {
            throw new BuildException("A testURL attribute must be specified");
        }
        if (this.startTarget == null) {
            throw new BuildException("A startTarget Ant target name must be specified");
        }
        try {
            HttpURLConnection connection = (HttpURLConnection)this.testURL.openConnection();
            connection.connect();
            StartServerHelper.readFully(connection);
            connection.disconnect();
            this.isServerAlreadyStarted = true;
            return;
        }
        catch (IOException e) {
            Thread thread = new Thread(this);
            thread.start();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e2) {
                throw new BuildException("Interruption during sleep", (Throwable)e2);
            }
            while (true) {
                try {
                    HttpURLConnection connection = (HttpURLConnection)this.testURL.openConnection();
                    connection.connect();
                    StartServerHelper.readFully(connection);
                    connection.disconnect();
                    break;
                }
                catch (IOException e3) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ee) {
                        throw new BuildException("Interruption during sleep", (Throwable)ee);
                    }
                }
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e4) {
                throw new BuildException("Interruption during sleep", (Throwable)e4);
            }
            return;
        }
    }

    static void readFully(HttpURLConnection connection) throws IOException {
        BufferedInputStream is = new BufferedInputStream(connection.getInputStream());
        byte[] buffer = new byte[256];
        while (is.read(buffer) > 0) {
        }
        is.close();
    }

    public void run() {
        CallTarget callee = (CallTarget)this.task.getProject().createTask("antcall");
        callee.setOwningTarget(this.task.getOwningTarget());
        callee.setTaskName(this.task.getTaskName());
        callee.setLocation(this.task.getLocation());
        callee.init();
        callee.setTarget(this.startTarget);
        callee.execute();
    }

    public void setTestURL(String theTestURL) {
        try {
            this.testURL = new URL(theTestURL);
        }
        catch (MalformedURLException e) {
            throw new BuildException("Bad URL [" + theTestURL + "]", (Throwable)e);
        }
    }

    public void setStartTarget(String theStartTarget) {
        this.startTarget = theStartTarget;
    }
}

