/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.ant;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;

public abstract class AbstractServerRun
extends Thread {
    private int port = 7777;
    private String host = "127.0.0.1";
    protected String[] args;
    private boolean isStarted = false;

    public AbstractServerRun(String[] theArgs) {
        this.args = theArgs;
    }

    protected abstract void doStartServer() throws Exception;

    protected abstract void doStopServer() throws Exception;

    protected void doRun() {
        boolean isStart = true;
        Vector<String> newArgs = new Vector<String>();
        int i = 0;
        while (i < this.args.length) {
            if (this.args[i].equalsIgnoreCase("-start")) {
                isStart = true;
            } else if (this.args[i].equalsIgnoreCase("-stop")) {
                isStart = false;
            } else if (this.args[i].equalsIgnoreCase("-port")) {
                this.port = Integer.parseInt(this.args[i + 1]);
                ++i;
            } else {
                newArgs.add(this.args[i]);
            }
            ++i;
        }
        String[] strArgs = new String[]{};
        this.args = newArgs.toArray(strArgs);
        if (isStart) {
            this.startServer();
        } else {
            this.stopServer();
        }
    }

    private void startServer() {
        if (this.isStarted) {
            return;
        }
        try {
            this.doStartServer();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error starting server");
        }
        this.isStarted = true;
        new Thread(this).start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void stopServer() {
        Socket clientSocket = null;
        try {
            try {
                clientSocket = new Socket(this.host, this.port);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Error opening socket to " + this.host + ":" + this.port + "]");
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            try {
                if (clientSocket == null) throw throwable;
                clientSocket.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot close client socket");
            }
        }
        try {}
        catch (IOException e) {
            throw new RuntimeException("Cannot close client socket");
        }
        if (clientSocket == null) return;
        clientSocket.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        ServerSocket serverSocket = this.setUpListenerSocket();
        Socket clientSocket = null;
        try {
            try {
                clientSocket = serverSocket.accept();
            }
            catch (IOException e) {
                throw new RuntimeException("Error accepting connection for server socket [" + serverSocket + "]");
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            try {
                serverSocket.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot close server socket [" + serverSocket + "]");
            }
        }
        try {}
        catch (IOException e) {
            throw new RuntimeException("Cannot close server socket [" + serverSocket + "]");
        }
        serverSocket.close();
        try {
            this.doStopServer();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Cannot stop server");
        }
        try {
            serverSocket.close();
            return;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot close server socket [" + serverSocket + "]");
        }
    }

    private ServerSocket setUpListenerSocket() {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(this.port);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Error setting up the server listener socket");
        }
        return serverSocket;
    }
}

