/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util;

import java.lang.reflect.Method;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.pool.PoolService;
import org.apache.turbine.services.rundata.RunDataService;
import org.apache.turbine.services.rundata.TurbineRunData;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.ServerData;
import org.apache.turbine.util.TurbineException;
import org.apache.turbine.util.parser.DefaultCookieParser;
import org.apache.turbine.util.parser.DefaultParameterParser;

public class RunDataFactory {
    private static boolean tryRunDataService = true;
    static /* synthetic */ Class class$org$apache$turbine$services$rundata$DefaultTurbineRunData;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletRequest;

    public static RunData getRunData(HttpServletRequest req, HttpServletResponse res, ServletConfig config) throws TurbineException, IllegalArgumentException {
        if (req == null || res == null || config == null) {
            throw new IllegalArgumentException("RunDataFactory fatal error: HttpServletRequest, HttpServletResponse or ServletConfig were null.");
        }
        if (tryRunDataService) {
            try {
                RunDataService service = (RunDataService)TurbineServices.getInstance().getService("RunDataService");
                return service.getRunData(req, res, config);
            }
            catch (Exception x) {
                tryRunDataService = false;
            }
        }
        PoolService pool = (PoolService)TurbineServices.getInstance().getService("PoolService");
        TurbineRunData data = (TurbineRunData)pool.getInstance(class$org$apache$turbine$services$rundata$DefaultTurbineRunData == null ? (class$org$apache$turbine$services$rundata$DefaultTurbineRunData = RunDataFactory.class$("org.apache.turbine.services.rundata.DefaultTurbineRunData")) : class$org$apache$turbine$services$rundata$DefaultTurbineRunData);
        data.setRequest(req);
        data.setResponse(res);
        String contextPath = null;
        Class jsdkClass = class$javax$servlet$http$HttpServletRequest == null ? (class$javax$servlet$http$HttpServletRequest = RunDataFactory.class$("javax.servlet.http.HttpServletRequest")) : class$javax$servlet$http$HttpServletRequest;
        try {
            Method meth = jsdkClass.getDeclaredMethod("getContextPath", null);
            contextPath = (String)meth.invoke((Object)req, null);
        }
        catch (Exception ex) {
            contextPath = "";
        }
        String scriptName = contextPath + data.getRequest().getServletPath();
        data.setCookieParser(new DefaultCookieParser());
        data.setParameterParser(new DefaultParameterParser());
        data.setSession(data.getRequest().getSession(true));
        data.setServletConfig(config);
        data.setServerData(new ServerData(data.getRequest().getServerName(), data.getRequest().getServerPort(), data.getRequest().getScheme(), scriptName, contextPath));
        return data;
    }

    public static void putRunData(RunData data) {
        if (tryRunDataService) {
            try {
                RunDataService service = (RunDataService)TurbineServices.getInstance().getService("RunDataService");
                service.putRunData(data);
                return;
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        PoolService pool = (PoolService)TurbineServices.getInstance().getService("PoolService");
        pool.putInstance(data);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

