package jp.sourceforge.jetspeedjapan.portlet.weblog.util;

/* ====================================================================================
 * Copyright (c) 2003, jetspeed-japan.sourceforge.jp
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *     * Redistributions of source code must retain the above copyright notice,
 *     * this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *     * notice, this list of conditions and the following disclaimer in the
 *     * documentation and/or other materials provided with the distribution.
 *     * Neither the name of the jetspeed-japan.sourceforge.jp nor the names 
 *       of its contributors
 *     * may be used to endorse or promote products derived from this software
 *     * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================================
 */

import org.apache.commons.lang.StringUtils;

/**
 * WebLogUtil is the utility class for the Web Log Portlet.
 * 
 * @author <a href="mailto:shinsuke@users.sourceforge.jp">Shinsuke Sugaya</a>
 */
public class WebLogUtil
{
    public static String EDITOR_TEMPLATE = "weblog-editor";
    public static String VIEWER_TEMPLATE = "weblog-viewer";
    public static String CALENDAR_TEMPLATE = "weblog-calendar";
    public static String TOPIC_TEMPLATE = "weblog-topic";

    public static String WEBLOG_MANAGER = "WEBLOG_MANAGER";
    public static String WEBLOG_EDITOR = "WEBLOG_EDITOR";
    public static String WEBLOG_VIEWER = "WEBLOG_VIEWER";
    public static String WEBLOG_CALENDAR = "WEBLOG_CALENDAR";
    public static String WEBLOG_TOPIC = "WEBLOG_TOPIC";

    public static String WEBLOG_TYPE = "WEBLOG_TYPE";
    public static String WEBLOG_EDIT = "WEBLOG_EDIT";
    public static String WEBLOG_VIEW = "WEBLOG_VIEW";

    public static String WEBLOG_CALENDAR_HEADER = "WEBLOG_CALENDAR_HEADER";
    public static String WEBLOG_CALENDAR_FOOTER = "WEBLOG_CALENDAR_FOOTER";
    public static String WEBLOG_EDITOR_HEADER = "WEBLOG_EDITOR_HEADER";
    public static String WEBLOG_EDITOR_FOOTER = "WEBLOG_EDITOR_FOOTER";
    public static String WEBLOG_VIEWER_HEADER = "WEBLOG_VIEWER_HEADER";
    public static String WEBLOG_VIEWER_FOOTER = "WEBLOG_VIEWER_FOOTER";

    public static String CURRENT_URL = "CURRENT_URL";
    public static String USER_NAME = "USER_NAME";
    public static String WEBLOGUTIL = "WEBLOGUTIL";
    public static String YEAR = "YEAR";
    public static String MONTH = "MONTH";
    public static String DAY = "DAY";
    public static String TITLE = "TITLE";
    public static String MESSAGE = "MESSAGE";
    public static String WEBLOGMESSAGEID = "WEBLOGMESSAGEID";
    public static String FORMATTYPE = "FORMATTYPE";
    public static String WEBLOG_PAGE = "WEBLOG_PAGE";
    public static String WEBLOG_NEXTPAGE = "WEBLOG_NEXTPAGE";
    public static String WEBLOG_SIZE = "WEBLOG_SIZE";
    public static String TOPIC_SIZE = "TOPIC_SIZE";

    public static String WEBLOG = "WEBLOG";
    public static String WEBLOGS = "WEBLOGS";
    public static String WEBLOG_MESSAGES = "WEBLOG_MESSAGES";
    public static String INFO_MESSAGE = "INFO_MESSAGE";
    public static String ERROR_MESSAGE = "ERROR_MESSAGE";

    public static String PLAIN = "PLAIN";
    public static String HTML = "HTML";
    public static String WIKI = "WIKI";

    public static String FRAME_BACKGROUND_COLOR = "FRAME_BACKGROUND_COLOR";
    public static String FRAME_TEXT_COLOR = "FRAME_TEXT_COLOR";
    public static String CONTENT_BACKGROUND_COLOR = "CONTENT_BACKGROUND_COLOR";
    public static String CONTENT_TEXT_COLOR = "CONTENT_TEXT_COLOR";
    public static String TARGET_DAY_BACKGROUND_COLOR = "TARGET_DAY_BACKGROUND_COLOR";
    public static String TARGET_DAY_TEXT_COLOR = "TARGET_DAY_TEXT_COLOR";
    public static String DAY_BACKGROUND_COLOR = "DAY_BACKGROUND_COLOR";
    public static String DAY_TEXT_COLOR = "DAY_TEXT_COLOR";
    public static String SUNDAY_BACKGROUND_COLOR = "SUNDAY_BACKGROUND_COLOR";
    public static String SUNDAY_TEXT_COLOR = "SUNDAY_TEXT_COLOR";
    public static String SATURDAY_BACKGROUND_COLOR = "SATURDAY_BACKGROUND_COLOR";
    public static String SATURDAY_TEXT_COLOR = "SATURDAY_TEXT_COLOR";

    /**
     * Encode the string to input to the Database.
     * 
     * @param str   a target string
     * @return      an encoded string
     */
    public static String encodeForDatabase(String str)
    {
        str = StringUtils.replace(str, "&", "&amp;");
        str = StringUtils.replace(str, "\"", "&#34;");
        str = StringUtils.replace(str, "'", "&#39;");
        str = StringUtils.replace(str, "<", "&lt;");
        str = StringUtils.replace(str, ">", "&gt;");
        return str;
    }

    /**
     * Decode the string to output from the Database.
     * 
     * @param str   an encoded string
     * @return      a decoded string
     */
    public static String decodeForDatabase(String str)
    {
        str = StringUtils.replace(str, "&#34;", "\"");
        str = StringUtils.replace(str, "&#39;", "'");
        str = StringUtils.replace(str, "&lt;", "<");
        str = StringUtils.replace(str, "&gt;", ">");
        str = StringUtils.replace(str, "&amp;", "&");
        return str;
    }
}
