package jp.sourceforge.jetspeedjapan.portlet.weblog.om;


import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.Collections;
import java.util.List;

import org.apache.commons.lang.ObjectUtils;
import org.apache.torque.TorqueException;
import org.apache.torque.om.BaseObject;
import org.apache.torque.om.ComboKey;
import org.apache.torque.om.DateKey;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.om.StringKey;
import org.apache.torque.om.Persistent;
import org.apache.torque.util.Criteria;
import org.apache.torque.util.Transaction;

   
   
/**
 * This class was autogenerated by Torque on:
 *
 * [Mon Aug 11 00:36:14 JST 2003]
 *
 * You should not use this class directly.  It should not even be
 * extended all references should be to WeblogMessage
 */
public abstract class BaseWeblogMessage extends BaseObject
{
    /** The Peer class */
    private static final WeblogMessagePeer peer =
        new WeblogMessagePeer();

                  
        /**
         * The value for the weblog_message_id field
         */
        private int weblog_message_id;
              
        /**
         * The value for the weblog_id field
         */
        private int weblog_id;
              
        /**
         * The value for the title field
         */
        private String title;
              
        /**
         * The value for the message field
         */
        private String message;
              
        /**
         * The value for the message_format_type field
         */
        private String message_format_type;
              
        /**
         * The value for the posted_date field
         */
        private Date posted_date;
      
      
        /**
         * Get the WeblogMessageId
         *
         * @return int
         */
        public int getWeblogMessageId()
        {
            return weblog_message_id;
        }

                                            
        /**
         * Set the value of WeblogMessageId
         *
         * @param v new value
         */
        public void setWeblogMessageId(int v) 
        {
          


         if (this.weblog_message_id != v)
        {
             this.weblog_message_id = v;
            setModified(true);
        }

                  
                       }


        /**
         * Get the WeblogId
         *
         * @return int
         */
        public int getWeblogId()
        {
            return weblog_id;
        }

                                                      
        /**
         * Set the value of WeblogId
         *
         * @param v new value
         */
        public void setWeblogId(int v) throws TorqueException
        {
          


         if (this.weblog_id != v)
        {
             this.weblog_id = v;
            setModified(true);
        }

                                          
                if (aWeblog != null && !(aWeblog.getWeblogId()==v))
                {
            aWeblog = null;
        }
          
                       }


        /**
         * Get the Title
         *
         * @return String
         */
        public String getTitle()
        {
            return title;
        }

                                            
        /**
         * Set the value of Title
         *
         * @param v new value
         */
        public void setTitle(String v) 
        {
          


         if (!ObjectUtils.equals(this.title, v))
        {
             this.title = v;
            setModified(true);
        }

                  
                       }


        /**
         * Get the Message
         *
         * @return String
         */
        public String getMessage()
        {
            return message;
        }

                                            
        /**
         * Set the value of Message
         *
         * @param v new value
         */
        public void setMessage(String v) 
        {
          


         if (!ObjectUtils.equals(this.message, v))
        {
             this.message = v;
            setModified(true);
        }

                  
                       }


        /**
         * Get the MessageFormatType
         *
         * @return String
         */
        public String getMessageFormatType()
        {
            return message_format_type;
        }

                                            
        /**
         * Set the value of MessageFormatType
         *
         * @param v new value
         */
        public void setMessageFormatType(String v) 
        {
          


         if (!ObjectUtils.equals(this.message_format_type, v))
        {
             this.message_format_type = v;
            setModified(true);
        }

                  
                       }


        /**
         * Get the PostedDate
         *
         * @return Date
         */
        public Date getPostedDate()
        {
            return posted_date;
        }

                                            
        /**
         * Set the value of PostedDate
         *
         * @param v new value
         */
        public void setPostedDate(Date v) 
        {
          


         if (!ObjectUtils.equals(this.posted_date, v))
        {
             this.posted_date = v;
            setModified(true);
        }

                  
                       }


 
     
   
             
   
       private Weblog aWeblog;

    /**
     * Declares an association between this object and a Weblog object
     *
     * @param v Weblog
     * @throws TorqueException
     */
    public void setWeblog(Weblog v) throws TorqueException
    {
           if (v == null)
        {
                        setWeblogId(0);
                    }
        else
        {
            setWeblogId(v.getWeblogId());
        }
           aWeblog = v;
    }

                 
    /**
     * Get the associated Weblog object
     *
     * @return the associated Weblog object
     * @throws TorqueException
     */
    public Weblog getWeblog() throws TorqueException
    {
        if (aWeblog == null && (this.weblog_id > 0))
        {
              aWeblog = WeblogPeer.retrieveByPK(SimpleKey.keyFor(this.weblog_id));
      
            /* The following can be used instead of the line above to
               guarantee the related object contains a reference
               to this object, but this level of coupling
               may be undesirable in many circumstances.
               As it can lead to a db query with many results that may
               never be used.
               Weblog obj = WeblogPeer.retrieveByPK(this.weblog_id);
               obj.addWeblogMessages(this);
             */
        }
        return aWeblog;
    }

    /**
     * Provides convenient way to set a relationship based on a
     * ObjectKey.  e.g.
     * <code>bar.setFooKey(foo.getPrimaryKey())</code>
     *
     */
    public void setWeblogKey(ObjectKey key) throws TorqueException
    {
    
                                        setWeblogId(((NumberKey) key).intValue());
                    }
    
        
    
    private static List fieldNames = null;

    /**
     * Generate a list of field names.
     *
     * @return a list of field names
     */
    public static synchronized List getFieldNames()
    {
      if (fieldNames == null)
      {
        fieldNames = new ArrayList();
            fieldNames.add("WeblogMessageId");
            fieldNames.add("WeblogId");
            fieldNames.add("Title");
            fieldNames.add("Message");
            fieldNames.add("MessageFormatType");
            fieldNames.add("PostedDate");
            fieldNames = Collections.unmodifiableList(fieldNames);
      }
      return fieldNames;
    }

    /**
     * Retrieves a field from the object by name passed in as a String.
     *
     * @param name field name
     * @return value
     */
    public Object getByName(String name)
    {
            if (name.equals("WeblogMessageId"))
    {
              return new Integer(getWeblogMessageId());
          }
            if (name.equals("WeblogId"))
    {
              return new Integer(getWeblogId());
          }
            if (name.equals("Title"))
    {
              return getTitle();
          }
            if (name.equals("Message"))
    {
              return getMessage();
          }
            if (name.equals("MessageFormatType"))
    {
              return getMessageFormatType();
          }
            if (name.equals("PostedDate"))
    {
              return getPostedDate();
          }
            return null;
    }
    /**
     * Retrieves a field from the object by name passed in
     * as a String.  The String must be one of the static
     * Strings defined in this Class' Peer.
     *
     * @param name peer name
     * @return value
     */
    public Object getByPeerName(String name)
    {
            if (name.equals(WeblogMessagePeer.WEBLOG_MESSAGE_ID))
        {
              return new Integer(getWeblogMessageId());
          }
            if (name.equals(WeblogMessagePeer.WEBLOG_ID))
        {
              return new Integer(getWeblogId());
          }
            if (name.equals(WeblogMessagePeer.TITLE))
        {
              return getTitle();
          }
            if (name.equals(WeblogMessagePeer.MESSAGE))
        {
              return getMessage();
          }
            if (name.equals(WeblogMessagePeer.MESSAGE_FORMAT_TYPE))
        {
              return getMessageFormatType();
          }
            if (name.equals(WeblogMessagePeer.POSTED_DATE))
        {
              return getPostedDate();
          }
            return null;
    }

    /**
     * Retrieves a field from the object by Position as specified
     * in the xml schema.  Zero-based.
     *
     * @param pos position in xml schema
     * @return value
     */
    public Object getByPosition(int pos)
    {
            if (pos == 0)
    {
              return new Integer(getWeblogMessageId());
          }
            if (pos == 1)
    {
              return new Integer(getWeblogId());
          }
            if (pos == 2)
    {
              return getTitle();
          }
            if (pos == 3)
    {
              return getMessage();
          }
            if (pos == 4)
    {
              return getMessageFormatType();
          }
            if (pos == 5)
    {
              return getPostedDate();
          }
                return null;
    }

     


    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
     *
     * @throws Exception
     */
    public void save() throws Exception
    {
             save(WeblogMessagePeer.getMapBuilder()
                .getDatabaseMap().getName());
     }

    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
     * Note: this code is here because the method body is
     * auto-generated conditionally and therefore needs to be
     * in this file instead of in the super class, BaseObject.
     *
     * @param dbName
     * @throws TorqueException
     */
    public void save(String dbName) throws TorqueException
    {
        Connection con = null;
         try
        {
            con = Transaction.begin(dbName);
            save(con);
            Transaction.commit(con);
        }
        catch(TorqueException e)
        {
            Transaction.safeRollback(con);
            throw e;
        }

     }

      /** flag to prevent endless save loop, if this object is referenced
        by another object which falls in this transaction. */
    private boolean alreadyInSave = false;
      /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.  This method
     * is meant to be used as part of a transaction, otherwise use
     * the save() method and the connection details will be handled
     * internally
     *
     * @param con
     * @throws TorqueException
     */
    public void save(Connection con) throws TorqueException
    {
        if (!alreadyInSave)
      {
        alreadyInSave = true;



  
        // If this object has been modified, then save it to the database.
        if (isModified())
        {
            if (isNew())
            {
                WeblogMessagePeer.doInsert((WeblogMessage) this, con);
                setNew(false);
            }
            else
            {
                WeblogMessagePeer.doUpdate((WeblogMessage) this, con);
            }
        }

              alreadyInSave = false;
      }
      }


                
    
    

        /**
     * Set the PrimaryKey using ObjectKey.
     *
     * @param  weblog_message_id ObjectKey
     */
    public void setPrimaryKey(ObjectKey key)
        
    {
                    setWeblogMessageId(((NumberKey) key).intValue());
            }

    /**
     * Set the PrimaryKey using a String.
     *
     * @param key
     */
    public void setPrimaryKey(String key) 
    {
                    setWeblogMessageId(Integer.parseInt(key));
            }


    /**
     * returns an id that differentiates this object from others
     * of its class.
     */
    public ObjectKey getPrimaryKey()
    {
        return SimpleKey.keyFor(getWeblogMessageId());
    }

 

    /**
     * Makes a copy of this object.
     * It creates a new object filling in the simple attributes.
     * It then fills all the association collections and sets the
     * related objects to isNew=true.
     */
    public WeblogMessage copy() throws TorqueException
    {
        return copyInto(new WeblogMessage());
    }

    protected WeblogMessage copyInto(WeblogMessage copyObj) throws TorqueException
    {
        copyObj.setWeblogMessageId(weblog_message_id);
        copyObj.setWeblogId(weblog_id);
        copyObj.setTitle(title);
        copyObj.setMessage(message);
        copyObj.setMessageFormatType(message_format_type);
        copyObj.setPostedDate(posted_date);

                      copyObj.setWeblogMessageId(0);
                                

  
        return copyObj;
    }

    /**
     * returns a peer instance associated with this om.  Since Peer classes
     * are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     */
    public WeblogMessagePeer getPeer()
    {
        return peer;
    }
}
