
-----------------------------------------------------------------------------
-- SECURITY_PRINCIPAL
-----------------------------------------------------------------------------
drop table SECURITY_PRINCIPAL if exists;

CREATE TABLE SECURITY_PRINCIPAL
(
    PRINCIPAL_ID INTEGER,
    CLASSNAME VARCHAR (254),
    IS_MAPPING_ONLY INTEGER,
    IS_ENABLED INTEGER,
    FULL_PATH VARCHAR (254),
    CREATION_DATE TIMESTAMP,
    MODIFIED_DATE TIMESTAMP,
    PRIMARY KEY(PRINCIPAL_ID),
    UNIQUE (FULL_PATH)
);


-----------------------------------------------------------------------------
-- SECURITY_PERMISSION
-----------------------------------------------------------------------------
drop table SECURITY_PERMISSION if exists;

CREATE TABLE SECURITY_PERMISSION
(
    PERMISSION_ID INTEGER,
    CLASSNAME VARCHAR (254),
    NAME VARCHAR (254),
    ACTIONS VARCHAR (254),
    CREATION_DATE TIMESTAMP,
    MODIFIED_DATE TIMESTAMP,
    PRIMARY KEY(PERMISSION_ID)
);


-----------------------------------------------------------------------------
-- PRINCIPAL_PERMISSION
-----------------------------------------------------------------------------
drop table PRINCIPAL_PERMISSION if exists;

CREATE TABLE PRINCIPAL_PERMISSION
(
    PRINCIPAL_ID INTEGER,
    PERMISSION_ID INTEGER,
    PRIMARY KEY(PRINCIPAL_ID,PERMISSION_ID)
);


-----------------------------------------------------------------------------
-- SECURITY_CREDENTIAL
-----------------------------------------------------------------------------
drop table SECURITY_CREDENTIAL if exists;

CREATE TABLE SECURITY_CREDENTIAL
(
    CREDENTIAL_ID INTEGER,
    PRINCIPAL_ID INTEGER,
    COLUMN_VALUE VARCHAR (254),
    TYPE SMALLINT,
    CLASSNAME VARCHAR (254),
    UPDATE_REQUIRED INTEGER,
    IS_ENCODED INTEGER,
    IS_ENABLED INTEGER,
    AUTH_FAILURES SMALLINT,
    IS_EXPIRED INTEGER,
    CREATION_DATE TIMESTAMP,
    MODIFIED_DATE TIMESTAMP,
    PREV_AUTH_DATE TIMESTAMP,
    LAST_AUTH_DATE TIMESTAMP,
    EXPIRATION_DATE DATE,
    PRIMARY KEY(CREDENTIAL_ID)
);


-----------------------------------------------------------------------------
-- SSO_SITE
-----------------------------------------------------------------------------
drop table SSO_SITE if exists;

CREATE TABLE SSO_SITE
(
    SITE_ID INTEGER,
    NAME VARCHAR (254),
    URL VARCHAR (254),
    ALLOW_USER_SET INTEGER,
    REQUIRES_CERTIFICATE INTEGER,
    PRIMARY KEY(SITE_ID),
    UNIQUE (URL)
);


-----------------------------------------------------------------------------
-- SSO_SITE_TO_PRINCIPALS
-----------------------------------------------------------------------------
drop table SSO_SITE_TO_PRINCIPALS if exists;

CREATE TABLE SSO_SITE_TO_PRINCIPALS
(
    SITE_ID INTEGER,
    PRINCIPAL_ID INTEGER,
    PRIMARY KEY(SITE_ID,PRINCIPAL_ID)
);


-----------------------------------------------------------------------------
-- SSO_PRINCIPAL_TO_REMOTE
-----------------------------------------------------------------------------
drop table SSO_PRINCIPAL_TO_REMOTE if exists;

CREATE TABLE SSO_PRINCIPAL_TO_REMOTE
(
    PRINCIPAL_ID INTEGER,
    REMOTE_PRINCIPAL_ID INTEGER,
    PRIMARY KEY(PRINCIPAL_ID,REMOTE_PRINCIPAL_ID)
);


-----------------------------------------------------------------------------
-- SSO_SITE_TO_REMOTE
-----------------------------------------------------------------------------
drop table SSO_SITE_TO_REMOTE if exists;

CREATE TABLE SSO_SITE_TO_REMOTE
(
    SITE_ID INTEGER,
    PRINCIPAL_ID INTEGER,
    PRIMARY KEY(SITE_ID,PRINCIPAL_ID)
);


-----------------------------------------------------------------------------
-- SECURITY_USER_ROLE
-----------------------------------------------------------------------------
drop table SECURITY_USER_ROLE if exists;

CREATE TABLE SECURITY_USER_ROLE
(
    USER_ID INTEGER,
    ROLE_ID INTEGER,
    PRIMARY KEY(USER_ID,ROLE_ID)
);


-----------------------------------------------------------------------------
-- SECURITY_USER_GROUP
-----------------------------------------------------------------------------
drop table SECURITY_USER_GROUP if exists;

CREATE TABLE SECURITY_USER_GROUP
(
    USER_ID INTEGER,
    GROUP_ID INTEGER,
    PRIMARY KEY(USER_ID,GROUP_ID)
);


-----------------------------------------------------------------------------
-- SECURITY_GROUP_ROLE
-----------------------------------------------------------------------------
drop table SECURITY_GROUP_ROLE if exists;

CREATE TABLE SECURITY_GROUP_ROLE
(
    GROUP_ID INTEGER,
    ROLE_ID INTEGER,
    PRIMARY KEY(GROUP_ID,ROLE_ID)
);





    ALTER TABLE PRINCIPAL_PERMISSION
        ADD CONSTRAINT PRINCIPAL_PERMISSION_FK_1 FOREIGN KEY (PERMISSION_ID)
            REFERENCES SECURITY_PERMISSION (PERMISSION_ID)
ON DELETE CASCADE
;
    ALTER TABLE PRINCIPAL_PERMISSION
        ADD CONSTRAINT PRINCIPAL_PERMISSION_FK_2 FOREIGN KEY (PRINCIPAL_ID)
            REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
ON DELETE CASCADE
;


    ALTER TABLE SECURITY_CREDENTIAL
        ADD CONSTRAINT SECURITY_CREDENTIAL_FK_1 FOREIGN KEY (PRINCIPAL_ID)
            REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
ON DELETE CASCADE
;




    ALTER TABLE SSO_SITE_TO_PRINCIPALS
        ADD CONSTRAINT SSO_SITE_TO_PRINCIPALS_FK_1 FOREIGN KEY (SITE_ID)
            REFERENCES SSO_SITE (SITE_ID)
ON DELETE CASCADE
;
    ALTER TABLE SSO_SITE_TO_PRINCIPALS
        ADD CONSTRAINT SSO_SITE_TO_PRINCIPALS_FK_2 FOREIGN KEY (PRINCIPAL_ID)
            REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
ON DELETE CASCADE
;


    ALTER TABLE SSO_PRINCIPAL_TO_REMOTE
        ADD CONSTRAINT SSO_PRINCIPAL_TO_REMOTE_FK_1 FOREIGN KEY (PRINCIPAL_ID)
            REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
ON DELETE CASCADE
;
    ALTER TABLE SSO_PRINCIPAL_TO_REMOTE
        ADD CONSTRAINT SSO_PRINCIPAL_TO_REMOTE_FK_2 FOREIGN KEY (REMOTE_PRINCIPAL_ID)
            REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
ON DELETE CASCADE
;


    ALTER TABLE SSO_SITE_TO_REMOTE
        ADD CONSTRAINT SSO_SITE_TO_REMOTE_FK_1 FOREIGN KEY (SITE_ID)
            REFERENCES SSO_SITE (SITE_ID)
ON DELETE CASCADE
;
    ALTER TABLE SSO_SITE_TO_REMOTE
        ADD CONSTRAINT SSO_SITE_TO_REMOTE_FK_2 FOREIGN KEY (PRINCIPAL_ID)
            REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
ON DELETE CASCADE
;


    ALTER TABLE SECURITY_USER_ROLE
        ADD CONSTRAINT SECURITY_USER_ROLE_FK_1 FOREIGN KEY (ROLE_ID)
            REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
ON DELETE CASCADE
;
    ALTER TABLE SECURITY_USER_ROLE
        ADD CONSTRAINT SECURITY_USER_ROLE_FK_2 FOREIGN KEY (USER_ID)
            REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
ON DELETE CASCADE
;


    ALTER TABLE SECURITY_USER_GROUP
        ADD CONSTRAINT SECURITY_USER_GROUP_FK_1 FOREIGN KEY (GROUP_ID)
            REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
ON DELETE CASCADE
;
    ALTER TABLE SECURITY_USER_GROUP
        ADD CONSTRAINT SECURITY_USER_GROUP_FK_2 FOREIGN KEY (USER_ID)
            REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
ON DELETE CASCADE
;


    ALTER TABLE SECURITY_GROUP_ROLE
        ADD CONSTRAINT SECURITY_GROUP_ROLE_FK_1 FOREIGN KEY (GROUP_ID)
            REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
ON DELETE CASCADE
;
    ALTER TABLE SECURITY_GROUP_ROLE
        ADD CONSTRAINT SECURITY_GROUP_ROLE_FK_2 FOREIGN KEY (ROLE_ID)
            REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
ON DELETE CASCADE
;


