
-----------------------------------------------------------------------------
-- PORTLET_DEFINITION
-----------------------------------------------------------------------------
drop table PORTLET_DEFINITION if exists;

CREATE TABLE PORTLET_DEFINITION
(
    ID INTEGER,
    NAME VARCHAR (80),
    CLASS_NAME VARCHAR (255),
    APPLICATION_ID INTEGER,
    PORTLET_IDENTIFIER VARCHAR (80),
    EXPIRATION_CACHE VARCHAR (30),
    RESOURCE_BUNDLE VARCHAR (255),
    PREFERENCE_VALIDATOR VARCHAR (255),
    PRIMARY KEY(ID)
);


-----------------------------------------------------------------------------
-- PORTLET_APPLICATION
-----------------------------------------------------------------------------
drop table PORTLET_APPLICATION if exists;

CREATE TABLE PORTLET_APPLICATION
(
    APPLICATION_ID INTEGER,
    APP_NAME VARCHAR (80),
    APP_IDENTIFIER VARCHAR (80),
    VERSION VARCHAR (80),
    APP_TYPE INTEGER,
    CHECKSUM VARCHAR (80),
    DESCRIPTION VARCHAR (80),
    WEB_APP_ID INTEGER,
    PRIMARY KEY(APPLICATION_ID),
    UNIQUE (APP_NAME)
);


-----------------------------------------------------------------------------
-- WEB_APPLICATION
-----------------------------------------------------------------------------
drop table WEB_APPLICATION if exists;

CREATE TABLE WEB_APPLICATION
(
    ID INTEGER,
    CONTEXT_ROOT VARCHAR (255),
    PRIMARY KEY(ID)
);


-----------------------------------------------------------------------------
-- PA_METADATA_FIELDS
-----------------------------------------------------------------------------
drop table PA_METADATA_FIELDS if exists;

CREATE TABLE PA_METADATA_FIELDS
(
    ID INTEGER,
    OBJECT_ID INTEGER,
    COLUMN_VALUE VARCHAR,
    NAME VARCHAR (100),
    LOCALE_STRING VARCHAR (50),
    PRIMARY KEY(ID)
);


-----------------------------------------------------------------------------
-- PD_METADATA_FIELDS
-----------------------------------------------------------------------------
drop table PD_METADATA_FIELDS if exists;

CREATE TABLE PD_METADATA_FIELDS
(
    ID INTEGER,
    OBJECT_ID INTEGER,
    COLUMN_VALUE VARCHAR,
    NAME VARCHAR (100),
    LOCALE_STRING VARCHAR (50),
    PRIMARY KEY(ID)
);


-----------------------------------------------------------------------------
-- LANGUAGE
-----------------------------------------------------------------------------
drop table LANGUAGE if exists;

CREATE TABLE LANGUAGE
(
    ID INTEGER,
    PORTLET_ID INTEGER,
    TITLE VARCHAR (100),
    SHORT_TITLE VARCHAR (50),
    LOCALE_STRING VARCHAR (50),
    KEYWORDS VARCHAR,
    PRIMARY KEY(ID)
);


-----------------------------------------------------------------------------
-- PORTLET_CONTENT_TYPE
-----------------------------------------------------------------------------
drop table PORTLET_CONTENT_TYPE if exists;

CREATE TABLE PORTLET_CONTENT_TYPE
(
    CONTENT_TYPE_ID INTEGER,
    PORTLET_ID INTEGER,
    CONTENT_TYPE VARCHAR (30),
    MODES VARCHAR,
    PRIMARY KEY(CONTENT_TYPE_ID)
);


-----------------------------------------------------------------------------
-- PARAMETER
-----------------------------------------------------------------------------
drop table PARAMETER if exists;

CREATE TABLE PARAMETER
(
    PARAMETER_ID INTEGER,
    PARENT_ID INTEGER,
    CLASS_NAME VARCHAR (255),
    NAME VARCHAR (80),
    PARAMETER_VALUE VARCHAR,
    PRIMARY KEY(PARAMETER_ID)
);


-----------------------------------------------------------------------------
-- PREFERENCE_VALUE
-----------------------------------------------------------------------------
drop table PREFERENCE_VALUE if exists;

CREATE TABLE PREFERENCE_VALUE
(
    ID INTEGER,
    PREFERENCE_ID INTEGER,
    VALUE VARCHAR,
    PRIMARY KEY(ID)
);


-----------------------------------------------------------------------------
-- PORTLET_PREFERENCE
-----------------------------------------------------------------------------
drop table PORTLET_PREFERENCE if exists;

CREATE TABLE PORTLET_PREFERENCE
(
    ID INTEGER,
    PARENT_ID INTEGER,
    NAME VARCHAR (80),
    CLASS_NAME VARCHAR (255),
    READ_ONLY VARCHAR (1),
    PRIMARY KEY(ID)
);


-----------------------------------------------------------------------------
-- PORTLET_ENTITY
-----------------------------------------------------------------------------
drop table PORTLET_ENTITY if exists;

CREATE TABLE PORTLET_ENTITY
(
    PEID INTEGER,
    ID VARCHAR (255),
    APP_NAME VARCHAR (255),
    PORTLET_NAME VARCHAR (255),
    PRIMARY KEY(PEID),
    UNIQUE (ID)
);


-----------------------------------------------------------------------------
-- SECURITY_ROLE_REFERENCE
-----------------------------------------------------------------------------
drop table SECURITY_ROLE_REFERENCE if exists;

CREATE TABLE SECURITY_ROLE_REFERENCE
(
    ID INTEGER,
    PORTLET_DEFINITION_ID INTEGER,
    ROLE_NAME VARCHAR (150),
    ROLE_LINK VARCHAR (150),
    PRIMARY KEY(ID)
);


-----------------------------------------------------------------------------
-- SECURITY_ROLE
-----------------------------------------------------------------------------
drop table SECURITY_ROLE if exists;

CREATE TABLE SECURITY_ROLE
(
    ID INTEGER,
    WEB_APPLICATION_ID INTEGER,
    ROLE_NAME VARCHAR (150),
    DESCRIPTION VARCHAR (150),
    PRIMARY KEY(ID)
);


-----------------------------------------------------------------------------
-- USER_ATTRIBUTE_REF
-----------------------------------------------------------------------------
drop table USER_ATTRIBUTE_REF if exists;

CREATE TABLE USER_ATTRIBUTE_REF
(
    ID INTEGER,
    APPLICATION_ID INTEGER,
    NAME VARCHAR (150),
    NAME_LINK VARCHAR (150),
    PRIMARY KEY(ID)
);


-----------------------------------------------------------------------------
-- USER_ATTRIBUTE
-----------------------------------------------------------------------------
drop table USER_ATTRIBUTE if exists;

CREATE TABLE USER_ATTRIBUTE
(
    ID INTEGER,
    APPLICATION_ID INTEGER,
    NAME VARCHAR (150),
    DESCRIPTION VARCHAR (150),
    PRIMARY KEY(ID)
);


-----------------------------------------------------------------------------
-- JETSPEED_SERVICE
-----------------------------------------------------------------------------
drop table JETSPEED_SERVICE if exists;

CREATE TABLE JETSPEED_SERVICE
(
    ID INTEGER,
    APPLICATION_ID INTEGER,
    NAME VARCHAR (150),
    PRIMARY KEY(ID)
);


-----------------------------------------------------------------------------
-- LOCALIZED_DESCRIPTION
-----------------------------------------------------------------------------
drop table LOCALIZED_DESCRIPTION if exists;

CREATE TABLE LOCALIZED_DESCRIPTION
(
    ID INTEGER,
    OBJECT_ID INTEGER,
    CLASS_NAME VARCHAR (255),
    DESCRIPTION VARCHAR,
    LOCALE_STRING VARCHAR (50),
    PRIMARY KEY(ID)
);


-----------------------------------------------------------------------------
-- LOCALIZED_DISPLAY_NAME
-----------------------------------------------------------------------------
drop table LOCALIZED_DISPLAY_NAME if exists;

CREATE TABLE LOCALIZED_DISPLAY_NAME
(
    ID INTEGER,
    OBJECT_ID INTEGER,
    CLASS_NAME VARCHAR (255),
    DISPLAY_NAME VARCHAR,
    LOCALE_STRING VARCHAR (50),
    PRIMARY KEY(ID)
);







    ALTER TABLE PA_METADATA_FIELDS
        ADD CONSTRAINT PA_METADATA_FIELDS_FK_1 FOREIGN KEY (OBJECT_ID)
            REFERENCES PORTLET_APPLICATION (APPLICATION_ID)
ON DELETE CASCADE
;


    ALTER TABLE PD_METADATA_FIELDS
        ADD CONSTRAINT PD_METADATA_FIELDS_FK_1 FOREIGN KEY (OBJECT_ID)
            REFERENCES PORTLET_DEFINITION (ID)
ON DELETE CASCADE
;


















    ALTER TABLE USER_ATTRIBUTE_REF
        ADD CONSTRAINT USER_ATTRIBUTE_REF_FK_1 FOREIGN KEY (APPLICATION_ID)
            REFERENCES PORTLET_APPLICATION (APPLICATION_ID)
ON DELETE CASCADE
;


    ALTER TABLE USER_ATTRIBUTE
        ADD CONSTRAINT USER_ATTRIBUTE_FK_1 FOREIGN KEY (APPLICATION_ID)
            REFERENCES PORTLET_APPLICATION (APPLICATION_ID)
ON DELETE CASCADE
;








