
-----------------------------------------------------------------------------
-- SUB_PAGES
-----------------------------------------------------------------------------
drop table SUB_PAGES if exists;

CREATE TABLE SUB_PAGES
(
    PAGE_ID VARCHAR (80),
    SUB_PAGE_ID VARCHAR (80)
);

CREATE  INDEX IX_SUB_PAGES_1 ON SUB_PAGES (PAGE_ID, SUB_PAGE_ID);
-----------------------------------------------------------------------------
-- PAGE
-----------------------------------------------------------------------------
drop table PAGE if exists;

CREATE TABLE PAGE
(
    PAGE_ID VARCHAR (80),
    TITLE VARCHAR (100),
    DEFAULT_SKIN VARCHAR (100),
    DEFAULT_DECORATOR VARCHAR (100),
    DEFAULT_PORTLET_DECORATOR VARCHAR (100),
    ACL VARCHAR (80),
    PRIMARY KEY(PAGE_ID)
);


-----------------------------------------------------------------------------
-- FRAGMENT
-----------------------------------------------------------------------------
drop table FRAGMENT if exists;

CREATE TABLE FRAGMENT
(
    FRAGMENT_ID VARCHAR (80),
    COMPONENT_NAME VARCHAR (100),
    ACL VARCHAR (80),
    TITLE VARCHAR (100),
    TYPE VARCHAR (40),
    SKIN VARCHAR (80),
    DECORATOR VARCHAR (80),
    STATE VARCHAR (40),
    PRIMARY KEY(FRAGMENT_ID)
);


-----------------------------------------------------------------------------
-- PAGE_FRAGMENTS
-----------------------------------------------------------------------------
drop table PAGE_FRAGMENTS if exists;

CREATE TABLE PAGE_FRAGMENTS
(
    PAGE_ID VARCHAR (80),
    FRAGMENT_ID VARCHAR (80)
);

CREATE  INDEX IX_PAGE_FRAGMENTS_1 ON PAGE_FRAGMENTS (PAGE_ID, FRAGMENT_ID);
-----------------------------------------------------------------------------
-- SUB_FRAGMENTS
-----------------------------------------------------------------------------
drop table SUB_FRAGMENTS if exists;

CREATE TABLE SUB_FRAGMENTS
(
    FRAGMENT_ID VARCHAR (80),
    SUB_FRAGMENT_ID VARCHAR (80)
);

CREATE  INDEX IX_SUB_FRAGMENTS_1 ON SUB_FRAGMENTS (FRAGMENT_ID, SUB_FRAGMENT_ID);
-----------------------------------------------------------------------------
-- FRAGMENT_PARAMETER
-----------------------------------------------------------------------------
drop table FRAGMENT_PARAMETER if exists;

CREATE TABLE FRAGMENT_PARAMETER
(
    PARAMETER_ID INTEGER,
    FRAGMENT_ID INTEGER,
    NAME VARCHAR (80),
    COLUMN_VALUE VARCHAR,
    PRIMARY KEY(PARAMETER_ID),
    UNIQUE (FRAGMENT_ID, PARAMETER_ID)
);


-----------------------------------------------------------------------------
-- FRAGMENT_REF
-----------------------------------------------------------------------------
drop table FRAGMENT_REF if exists;

CREATE TABLE FRAGMENT_REF
(
    FRAGMENT_REF_ID VARCHAR (80),
    FRAGMENT_ID VARCHAR (80),
    NAME VARCHAR (80),
    TITLE VARCHAR (100),
    PRIMARY KEY(FRAGMENT_REF_ID)
);


-----------------------------------------------------------------------------
-- FRAGMENT_REFS
-----------------------------------------------------------------------------
drop table FRAGMENT_REFS if exists;

CREATE TABLE FRAGMENT_REFS
(
    FRAGMENT_REF_ID VARCHAR (80),
    FRAGMENT_ID VARCHAR (80)
);


-----------------------------------------------------------------------------
-- PROFILING_RULE
-----------------------------------------------------------------------------
drop table PROFILING_RULE if exists;

CREATE TABLE PROFILING_RULE
(
    RULE_ID VARCHAR (80),
    CLASS_NAME VARCHAR (100),
    TITLE VARCHAR (100),
    PRIMARY KEY(RULE_ID)
);


-----------------------------------------------------------------------------
-- RULE_CRITERION
-----------------------------------------------------------------------------
drop table RULE_CRITERION if exists;

CREATE TABLE RULE_CRITERION
(
    CRITERION_ID VARCHAR (80),
    RULE_ID VARCHAR (80),
    FALLBACK_ORDER INTEGER,
    REQUEST_TYPE VARCHAR (40),
    NAME VARCHAR (80),
    COLUMN_VALUE VARCHAR (128),
    FALLBACK_TYPE INTEGER,
    PRIMARY KEY(CRITERION_ID)
);

CREATE  INDEX IX_RULE_CRITERION_1 ON RULE_CRITERION (RULE_ID, FALLBACK_ORDER);
-----------------------------------------------------------------------------
-- PRINCIPAL_RULE_ASSOC
-----------------------------------------------------------------------------
drop table PRINCIPAL_RULE_ASSOC if exists;

CREATE TABLE PRINCIPAL_RULE_ASSOC
(
    PRINCIPAL_NAME VARCHAR (80),
    LOCATOR_NAME VARCHAR (80),
    RULE_ID VARCHAR (80),
    PRIMARY KEY(PRINCIPAL_NAME,LOCATOR_NAME)
);


-----------------------------------------------------------------------------
-- PROFILE_PAGE_ASSOC
-----------------------------------------------------------------------------
drop table PROFILE_PAGE_ASSOC if exists;

CREATE TABLE PROFILE_PAGE_ASSOC
(
    LOCATOR_HASH VARCHAR (40),
    PAGE_ID VARCHAR (80),
    UNIQUE (LOCATOR_HASH, PAGE_ID)
);


-----------------------------------------------------------------------------
-- CLUBS
-----------------------------------------------------------------------------
drop table CLUBS if exists;

CREATE TABLE CLUBS
(
    NAME VARCHAR (80),
    COUNTRY VARCHAR (40),
    CITY VARCHAR (40),
    STADIUM VARCHAR (80),
    CAPACITY INTEGER,
    FOUNDED INTEGER,
    PITCH VARCHAR (40),
    NICKNAME VARCHAR (40),
    PRIMARY KEY(NAME)
);



















    ALTER TABLE RULE_CRITERION
        ADD CONSTRAINT RULE_CRITERION_FK_1 FOREIGN KEY (RULE_ID)
            REFERENCES PROFILING_RULE (RULE_ID)
ON DELETE CASCADE
;








