/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.cache.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.cache.file.FileCacheEntry;
import org.apache.jetspeed.cache.file.FileCacheEntryImpl;
import org.apache.jetspeed.cache.file.FileCacheEventListener;

public class FileCache
implements Comparator {
    protected long scanRate = 300L;
    protected int maxSize = 100;
    protected List listeners = new LinkedList();
    private FileCacheScanner scanner = null;
    private Map cache = null;
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$cache$file$FileCache == null ? (class$org$apache$jetspeed$cache$file$FileCache = FileCache.class$("org.apache.jetspeed.cache.file.FileCache")) : class$org$apache$jetspeed$cache$file$FileCache));
    static /* synthetic */ Class class$org$apache$jetspeed$cache$file$FileCache;

    public FileCache() {
        this.cache = new HashMap();
        this.scanner = new FileCacheScanner();
        this.scanner.setDaemon(true);
    }

    public FileCache(long scanRate, int maxSize) {
        this.cache = new HashMap();
        this.scanRate = scanRate;
        this.maxSize = maxSize;
        this.scanner = new FileCacheScanner();
        this.scanner.setDaemon(true);
    }

    public FileCache(int initialCapacity, int loadFactor, long scanRate, int maxSize) {
        this.cache = new HashMap(initialCapacity, loadFactor);
        this.scanRate = scanRate;
        this.maxSize = maxSize;
        this.scanner = new FileCacheScanner();
        this.scanner.setDaemon(true);
    }

    public void setScanRate(long scanRate) {
        this.scanRate = scanRate;
    }

    public long getScanRate() {
        return this.scanRate;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public FileCacheEntry get(String key) {
        return (FileCacheEntry)this.cache.get(key);
    }

    public Object getDocument(String key) {
        FileCacheEntry entry = (FileCacheEntry)this.cache.get(key);
        if (entry != null) {
            return entry.getDocument();
        }
        return null;
    }

    public void put(File file, Object document) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException("File to cache: " + file.getAbsolutePath() + " does not exist.");
        }
        FileCacheEntryImpl entry = new FileCacheEntryImpl(file, document);
        this.cache.put(file.getCanonicalPath(), entry);
    }

    public void put(String key, Object document, File rootFile) throws IOException {
        File file = new File(rootFile, key);
        if (!file.exists()) {
            throw new FileNotFoundException("File to cache: " + file.getAbsolutePath() + " does not exist.");
        }
        FileCacheEntryImpl entry = new FileCacheEntryImpl(file, document);
        this.cache.put(key, entry);
    }

    public Object remove(String key) {
        return this.cache.remove(key);
    }

    public void addListener(FileCacheEventListener listener) {
        this.listeners.add(listener);
    }

    public void startFileScanner() {
        try {
            this.scanner.start();
        }
        catch (IllegalThreadStateException e) {
            log.error((Object)"Exception starting scanner", (Throwable)e);
        }
    }

    public void stopFileScanner() {
        this.scanner.setStopping(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void evict() {
        Map map = this.cache;
        synchronized (map) {
            if (this.getMaxSize() >= this.cache.size()) {
                return;
            }
            LinkedList list = new LinkedList(this.cache.values());
            Collections.sort(list, this);
            int limit = this.cache.size() - this.getMaxSize();
            Iterator it = list.iterator();
            for (int count = 0; it.hasNext() && count < limit; ++count) {
                FileCacheEntry entry = (FileCacheEntry)it.next();
                String key = null;
                try {
                    key = entry.getFile().getCanonicalPath();
                }
                catch (IOException e) {
                    log.error((Object)"Exception getting file path: ", (Throwable)e);
                }
                Iterator lit = this.listeners.iterator();
                while (lit.hasNext()) {
                    FileCacheEventListener listener = (FileCacheEventListener)lit.next();
                    try {
                        listener.evict(entry);
                    }
                    catch (Exception e1) {
                        log.warn((Object)("Unable to evict cache entry.  " + e1.toString()), (Throwable)e1);
                    }
                }
                this.cache.remove(key);
            }
        }
    }

    public int compare(Object o1, Object o2) {
        FileCacheEntry e1 = (FileCacheEntry)o1;
        FileCacheEntry e2 = (FileCacheEntry)o2;
        if (e1.getLastAccessed() < e2.getLastAccessed()) {
            return -1;
        }
        if (e1.getLastAccessed() == e2.getLastAccessed()) {
            return 0;
        }
        return 1;
    }

    public Iterator getIterator() {
        return this.cache.values().iterator();
    }

    public int getSize() {
        return this.cache.size();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class FileCacheScanner
    extends Thread {
        private boolean stopping = false;

        protected FileCacheScanner() {
        }

        public void setStopping(boolean flag) {
            this.stopping = flag;
        }

        public void run() {
            boolean done = false;
            try {
                while (!done) {
                    try {
                        int count = 0;
                        Iterator it = FileCache.this.cache.values().iterator();
                        while (it.hasNext()) {
                            FileCacheEntry entry = (FileCacheEntry)it.next();
                            Date modified = new Date(entry.getFile().lastModified());
                            if (modified.after(entry.getLastModified())) {
                                Iterator lit = FileCache.this.listeners.iterator();
                                while (lit.hasNext()) {
                                    FileCacheEventListener listener = (FileCacheEventListener)lit.next();
                                    try {
                                        listener.refresh(entry);
                                    }
                                    catch (Exception e1) {
                                        log.warn((Object)("Unable to refresh cached document:  " + e1.toString()), (Throwable)e1);
                                    }
                                    entry.setLastModified(modified);
                                }
                            }
                            ++count;
                        }
                        if (count > FileCache.this.getMaxSize()) {
                            FileCache.this.evict();
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)"FileCache Scanner: Error in iteration...", (Throwable)e);
                    }
                    FileCacheScanner.sleep(FileCache.this.getScanRate() * 1000L);
                    if (!this.stopping) continue;
                    this.stopping = false;
                    done = true;
                }
            }
            catch (InterruptedException e) {
                log.error((Object)"FileCacheScanner: recieved interruption, exiting.", (Throwable)e);
            }
        }
    }
}

