/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.testhelpers;

import java.util.Map;
import java.util.Properties;
import org.apache.jetspeed.testhelpers.DatasourceHelper;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.orm.ojb.PersistenceBrokerTransactionManager;
import org.springframework.orm.ojb.support.LocalOjbConfigurer;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.TransactionProxyFactoryBean;

public class OJBHelper
extends DatasourceHelper {
    public static final String DATASOURCE_BEAN = "JetspeedDS";
    private GenericApplicationContext appCtx;
    private DefaultListableBeanFactory bf;

    public OJBHelper(Map context) {
        super(context);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.bf = new DefaultListableBeanFactory();
        this.bf.registerSingleton(DATASOURCE_BEAN, (Object)this.datasource);
        LocalOjbConfigurer ojbConfigurer = new LocalOjbConfigurer();
        ojbConfigurer.setBeanFactory((BeanFactory)this.bf);
        this.addBeanFactory((ConfigurableBeanFactory)this.bf);
        this.appCtx = new GenericApplicationContext(this.bf);
        this.bf.preInstantiateSingletons();
        this.getContext().put("AppContext", this.appCtx);
    }

    public void tearDown() throws Exception {
        this.bf.destroySingletons();
        super.tearDown();
    }

    public Object getTxProxiedObject(Object object, String[] interfacesToProxyAs) throws Exception {
        TransactionProxyFactoryBean txfb = new TransactionProxyFactoryBean();
        txfb.setTransactionManager((PlatformTransactionManager)new PersistenceBrokerTransactionManager());
        Properties txProps = new Properties();
        txProps.setProperty("*", "PROPAGATION_REQUIRED");
        txfb.setTransactionAttributes(txProps);
        txfb.setTarget(object);
        txfb.setProxyInterfaces(interfacesToProxyAs);
        txfb.afterPropertiesSet();
        return txfb.getObject();
    }
}

