/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.mocks;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.jetspeed.mocks.BaseMockServletContext;

public class ResourceLocatingServletContext
extends BaseMockServletContext {
    private final File rootPath;
    private final Map pathOverrides;

    public ResourceLocatingServletContext(File rootPath) {
        this.rootPath = rootPath;
        this.pathOverrides = new HashMap();
    }

    public final void addPathOverride(String path, File file) {
        this.pathOverrides.put(path, file);
    }

    public URL getResource(String path) throws MalformedURLException {
        if (this.pathOverrides.containsKey(path)) {
            return ((File)this.pathOverrides.get(path)).toURL();
        }
        return new File(this.rootPath, path).toURL();
    }

    public String getRealPath(String path) {
        if (this.pathOverrides.containsKey(path)) {
            return ((File)this.pathOverrides.get(path)).getAbsolutePath();
        }
        return new File(this.rootPath, path).getAbsolutePath();
    }

    public InputStream getResourceAsStream(String path) {
        try {
            return this.getResource(path).openStream();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Set getResourcePaths(String path) {
        File start = new File(this.rootPath, path);
        File[] children = start.listFiles();
        HashSet<String> pathes = new HashSet<String>();
        for (int i = 0; i < children.length; ++i) {
            File child = children[i];
            String relativePath = child.getPath().substring(this.rootPath.getPath().length()).replace('\\', '/');
            if (child.isDirectory()) {
                pathes.add(relativePath + "/");
                continue;
            }
            pathes.add(relativePath);
        }
        Iterator itr = this.pathOverrides.keySet().iterator();
        while (itr.hasNext()) {
            pathes.add((String)itr.next());
        }
        return pathes;
    }
}

