/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.components.rdbms.ojb;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.accesslayer.LookupException;
import org.apache.ojb.broker.metadata.ConnectionPoolDescriptor;
import org.apache.ojb.broker.metadata.ConnectionRepository;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.metadata.JdbcMetadataUtils;
import org.apache.ojb.broker.metadata.MetadataManager;
import org.apache.ojb.broker.util.ClassHelper;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;

public class ConnectionRepositoryEntry
implements BeanNameAware,
InitializingBean {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$components$rdbms$ojb$ConnectionRepositoryEntry == null ? (class$org$apache$jetspeed$components$rdbms$ojb$ConnectionRepositoryEntry = ConnectionRepositoryEntry.class$("org.apache.jetspeed.components.rdbms.ojb.ConnectionRepositoryEntry")) : class$org$apache$jetspeed$components$rdbms$ojb$ConnectionRepositoryEntry));
    private String jcdAlias = null;
    private String platform = null;
    private String connectionFactoryClass = null;
    private String jndiName = null;
    private String driverClassName = null;
    private String url = null;
    private String username = null;
    private String password = null;
    static /* synthetic */ Class class$org$apache$jetspeed$components$rdbms$ojb$ConnectionRepositoryEntry;
    static /* synthetic */ Class class$org$apache$ojb$broker$accesslayer$ConnectionFactoryManagedImpl;
    static /* synthetic */ Class class$org$apache$ojb$broker$accesslayer$ConnectionFactoryDBCPImpl;

    public void setBeanName(String beanName) {
        if (this.jcdAlias == null) {
            this.jcdAlias = beanName;
        }
    }

    public String getJcdAlias() {
        return this.jcdAlias;
    }

    public void setJcdAlias(String jcdAlias) {
        this.jcdAlias = jcdAlias;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void afterPropertiesSet() throws Exception {
        ConnectionRepository cr = MetadataManager.getInstance().connectionRepository();
        JdbcConnectionDescriptor jcd = cr.getDescriptor(new PBKey(this.jcdAlias));
        if (jcd == null) {
            jcd = new JdbcConnectionDescriptor();
            jcd.setJcdAlias(this.jcdAlias);
            cr.addDescriptor(jcd);
        }
        if (this.platform != null && this.platform.length() == 0) {
            this.platform = null;
        }
        DataSource ds = null;
        JdbcMetadataUtils jdbcMetadataUtils = new JdbcMetadataUtils();
        if (this.jndiName != null) {
            if (this.connectionFactoryClass == null) {
                this.connectionFactoryClass = (class$org$apache$ojb$broker$accesslayer$ConnectionFactoryManagedImpl == null ? (class$org$apache$ojb$broker$accesslayer$ConnectionFactoryManagedImpl = ConnectionRepositoryEntry.class$("org.apache.ojb.broker.accesslayer.ConnectionFactoryManagedImpl")) : class$org$apache$ojb$broker$accesslayer$ConnectionFactoryManagedImpl).getName();
            }
            InitialContext initialContext = new InitialContext();
            ds = (DataSource)initialContext.lookup(this.jndiName);
            jcd.setDatasourceName(this.jndiName);
        } else {
            if (this.connectionFactoryClass == null) {
                this.connectionFactoryClass = (class$org$apache$ojb$broker$accesslayer$ConnectionFactoryDBCPImpl == null ? (class$org$apache$ojb$broker$accesslayer$ConnectionFactoryDBCPImpl = ConnectionRepositoryEntry.class$("org.apache.ojb.broker.accesslayer.ConnectionFactoryDBCPImpl")) : class$org$apache$ojb$broker$accesslayer$ConnectionFactoryDBCPImpl).getName();
            }
            jcd.setDriver(this.driverClassName);
            HashMap conData = jdbcMetadataUtils.parseConnectionUrl(this.url);
            jcd.setDbms(this.platform);
            jcd.setProtocol((String)conData.get("protocol"));
            jcd.setSubProtocol((String)conData.get("subprotocol"));
            jcd.setDbAlias((String)conData.get("dbAlias"));
            jcd.setUserName(this.username);
            jcd.setPassWord(this.password);
            ds = new MinimalDataSource(jcd);
        }
        ConnectionPoolDescriptor cpd = jcd.getConnectionPoolDescriptor();
        if (cpd == null) {
            cpd = new ConnectionPoolDescriptor();
            jcd.setConnectionPoolDescriptor(cpd);
        }
        Class conFacCls = ClassHelper.getClass((String)this.connectionFactoryClass);
        cpd.setConnectionFactory(conFacCls);
        jdbcMetadataUtils.fillJCDFromDataSource(jcd, ds, null, null);
        if (this.platform == null && jcd.getDbms().equals("Oracle")) {
            this.updateOraclePlatform(jcd, ds);
        }
        if (this.platform != null) {
            if (!this.platform.equals(jcd.getDbms())) {
                log.warn((Object)("Automatically derived RDBMS platform \"" + jcd.getDbms() + "\" differs from explicitly set platform \"" + this.platform + "\""));
            }
            jcd.setDbms(this.platform);
        } else {
            this.platform = jcd.getDbms();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void updateOraclePlatform(JdbcConnectionDescriptor jcd, DataSource ds) throws LookupException, IllegalAccessException, InstantiationException, SQLException {
        con = null;
        try {
            con = ds.getConnection();
            metaData = con.getMetaData();
            rdbmsVersion = 0;
            try {
                rdbmsVersion = metaData.getDatabaseMajorVersion();
                ** GOTO lbl36
            }
            catch (Throwable t) {
                dbVersion = metaData.getDatabaseProductVersion();
                relKey = "Release";
                major = dbVersion;
                startPos = dbVersion.indexOf(relKey);
                if (startPos < 0) {
                    ConnectionRepositoryEntry.log.warn((Object)("Cannot determine Oracle version, no \"Release\" in procuct version: \"" + dbVersion + "\""));
                    if (con != null) {
                        con.close();
                    }
                    return;
                }
                dotPos = dbVersion.indexOf(46, startPos += relKey.length());
                if (dotPos > 0) {
                    major = dbVersion.substring(startPos, dotPos).trim();
                }
                try {
                    rdbmsVersion = Integer.parseInt(major);
                }
                catch (NumberFormatException e) {
                    ConnectionRepositoryEntry.log.warn((Object)("Cannot determine Oracle version, product version \"" + dbVersion + "\" not layed out as \"... Release N.M.....\""));
                    if (con != null) {
                        con.close();
                    }
                    return;
                }
                if (ConnectionRepositoryEntry.log.isDebugEnabled()) {
                    ConnectionRepositoryEntry.log.debug((Object)("Extracted Oracle major version " + rdbmsVersion + " from product version \"" + dbVersion + "\""));
                }
lbl36:
                // 4 sources

                if (rdbmsVersion >= 9) {
                    jcd.setDbms("Oracle9i");
                }
            }
        }
        finally {
            if (con != null) {
                con.close();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MinimalDataSource
    implements DataSource {
        private JdbcConnectionDescriptor jcd = null;

        public MinimalDataSource(JdbcConnectionDescriptor jcd) {
            this.jcd = jcd;
        }

        public Connection getConnection() throws SQLException {
            try {
                ClassHelper.getClass((String)this.jcd.getDriver(), (boolean)true);
                String url = this.jcd.getProtocol() + ":" + this.jcd.getSubProtocol() + ":" + this.jcd.getDbAlias();
                if (this.jcd.getUserName() == null) {
                    return DriverManager.getConnection(url);
                }
                return DriverManager.getConnection(url, this.jcd.getUserName(), this.jcd.getPassWord());
            }
            catch (ClassNotFoundException e) {
                throw (IllegalStateException)new IllegalStateException(e.getMessage()).initCause(e);
            }
        }

        public Connection getConnection(String username, String password) throws SQLException {
            return this.getConnection();
        }

        public int getLoginTimeout() throws SQLException {
            return 0;
        }

        public PrintWriter getLogWriter() throws SQLException {
            return null;
        }

        public void setLoginTimeout(int seconds) throws SQLException {
        }

        public void setLogWriter(PrintWriter out) throws SQLException {
        }
    }
}

