/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.components.datasource;

import java.sql.Connection;
import java.sql.DriverManager;
import javax.sql.DataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.jetspeed.components.datasource.DatasourceComponent;

public class DBCPDatasourceComponent
implements DatasourceComponent {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$components$datasource$DBCPDatasourceComponent == null ? (class$org$apache$jetspeed$components$datasource$DBCPDatasourceComponent = DBCPDatasourceComponent.class$("org.apache.jetspeed.components.datasource.DBCPDatasourceComponent")) : class$org$apache$jetspeed$components$datasource$DBCPDatasourceComponent));
    protected PoolingDataSource dataSource;
    private String user;
    private String password;
    private String driverName;
    private String connectURI;
    private int maxActive;
    private int maxWait;
    private byte whenExhausted;
    private boolean autoCommit;
    private PoolableConnectionFactory dsConnectionFactory;
    static /* synthetic */ Class class$org$apache$jetspeed$components$datasource$DBCPDatasourceComponent;

    public DBCPDatasourceComponent(String user, String password, String driverName, String connectURI, int maxActive, int maxWait, byte whenExhausted, boolean autoCommit) {
        log.info((Object)("Setting up data source pooling for " + driverName));
        log.info((Object)("Max active connnections set to: " + maxActive));
        log.info((Object)("Pool is set to \"" + whenExhausted + "\" when all connections are exhausted."));
        this.user = user;
        this.password = password;
        this.driverName = driverName;
        this.connectURI = connectURI;
        this.maxActive = maxActive;
        this.maxWait = maxWait;
        this.autoCommit = autoCommit;
    }

    public DataSource getDatasource() {
        return this.dataSource;
    }

    public void start() {
        try {
            log.info((Object)"Attempting to start DBCPCDatasourceComponent.");
            Class.forName(this.driverName);
            try {
                Connection conn = DriverManager.getConnection(this.connectURI, this.user, this.password);
                conn.close();
            }
            catch (Exception e) {
                log.error((Object)("Unable to obtain a connection database via URI: " + this.connectURI), (Throwable)e);
                throw e;
            }
            GenericObjectPool connectionPool = new GenericObjectPool(null, this.maxActive, this.whenExhausted, (long)this.maxWait);
            DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(this.connectURI, this.user, this.password);
            this.dsConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, (ObjectPool)connectionPool, null, null, false, true);
            this.dataSource = new PoolingDataSource((ObjectPool)connectionPool);
            log.info((Object)"DBCPCDatasourceComponent successfuly started!");
        }
        catch (Throwable e) {
            String msg = "Unable to start DBCPCDatasourceComponent: " + e.toString();
            log.error((Object)msg, e);
            throw new IllegalStateException(msg);
        }
    }

    public void stop() {
        try {
            this.dsConnectionFactory.getPool().close();
        }
        catch (Exception e) {
            IllegalStateException ise = new IllegalStateException("Unable to sfaely shutdown the DBCPConnection pool: " + e.toString());
            ise.initCause(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

