/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.capabilities.impl;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.capabilities.Capabilities;
import org.apache.jetspeed.capabilities.Capability;
import org.apache.jetspeed.capabilities.CapabilityMap;
import org.apache.jetspeed.capabilities.Client;
import org.apache.jetspeed.capabilities.MediaType;
import org.apache.jetspeed.capabilities.MimeType;
import org.apache.jetspeed.capabilities.UnableToBuildCapabilityMapException;
import org.apache.jetspeed.capabilities.impl.CapabilityMapImpl;
import org.apache.jetspeed.components.dao.InitablePersistenceBrokerDaoSupport;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;

public class JetspeedCapabilities
extends InitablePersistenceBrokerDaoSupport
implements Capabilities {
    private String originalAlias;
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$capabilities$impl$JetspeedCapabilities == null ? (class$org$apache$jetspeed$capabilities$impl$JetspeedCapabilities = JetspeedCapabilities.class$("org.apache.jetspeed.capabilities.impl.JetspeedCapabilities")) : class$org$apache$jetspeed$capabilities$impl$JetspeedCapabilities));
    public static final String DEFAULT_AGENT = "Mozilla/4.0";
    public static final String AGENT_XML = "agentxml/1.0";
    Hashtable capabilityMapCache = new Hashtable();
    private Collection clients = null;
    private Class clientClass = class$org$apache$jetspeed$capabilities$impl$ClientImpl == null ? (class$org$apache$jetspeed$capabilities$impl$ClientImpl = JetspeedCapabilities.class$("org.apache.jetspeed.capabilities.impl.ClientImpl")) : class$org$apache$jetspeed$capabilities$impl$ClientImpl;
    private Class capabilityClass = class$org$apache$jetspeed$capabilities$impl$CapabilityImpl == null ? (class$org$apache$jetspeed$capabilities$impl$CapabilityImpl = JetspeedCapabilities.class$("org.apache.jetspeed.capabilities.impl.CapabilityImpl")) : class$org$apache$jetspeed$capabilities$impl$CapabilityImpl;
    private Class mimeTypeClass = class$org$apache$jetspeed$capabilities$impl$MimeTypeImpl == null ? (class$org$apache$jetspeed$capabilities$impl$MimeTypeImpl = JetspeedCapabilities.class$("org.apache.jetspeed.capabilities.impl.MimeTypeImpl")) : class$org$apache$jetspeed$capabilities$impl$MimeTypeImpl;
    private Class mediaTypeClass = class$org$apache$jetspeed$capabilities$impl$MediaTypeImpl == null ? (class$org$apache$jetspeed$capabilities$impl$MediaTypeImpl = JetspeedCapabilities.class$("org.apache.jetspeed.capabilities.impl.MediaTypeImpl")) : class$org$apache$jetspeed$capabilities$impl$MediaTypeImpl;
    static /* synthetic */ Class class$org$apache$jetspeed$capabilities$impl$JetspeedCapabilities;
    static /* synthetic */ Class class$org$apache$jetspeed$capabilities$impl$ClientImpl;
    static /* synthetic */ Class class$org$apache$jetspeed$capabilities$impl$CapabilityImpl;
    static /* synthetic */ Class class$org$apache$jetspeed$capabilities$impl$MimeTypeImpl;
    static /* synthetic */ Class class$org$apache$jetspeed$capabilities$impl$MediaTypeImpl;

    public JetspeedCapabilities(String repositoryPath) {
        super(repositoryPath);
    }

    public JetspeedCapabilities(String repositoryPath, Properties properties) {
        super(repositoryPath);
        this.initModelClasses(properties);
    }

    private void initModelClasses(Properties properties) {
        String modelName = "";
        try {
            modelName = properties.getProperty("client.impl");
            if (modelName != null) {
                this.clientClass = Class.forName(modelName);
            }
            if ((modelName = properties.getProperty("capability.impl")) != null) {
                this.capabilityClass = Class.forName(modelName);
            }
            if ((modelName = properties.getProperty("mimetype.impl")) != null) {
                this.mimeTypeClass = Class.forName(modelName);
            }
            if ((modelName = properties.getProperty("mediatype.impl")) != null) {
                this.mediaTypeClass = Class.forName(modelName);
            }
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Model class not found: " + modelName));
        }
    }

    public CapabilityMap getCapabilityMap(String userAgent) throws UnableToBuildCapabilityMapException {
        CapabilityMap map = null;
        boolean bClientFound = false;
        String defaultAgent = null;
        if (userAgent == null) {
            userAgent = DEFAULT_AGENT;
        }
        if ((map = (CapabilityMap)this.capabilityMapCache.get(userAgent)) != null) {
            return map;
        }
        while (!bClientFound) {
            Client entry = this.findClient(userAgent);
            if (entry == null) {
                if (userAgent.equals(DEFAULT_AGENT)) {
                    log.error((Object)"CapabilityMap: Default agent not found in Client Registry !");
                    bClientFound = true;
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CapabilityMap: useragent " + userAgent + "unknown, falling back to default"));
                }
                defaultAgent = userAgent;
                userAgent = DEFAULT_AGENT;
                continue;
            }
            map = new CapabilityMapImpl();
            map.setClient(entry);
            Iterator capabilities = entry.getCapabilities().iterator();
            while (capabilities.hasNext()) {
                map.addCapability((Capability)capabilities.next());
            }
            Collection mediatypes = this.getMediaTypesForMimeTypes(entry.getMimetypes().iterator());
            Iterator mimetypes = entry.getMimetypes().iterator();
            while (mimetypes.hasNext()) {
                map.addMimetype((MimeType)mimetypes.next());
            }
            Iterator media = mediatypes.iterator();
            while (media.hasNext()) {
                map.addMediaType((MediaType)media.next());
            }
            MediaType mtEntry = this.getMediaTypeForMimeType(map.getPreferredType().getName());
            map.setPreferredMediaType(mtEntry);
            this.capabilityMapCache.put(userAgent, map);
            if (defaultAgent != null) {
                this.capabilityMapCache.put(defaultAgent, map);
            }
            return map;
        }
        if (map != null) {
            return map;
        }
        throw new UnableToBuildCapabilityMapException("We were unable to build a capability map for the agent, " + userAgent + ".  This might be an indiciation that the capability database has not been correctly initialized.");
    }

    public Client findClient(String userAgent) {
        Client clientEntry = null;
        Iterator clients = this.getClients();
        if (log.isDebugEnabled()) {
            log.debug((Object)("ClientRegistry: Looking for client with useragent :" + userAgent));
        }
        while (clients.hasNext()) {
            Client client = (Client)clients.next();
            if (client.getUserAgentPattern() == null) continue;
            try {
                String exp = client.getUserAgentPattern();
                if (userAgent.matches(exp)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Client: " + userAgent + " matches " + client.getUserAgentPattern()));
                    }
                    return client;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Client: " + userAgent + " does not match " + client.getUserAgentPattern()));
            }
            catch (PatternSyntaxException e) {
                String message = "CapabilityServiceImpl: UserAgentPattern not valid : " + client.getUserAgentPattern() + " : " + e.getMessage();
                log.error((Object)message, (Throwable)e);
            }
        }
        return clientEntry;
    }

    public Iterator getClients() {
        if (null == this.clients) {
            QueryByCriteria query = QueryFactory.newQuery((Class)this.clientClass, (Criteria)new Criteria());
            query.addOrderByAscending("evalOrder");
            this.clients = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
        }
        return this.clients.iterator();
    }

    public Collection getMediaTypesForMimeTypes(Iterator mimetypes) {
        Criteria filter = new Criteria();
        Vector<String> temp = new Vector<String>();
        while (mimetypes.hasNext()) {
            MimeType mt = (MimeType)mimetypes.next();
            temp.add(mt.getName());
        }
        Collection co = null;
        if (temp.size() > 0) {
            filter.addIn("mimetypes.name", temp);
            QueryByCriteria query = QueryFactory.newQuery((Class)this.mediaTypeClass, (Criteria)filter);
            co = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
        }
        if (co == null || co.isEmpty()) {
            MediaType mt = this.getMediaType("html");
            Vector<MediaType> v = new Vector<MediaType>();
            v.add(mt);
            return v;
        }
        return co;
    }

    public void deleteCapabilityMapCache() {
        this.capabilityMapCache.clear();
        this.clients = null;
    }

    public MediaType getMediaType(String mediaType) {
        Criteria filter = new Criteria();
        filter.addEqualTo("name", (Object)mediaType);
        QueryByCriteria query = QueryFactory.newQuery((Class)this.mediaTypeClass, (Criteria)filter);
        return (MediaType)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
    }

    public MediaType getMediaTypeForMimeType(String mimeTypeName) {
        Criteria filter = new Criteria();
        filter.addEqualTo("mimetypes.name", (Object)mimeTypeName);
        QueryByCriteria query = QueryFactory.newQuery((Class)this.mediaTypeClass, (Criteria)filter);
        Collection mediaTypeCollection = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
        Iterator mtIterator = mediaTypeCollection.iterator();
        if (mtIterator.hasNext()) {
            return (MediaType)mtIterator.next();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

