/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.capabilities.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.capabilities.Capability;
import org.apache.jetspeed.capabilities.CapabilityMap;
import org.apache.jetspeed.capabilities.Client;
import org.apache.jetspeed.capabilities.MediaType;
import org.apache.jetspeed.capabilities.MimeType;

class CapabilityMapImpl
implements CapabilityMap {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$capabilities$impl$JetspeedCapabilities == null ? (class$org$apache$jetspeed$capabilities$impl$JetspeedCapabilities = CapabilityMapImpl.class$("org.apache.jetspeed.capabilities.impl.JetspeedCapabilities")) : class$org$apache$jetspeed$capabilities$impl$JetspeedCapabilities));
    private String useragent;
    private Map mimeTypeMap = new HashMap();
    private Map capabilityMap = new HashMap();
    private Map mediaTypeMap = new HashMap();
    private Client client;
    private MediaType preferredMediaType;
    static /* synthetic */ Class class$org$apache$jetspeed$capabilities$impl$JetspeedCapabilities;

    CapabilityMapImpl() {
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public Client getClient() {
        return this.client;
    }

    public void addCapability(Capability capability) {
        this.capabilityMap.put(capability.getName(), capability);
    }

    public void addMimetype(MimeType mimetype) {
        this.mimeTypeMap.put(mimetype.getName(), mimetype);
    }

    public void addMediaType(MediaType mediatype) {
        this.mediaTypeMap.put(mediatype.getName(), mediatype);
    }

    public MimeType getPreferredType() {
        int prefMimeTypeId = this.client.getPreferredMimeTypeId();
        MimeType mt = null;
        Iterator e = this.mimeTypeMap.values().iterator();
        while (e.hasNext()) {
            mt = (MimeType)e.next();
            if (mt.getMimetypeId() != prefMimeTypeId) continue;
            return mt;
        }
        log.error((Object)("Could not find preferred Mime Type for " + prefMimeTypeId));
        return null;
    }

    public void setPreferredMediaType(MediaType type) {
        this.preferredMediaType = type;
    }

    public MediaType getPreferredMediaType() {
        return this.preferredMediaType;
    }

    public Iterator listMediaTypes() {
        return this.mediaTypeMap.values().iterator();
    }

    public String getAgent() {
        return this.useragent;
    }

    public void setAgent(String userAgent) {
        this.useragent = userAgent;
    }

    public boolean hasCapability(int capability) {
        Iterator capabilities = this.capabilityMap.values().iterator();
        while (capabilities.hasNext()) {
            if (((Capability)capabilities.next()).getCapabilityId() != capability) continue;
            return true;
        }
        return false;
    }

    public boolean hasCapability(String capability) {
        Iterator capabilities = this.capabilityMap.values().iterator();
        while (capabilities.hasNext()) {
            if (((Capability)capabilities.next()).getName() != capability) continue;
            return true;
        }
        return false;
    }

    public Iterator getMimeTypes() {
        return this.mimeTypeMap.values().iterator();
    }

    public boolean supportsMimeType(MimeType mimeType) {
        Iterator mimetypes = this.mimeTypeMap.values().iterator();
        while (mimetypes.hasNext()) {
            if (((MimeType)mimetypes.next()).getName() != mimeType.getName()) continue;
            return true;
        }
        return false;
    }

    public boolean supportsMediaType(String media) {
        Iterator mediatypes = this.mediaTypeMap.values().iterator();
        while (mediatypes.hasNext()) {
            if (((MediaType)mediatypes.next()).getName() != media) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

