/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.bridges.velocity;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.Template;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.io.VelocityWriter;
import org.apache.velocity.tools.view.servlet.VelocityViewServlet;
import org.apache.velocity.util.SimplePool;

public class BridgesVelocityViewServlet
extends VelocityViewServlet {
    public static final String PORTLET_REQUEST = "javax.portlet.request";
    public static final String PORTLET_RESPONSE = "javax.portlet.response";
    public static final String PORTLET_CONFIG = "javax.portlet.config";
    public static final String VELOCITY_WRITER_ATTR = "org.apache.velocity.io.VelocityWriter";
    private static SimplePool writerPool = new SimplePool(40);
    public static final String VELOCITY_CONTEXT_ATTR = "org.apache.velocity.Context";

    protected Template handleRequest(HttpServletRequest request, HttpServletResponse response, Context ctx) throws Exception {
        PortletRequest renderRequest = (PortletRequest)request.getAttribute(PORTLET_REQUEST);
        RenderResponse renderResponse = (RenderResponse)request.getAttribute(PORTLET_RESPONSE);
        PortletConfig portletConfig = (PortletConfig)request.getAttribute(PORTLET_CONFIG);
        if (renderRequest != null) {
            renderRequest.setAttribute(VELOCITY_CONTEXT_ATTR, (Object)ctx);
            Context portletContext = (Context)renderRequest.getAttribute("portals.bridges.velocity.context");
            if (portletContext != null) {
                Object[] keys = portletContext.getKeys();
                for (int ix = 0; ix < keys.length; ++ix) {
                    ctx.put((String)keys[ix], portletContext.get((String)keys[ix]));
                }
            }
        }
        ctx.put(PORTLET_REQUEST, (Object)renderRequest);
        ctx.put(PORTLET_RESPONSE, (Object)renderResponse);
        return super.handleRequest(request, response, ctx);
    }

    protected void mergeTemplate(Template template, Context context, HttpServletResponse response) throws ResourceNotFoundException, ParseErrorException, MethodInvocationException, IOException, UnsupportedEncodingException, Exception {
        PrintWriter pw = response.getWriter();
        VelocityWriter vw = null;
        try {
            vw = (VelocityWriter)writerPool.get();
            if (vw == null) {
                vw = new VelocityWriter((Writer)pw, 4096, true);
            } else {
                vw.recycle((Writer)pw);
            }
            context.put(VELOCITY_WRITER_ATTR, (Object)vw);
            template.merge(context, (Writer)vw);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (vw != null) {
                    vw.flush();
                    vw.recycle(null);
                    writerPool.put((Object)vw);
                }
            }
            catch (Exception e) {}
        }
    }
}

