/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portalsite.view;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.jetspeed.portalsite.view.SiteView;

public abstract class SiteViewProxy {
    private SiteView view;
    private String locatorName;

    protected SiteViewProxy(SiteView view, String locatorName) {
        this.view = view;
        this.locatorName = locatorName;
    }

    public SiteView getView() {
        return this.view;
    }

    public String getLocatorName() {
        return this.locatorName;
    }

    protected static Method reflectMethod(Class methodClass, String methodName, Class[] methodArgs) {
        try {
            return methodClass.getMethod(methodName, methodArgs);
        }
        catch (NoSuchMethodException nsme) {
            RuntimeException rte = new RuntimeException("SiteViewProxy.reflectMethod(): unexpected reflection exception for: " + methodClass.getName() + "." + methodName);
            rte.initCause(nsme);
            throw rte;
        }
    }

    public static SiteViewProxy getSiteViewProxy(Object proxy) {
        InvocationHandler proxyHandler;
        if (proxy != null && Proxy.isProxyClass(proxy.getClass()) && (proxyHandler = Proxy.getInvocationHandler(proxy)) instanceof SiteViewProxy) {
            return (SiteViewProxy)((Object)proxyHandler);
        }
        return null;
    }
}

