/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portalsite.view;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.folder.FolderNotFoundException;
import org.apache.jetspeed.om.folder.proxy.FolderProxy;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.om.page.proxy.PageProxy;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.page.document.NodeException;
import org.apache.jetspeed.page.document.NodeNotFoundException;
import org.apache.jetspeed.page.document.NodeSet;
import org.apache.jetspeed.page.document.proxy.NodeProxy;
import org.apache.jetspeed.portalsite.menu.StandardBackMenuDefinition;
import org.apache.jetspeed.portalsite.menu.StandardBreadcrumbsMenuDefinition;
import org.apache.jetspeed.portalsite.menu.StandardNavigationsMenuDefinition;
import org.apache.jetspeed.portalsite.menu.StandardPagesMenuDefinition;
import org.apache.jetspeed.portalsite.view.SiteViewMenuDefinitionLocator;
import org.apache.jetspeed.portalsite.view.SiteViewProxy;
import org.apache.jetspeed.portalsite.view.SiteViewSearchPath;
import org.apache.jetspeed.profiler.ProfileLocator;
import org.apache.jetspeed.profiler.ProfileLocatorProperty;

public class SiteView {
    public static final String PROFILING_PROPERTY_FOLDER_PREFIX = "_";
    public static final String PROFILING_NAVIGATION_PROPERTY_FOLDER_PREFIX = "__";
    public static final String CURRENT_PAGE_PATH = "~";
    public static final String ALT_CURRENT_PAGE_PATH = "@";
    public static final String STANDARD_BACK_MENU_NAME = "back";
    public static final String STANDARD_BREADCRUMBS_MENU_NAME = "breadcrumbs";
    public static final String STANDARD_PAGES_MENU_NAME = "pages";
    public static final String STANDARD_NAVIGATIONS_MENU_NAME = "navigations";
    public static final String CUSTOM_PAGE_NAVIGATIONS_MENU_NAME = "page-navigations";
    private static final Set STANDARD_MENU_NAMES = new HashSet(3);
    private static final List STANDARD_MENU_DEFINITION_LOCATORS;
    private PageManager pageManager;
    private List searchPaths;
    private String searchPathsString;
    private Folder rootFolderProxy;

    public SiteView(PageManager pageManager, List searchPaths) {
        this.pageManager = pageManager;
        if (searchPaths != null && !searchPaths.isEmpty()) {
            this.searchPaths = new ArrayList(searchPaths.size());
            StringBuffer searchPathsStringBuffer = new StringBuffer();
            Iterator pathsIter = searchPaths.iterator();
            while (pathsIter.hasNext()) {
                SiteViewSearchPath searchPath;
                String path;
                Object pathObject = pathsIter.next();
                if (!(pathObject instanceof SiteViewSearchPath) && (path = pathObject.toString().trim()).length() > 0) {
                    pathObject = new SiteViewSearchPath("page", path);
                }
                if (this.searchPaths.indexOf(searchPath = (SiteViewSearchPath)pathObject) != -1) continue;
                try {
                    if (this.pageManager.getFolder(searchPath.toString()) == null) continue;
                    this.searchPaths.add(searchPath);
                    if (searchPathsStringBuffer.length() == 0) {
                        searchPathsStringBuffer.append(searchPath);
                        continue;
                    }
                    searchPathsStringBuffer.append(',');
                    searchPathsStringBuffer.append(searchPath);
                }
                catch (NodeException ne) {
                }
                catch (SecurityException se) {}
            }
            if (this.searchPaths.isEmpty()) {
                this.searchPaths.add(new SiteViewSearchPath("page", "/"));
                this.searchPathsString = "/";
            } else {
                this.searchPathsString = searchPathsStringBuffer.toString();
            }
        } else {
            this.searchPaths = new ArrayList(1);
            this.searchPaths.add(new SiteViewSearchPath("page", "/"));
            this.searchPathsString = "/";
        }
    }

    public SiteView(PageManager pageManager, String[] searchPaths) {
        this(pageManager, SiteView.makeSearchPathList(searchPaths));
    }

    private static List makeSearchPathList(String[] searchPaths) {
        if (searchPaths != null && searchPaths.length > 0) {
            ArrayList<String> searchPathsList = new ArrayList<String>(searchPaths.length);
            for (int i = 0; i < searchPaths.length; ++i) {
                searchPathsList.add(searchPaths[i]);
            }
            return searchPathsList;
        }
        return null;
    }

    public SiteView(PageManager pageManager, String searchPaths) {
        this(pageManager, SiteView.makeSearchPathList(searchPaths));
    }

    private static List makeSearchPathList(String searchPaths) {
        return searchPaths != null ? SiteView.makeSearchPathList(searchPaths.split(",")) : null;
    }

    public SiteView(PageManager pageManager, ProfileLocator locator) {
        this(pageManager, SiteView.makeSearchPathList(locator));
    }

    private static List makeSearchPathList(ProfileLocator locator) {
        if (locator != null) {
            return SiteView.mergeSearchPathList("page", locator, new ArrayList(8));
        }
        return null;
    }

    public SiteView(PageManager pageManager, Map locators) {
        this(pageManager, SiteView.makeSearchPathList(locators));
    }

    private static List makeSearchPathList(Map locators) {
        if (locators != null && !locators.isEmpty()) {
            ArrayList searchPaths = new ArrayList(8 * locators.size());
            ProfileLocator pageLocator = (ProfileLocator)locators.get("page");
            if (pageLocator != null) {
                SiteView.mergeSearchPathList("page", pageLocator, searchPaths);
            }
            if (pageLocator == null || locators.size() > 1) {
                Iterator locatorNameIter = locators.keySet().iterator();
                while (locatorNameIter.hasNext()) {
                    String locatorName = (String)locatorNameIter.next();
                    if (locatorName.equals("page")) continue;
                    SiteView.mergeSearchPathList(locatorName, (ProfileLocator)locators.get(locatorName), searchPaths);
                }
            }
            return searchPaths;
        }
        return null;
    }

    private static List mergeSearchPathList(String locatorName, ProfileLocator locator, List searchPaths) {
        ArrayList locatorSearchPaths = new ArrayList(8);
        int addLocatorSearchPathsAt = 0;
        Iterator locatorIter = locator.iterator();
        while (locatorIter.hasNext()) {
            String pathRoot = "/";
            ArrayList<StringBuffer> paths = new ArrayList<StringBuffer>(8);
            paths.add(new StringBuffer(pathRoot));
            int pathDepth = 0;
            int lastPathsCount = 0;
            String lastPropertyName = null;
            int lastPropertyValueLength = 0;
            boolean navigatedPathRoot = false;
            int skipProfileLocatorIterations = -1;
            ProfileLocatorProperty[] properties = (ProfileLocatorProperty[])locatorIter.next();
            for (int i = 0; i < properties.length; ++i) {
                if (properties[i].isNavigation()) {
                    if (properties[i].getValue() != null) {
                        pathRoot = properties[i].getValue();
                        if (!pathRoot.startsWith("/")) {
                            pathRoot = "/" + pathRoot;
                        }
                        if (!pathRoot.endsWith("/")) {
                            pathRoot = pathRoot + "/";
                        }
                        if (!pathRoot.equals("/")) {
                            int folderIndex = 1;
                            do {
                                if (pathRoot.regionMatches(folderIndex, PROFILING_NAVIGATION_PROPERTY_FOLDER_PREFIX, 0, PROFILING_NAVIGATION_PROPERTY_FOLDER_PREFIX.length())) continue;
                                pathRoot = pathRoot.substring(0, folderIndex) + PROFILING_NAVIGATION_PROPERTY_FOLDER_PREFIX + pathRoot.substring(folderIndex);
                            } while ((folderIndex = pathRoot.indexOf("/", folderIndex) + 1) != -1 && folderIndex != pathRoot.length());
                        }
                        pathDepth = 0;
                        paths.clear();
                        paths.add(new StringBuffer(pathRoot));
                        lastPathsCount = 0;
                        lastPropertyName = null;
                        lastPropertyValueLength = 0;
                        navigatedPathRoot = true;
                        skipProfileLocatorIterations = 0;
                        continue;
                    }
                    ++skipProfileLocatorIterations;
                    continue;
                }
                if (properties[i].isControl()) {
                    if (properties[i].getValue() != null) {
                        String propertyName = properties[i].getName().toLowerCase();
                        String propertyValue = properties[i].getValue().toLowerCase();
                        if (propertyName.equals(lastPropertyName)) {
                            ArrayList<StringBuffer> multipleValuePaths = new ArrayList<StringBuffer>(lastPathsCount);
                            Iterator pathsIter = paths.iterator();
                            for (int count = 0; pathsIter.hasNext() && count < lastPathsCount; ++count) {
                                StringBuffer path = (StringBuffer)pathsIter.next();
                                StringBuffer multipleValuePath = new StringBuffer(path.toString());
                                multipleValuePath.setLength(multipleValuePath.length() - lastPropertyValueLength - 1);
                                multipleValuePath.append(propertyValue);
                                multipleValuePath.append('/');
                                multipleValuePaths.add(multipleValuePath);
                            }
                            paths.addAll(multipleValuePaths);
                            ++skipProfileLocatorIterations;
                            continue;
                        }
                        Iterator pathsIter = paths.iterator();
                        while (pathsIter.hasNext()) {
                            StringBuffer path = (StringBuffer)pathsIter.next();
                            path.append(PROFILING_PROPERTY_FOLDER_PREFIX);
                            path.append(propertyName);
                            path.append('/');
                            path.append(propertyValue);
                            path.append('/');
                        }
                        ++pathDepth;
                        lastPathsCount = paths.size();
                        lastPropertyValueLength = propertyValue.length();
                        lastPropertyName = propertyName;
                        skipProfileLocatorIterations = 0;
                        continue;
                    }
                    ++skipProfileLocatorIterations;
                    continue;
                }
                ++skipProfileLocatorIterations;
            }
            for (int skip = skipProfileLocatorIterations; skip > 0 && locatorIter.hasNext(); --skip) {
                locatorIter.next();
            }
            if (pathDepth > 0 || navigatedPathRoot) {
                locatorSearchPaths.addAll(addLocatorSearchPathsAt, paths);
                addLocatorSearchPathsAt += paths.size();
            }
            if (pathDepth == 1 && !navigatedPathRoot) {
                locatorSearchPaths.add(addLocatorSearchPathsAt++, new StringBuffer(pathRoot));
            }
            if (pathDepth == 0 && navigatedPathRoot) {
                addLocatorSearchPathsAt = 0;
            }
            if ((pathDepth > 1 || navigatedPathRoot) && locatorIter.hasNext()) continue;
            Iterator locatorSearchPathsIter = locatorSearchPaths.iterator();
            while (locatorSearchPathsIter.hasNext()) {
                SiteViewSearchPath searchPath = new SiteViewSearchPath(locatorName, locatorSearchPathsIter.next().toString());
                int existsAt = searchPaths.indexOf(searchPath);
                if (existsAt != -1) {
                    if (existsAt >= searchPaths.size() - 1) continue;
                    searchPaths.add(searchPaths.remove(existsAt));
                    continue;
                }
                searchPaths.add(searchPath);
            }
            locatorSearchPaths.clear();
            addLocatorSearchPathsAt = 0;
        }
        return searchPaths;
    }

    public SiteView(PageManager pageManager) {
        this(pageManager, (List)null);
    }

    public PageManager getPageManager() {
        return this.pageManager;
    }

    public List getSearchPaths() {
        return this.searchPaths;
    }

    public String getSearchPathsString() {
        return this.searchPathsString;
    }

    public Folder getRootFolderProxy() throws FolderNotFoundException {
        if (this.rootFolderProxy == null) {
            try {
                SiteViewSearchPath searchPath = (SiteViewSearchPath)this.searchPaths.get(0);
                String path = searchPath.toString();
                String locatorName = searchPath.getLocatorName();
                Folder rootFolder = this.pageManager.getFolder(path);
                this.rootFolderProxy = FolderProxy.newInstance(this, locatorName, null, rootFolder);
            }
            catch (NodeException ne) {
                FolderNotFoundException fnfe = new FolderNotFoundException("Root folder not found");
                fnfe.initCause((Throwable)ne);
                throw fnfe;
            }
        }
        return this.rootFolderProxy;
    }

    public Node getNodeProxy(String path, Node currentNode, boolean onlyViewable, boolean onlyVisible) throws NodeNotFoundException {
        String currentPath = path;
        Folder currentFolder = null;
        Page currentPage = null;
        if (currentNode instanceof Page) {
            currentPage = (Page)currentNode;
            currentFolder = (Folder)currentPage.getParent();
        } else if (currentNode instanceof Folder) {
            currentFolder = (Folder)currentNode;
        }
        if (currentPath.equals(CURRENT_PAGE_PATH) || currentPath.equals(ALT_CURRENT_PAGE_PATH)) {
            return currentPage;
        }
        if (currentPath.startsWith("/")) {
            currentPath = currentPath.substring(1);
            currentFolder = null;
        }
        if (currentFolder == null) {
            currentFolder = this.getRootFolderProxy();
        }
        while (currentPath.length() > 0 && !currentPath.equals("/")) {
            int separatorIndex = currentPath.indexOf("/");
            if (separatorIndex != -1) {
                String subfolder = currentPath.substring(0, separatorIndex);
                currentPath = currentPath.substring(separatorIndex + 1);
                if (subfolder.equals("..")) {
                    if (currentFolder.getParent() != null) {
                        currentFolder = (Folder)currentFolder.getParent();
                        continue;
                    }
                    throw new NodeNotFoundException("Specified path " + path + " not found.");
                }
                if (subfolder.equals(".")) continue;
                try {
                    currentFolder = currentFolder.getFolder(subfolder);
                    continue;
                }
                catch (NodeException ne) {
                    NodeNotFoundException nnfe = new NodeNotFoundException("Specified path " + path + " not found.");
                    nnfe.initCause((Throwable)ne);
                    throw nnfe;
                }
            }
            try {
                Node node;
                NodeSet children = currentFolder.getAll();
                if (!(children == null || (node = children.get(currentPath)) == null || onlyViewable && !SiteView.isProxyViewable(node) || onlyVisible && node.isHidden() && node != currentPage)) {
                    return node;
                }
            }
            catch (NodeException ne) {
                NodeNotFoundException nnfe = new NodeNotFoundException("Specified path " + path + " not found.");
                nnfe.initCause((Throwable)ne);
                throw nnfe;
            }
            throw new NodeNotFoundException("Specified path " + path + " not found or viewable/visible.");
        }
        if (!(onlyViewable && !SiteView.isProxyViewable((Node)currentFolder) || onlyVisible && currentFolder.isHidden())) {
            return currentFolder;
        }
        throw new NodeNotFoundException("Specified path " + path + " not found or viewable/visible.");
    }

    public List getNodeProxies(String regexpPath, Node currentNode, boolean onlyViewable, boolean onlyVisible) {
        String currentRegexpPath = regexpPath;
        Folder currentFolder = null;
        Page currentPage = null;
        if (currentNode instanceof Page) {
            currentPage = (Page)currentNode;
            currentFolder = (Folder)currentPage.getParent();
        } else if (currentNode instanceof Folder) {
            currentFolder = (Folder)currentNode;
        }
        if (currentRegexpPath.equals(CURRENT_PAGE_PATH) || currentRegexpPath.equals(ALT_CURRENT_PAGE_PATH)) {
            if (currentPage != null) {
                ArrayList<Page> proxies = new ArrayList<Page>(1);
                proxies.add(currentPage);
                return proxies;
            }
            return null;
        }
        if (currentRegexpPath.startsWith("/")) {
            currentRegexpPath = currentRegexpPath.substring(1);
            currentFolder = null;
        }
        if (currentFolder == null) {
            try {
                currentFolder = this.getRootFolderProxy();
            }
            catch (NodeException ne) {
                return null;
            }
            catch (SecurityException se) {
                return null;
            }
        }
        while (currentRegexpPath.length() > 0 && !currentRegexpPath.equals("/")) {
            int separatorIndex = currentRegexpPath.indexOf("/");
            if (separatorIndex != -1) {
                String subfolder = currentRegexpPath.substring(0, separatorIndex);
                currentRegexpPath = currentRegexpPath.substring(separatorIndex + 1);
                if (subfolder.equals("..")) {
                    if (currentFolder.getParent() != null) {
                        currentFolder = (Folder)currentFolder.getParent();
                        continue;
                    }
                    return null;
                }
                if (subfolder.equals(".")) continue;
                try {
                    String subfolderPattern = SiteView.pathRegexpPattern(subfolder);
                    if (subfolderPattern != null) {
                        NodeSet subfolders = currentFolder.getFolders();
                        if (subfolders != null) {
                            if ((subfolders = subfolders.inclusiveSubset(subfolderPattern)) != null) {
                                if (subfolders.size() > 1) {
                                    ArrayList proxies = null;
                                    Iterator subfoldersIter = subfolders.iterator();
                                    while (subfoldersIter.hasNext()) {
                                        currentFolder = (Folder)subfoldersIter.next();
                                        List subfolderProxies = this.getNodeProxies(currentRegexpPath, (Node)currentFolder, onlyViewable, onlyVisible);
                                        if (subfolderProxies == null || subfolderProxies.isEmpty()) continue;
                                        if (proxies == null) {
                                            proxies = new ArrayList();
                                        }
                                        proxies.addAll(subfolderProxies);
                                    }
                                    return proxies;
                                }
                                if (subfolders.size() == 1) {
                                    currentFolder = (Folder)subfolders.iterator().next();
                                    continue;
                                }
                                return null;
                            }
                            return null;
                        }
                        return null;
                    }
                    currentFolder = currentFolder.getFolder(subfolder);
                    continue;
                }
                catch (NodeException ne) {
                    return null;
                }
                catch (SecurityException se) {
                    return null;
                }
            }
            try {
                NodeSet children = currentFolder.getAll();
                if (children != null) {
                    String pathPattern = SiteView.pathRegexpPattern(currentRegexpPath);
                    if (pathPattern != null) {
                        if ((children = children.inclusiveSubset(pathPattern)) != null && !children.isEmpty()) {
                            ArrayList<Node> proxies = null;
                            Iterator childrenIter = children.iterator();
                            while (childrenIter.hasNext()) {
                                Node child = (Node)childrenIter.next();
                                if (onlyViewable && !SiteView.isProxyViewable(child) || onlyVisible && child.isHidden() && child != currentPage) continue;
                                if (proxies == null) {
                                    proxies = new ArrayList<Node>(children.size());
                                }
                                proxies.add(child);
                            }
                            return proxies;
                        }
                    } else {
                        Node child = children.get(currentRegexpPath);
                        if (!(child == null || onlyViewable && !SiteView.isProxyViewable(child) || onlyVisible && child.isHidden() && child != currentPage)) {
                            ArrayList<Folder> proxies = new ArrayList<Folder>(1);
                            proxies.add(currentFolder);
                            return proxies;
                        }
                    }
                }
            }
            catch (NodeException ne) {
            }
            catch (SecurityException se) {
                // empty catch block
            }
            return null;
        }
        if (!(onlyViewable && !SiteView.isProxyViewable((Node)currentFolder) || onlyVisible && currentFolder.isHidden())) {
            ArrayList<Folder> proxies = new ArrayList<Folder>(1);
            proxies.add(currentFolder);
            return proxies;
        }
        return null;
    }

    private static String pathRegexpPattern(String regexp) {
        StringBuffer pattern = null;
        int limit = regexp.length();
        block9: for (int i = 0; i < limit; ++i) {
            char regexpChar = regexp.charAt(i);
            switch (regexpChar) {
                case '*': 
                case '.': 
                case '?': 
                case '[': {
                    if (pattern == null) {
                        pattern = new StringBuffer(regexp.length() * 2);
                        pattern.append(regexp.substring(0, i));
                    }
                    switch (regexpChar) {
                        case '*': {
                            pattern.append(".*");
                            break;
                        }
                        case '.': {
                            pattern.append("\\.");
                            break;
                        }
                        case '?': {
                            pattern.append('.');
                            break;
                        }
                        case '[': {
                            pattern.append('[');
                        }
                    }
                    continue block9;
                }
                default: {
                    if (pattern == null) continue block9;
                    pattern.append(regexpChar);
                }
            }
        }
        if (pattern != null) {
            return pattern.toString();
        }
        return null;
    }

    private static boolean isProxyViewable(Node nodeProxy) {
        if (nodeProxy instanceof Folder) {
            try {
                NodeSet children = ((Folder)nodeProxy).getAll();
                if (children != null) {
                    Iterator childrenIter = children.iterator();
                    while (childrenIter.hasNext()) {
                        if (!SiteView.isProxyViewable((Node)childrenIter.next())) continue;
                        return true;
                    }
                }
            }
            catch (NodeException ne) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    public Set getStandardMenuNames() {
        return STANDARD_MENU_NAMES;
    }

    public List getStandardMenuDefinitionLocators() {
        return STANDARD_MENU_DEFINITION_LOCATORS;
    }

    public List getMenuDefinitionLocators(Node node) {
        NodeProxy nodeProxy = NodeProxy.getNodeProxy(node);
        if (nodeProxy != null) {
            return nodeProxy.getMenuDefinitionLocators();
        }
        return null;
    }

    public SiteViewMenuDefinitionLocator getMenuDefinitionLocator(Node node, String name) {
        NodeProxy nodeProxy = NodeProxy.getNodeProxy(node);
        if (nodeProxy != null) {
            return nodeProxy.getMenuDefinitionLocator(name);
        }
        return null;
    }

    public String getProfileLocatorName(Node node) {
        SiteViewProxy siteViewProxy = SiteViewProxy.getSiteViewProxy(node);
        if (siteViewProxy != null) {
            return siteViewProxy.getLocatorName();
        }
        return null;
    }

    public Page getManagedPage(Page page) {
        PageProxy pageProxy = (PageProxy)NodeProxy.getNodeProxy(page);
        if (pageProxy != null) {
            return pageProxy.getPage();
        }
        return null;
    }

    static {
        STANDARD_MENU_NAMES.add(STANDARD_BACK_MENU_NAME);
        STANDARD_MENU_NAMES.add(STANDARD_BREADCRUMBS_MENU_NAME);
        STANDARD_MENU_NAMES.add(STANDARD_PAGES_MENU_NAME);
        STANDARD_MENU_NAMES.add(STANDARD_NAVIGATIONS_MENU_NAME);
        STANDARD_MENU_DEFINITION_LOCATORS = new ArrayList(4);
        STANDARD_MENU_DEFINITION_LOCATORS.add(new SiteViewMenuDefinitionLocator(new StandardBackMenuDefinition()));
        STANDARD_MENU_DEFINITION_LOCATORS.add(new SiteViewMenuDefinitionLocator(new StandardBreadcrumbsMenuDefinition()));
        STANDARD_MENU_DEFINITION_LOCATORS.add(new SiteViewMenuDefinitionLocator(new StandardPagesMenuDefinition()));
        STANDARD_MENU_DEFINITION_LOCATORS.add(new SiteViewMenuDefinitionLocator(new StandardNavigationsMenuDefinition()));
    }
}

