/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portalsite.impl;

import java.security.AccessController;
import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.PageManagerEventListener;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.page.document.NodeException;
import org.apache.jetspeed.page.document.NodeNotFoundException;
import org.apache.jetspeed.page.document.NodeSet;
import org.apache.jetspeed.portalsite.PortalSiteRequestContext;
import org.apache.jetspeed.portalsite.PortalSiteSessionContext;
import org.apache.jetspeed.portalsite.impl.PortalSiteRequestContextImpl;
import org.apache.jetspeed.portalsite.view.SiteView;
import org.apache.jetspeed.portalsite.view.SiteViewMenuDefinitionLocator;
import org.apache.jetspeed.profiler.ProfileLocator;
import org.apache.jetspeed.profiler.ProfileLocatorProperty;
import org.apache.jetspeed.security.UserPrincipal;

public class PortalSiteSessionContextImpl
implements PortalSiteSessionContext,
PageManagerEventListener,
HttpSessionActivationListener,
HttpSessionBindingListener {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$portalsite$impl$PortalSiteSessionContextImpl == null ? (class$org$apache$jetspeed$portalsite$impl$PortalSiteSessionContextImpl = PortalSiteSessionContextImpl.class$("org.apache.jetspeed.portalsite.impl.PortalSiteSessionContextImpl")) : class$org$apache$jetspeed$portalsite$impl$PortalSiteSessionContextImpl));
    private PageManager pageManager;
    private Map profileLocators;
    private String userPrincipal;
    private SiteView siteView;
    private Map folderPageHistory;
    private Map menuDefinitionLocatorCache;
    private boolean subscribed;
    private boolean stale;
    static /* synthetic */ Class class$org$apache$jetspeed$portalsite$impl$PortalSiteSessionContextImpl;

    public PortalSiteSessionContextImpl(PageManager pageManager) {
        this.pageManager = pageManager;
        this.folderPageHistory = new HashMap();
    }

    public PortalSiteRequestContext newRequestContext(Map requestProfileLocators) {
        return new PortalSiteRequestContextImpl(this, requestProfileLocators);
    }

    public Page selectRequestPage(Map requestProfileLocators) throws NodeNotFoundException {
        if (this.updateSessionProfileLocators(requestProfileLocators)) {
            block7: {
                String requestPath = "/";
                ProfileLocator locator = (ProfileLocator)requestProfileLocators.get("page");
                if (locator != null) {
                    requestPath = this.getRequestPathFromLocator(locator);
                } else {
                    locator = (ProfileLocator)requestProfileLocators.values().iterator().next();
                    requestPath = locator.getRequestPath();
                }
                Object requestPage = null;
                try {
                    return this.selectRequestPage(requestPath);
                }
                catch (NodeNotFoundException nnfe) {
                    if (requestPath.equals("/")) {
                        throw nnfe;
                    }
                }
                catch (SecurityException se) {
                    if (!requestPath.equals("/")) break block7;
                    throw se;
                }
            }
            return this.selectRequestPage("/");
        }
        throw new NodeNotFoundException("No request page available in site view.");
    }

    private String getRequestPathFromLocator(ProfileLocator locator) {
        String requestPath = locator.getRequestPath();
        Iterator locatorIter = locator.iterator();
        if (locatorIter.hasNext()) {
            ProfileLocatorProperty[] properties = (ProfileLocatorProperty[])locatorIter.next();
            for (int i = 0; i < properties.length; ++i) {
                if (properties[i].isControl() || properties[i].isNavigation()) continue;
                String path = properties[i].getValue();
                if (path != null) {
                    if (!path.startsWith("/")) {
                        String basePath = requestPath;
                        if (basePath == null) {
                            basePath = "/";
                        } else if (basePath.endsWith(".psml")) {
                            basePath = basePath.substring(0, basePath.lastIndexOf("/") + 1);
                        } else if (!basePath.endsWith("/")) {
                            basePath = basePath + "/";
                        }
                        path = basePath + path;
                        if (!path.endsWith("/") && !path.endsWith(".psml")) {
                            path = path + ".psml";
                        }
                    }
                    if (!path.equals(requestPath)) {
                        if (path.endsWith("/default-page.psml")) {
                            path = path.substring(0, path.length() - "default-page.psml".length());
                        }
                        if (log.isDebugEnabled() && !path.equals(requestPath)) {
                            log.debug((Object)("Request page modified by profile locator: request path=" + path));
                        }
                    }
                    return path;
                }
                return requestPath;
            }
        }
        return requestPath;
    }

    private Page selectRequestPage(String requestPath) throws NodeNotFoundException {
        SecurityException accessException = null;
        SiteView view = this.getSiteView();
        if (view != null) {
            if (requestPath == null) {
                requestPath = "/";
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Request page: request path=" + requestPath));
            }
            Node requestNode = null;
            try {
                requestNode = view.getNodeProxy(requestPath, null, true, false);
            }
            catch (NodeNotFoundException nnfe) {
                if (requestPath.endsWith("/default-page.psml")) {
                    requestPath = requestPath.substring(0, requestPath.length() - "default-page.psml".length());
                    requestNode = view.getNodeProxy(requestPath, null, true, false);
                }
                throw nnfe;
            }
            if (requestNode instanceof Folder) {
                Folder requestFolder = (Folder)requestNode;
                NodeSet requestFolderPages = null;
                try {
                    requestFolderPages = requestFolder.getPages();
                    while ((requestFolderPages == null || requestFolderPages.isEmpty()) && requestFolder.getParent() != null) {
                        requestFolder = (Folder)requestFolder.getParent();
                        requestFolderPages = requestFolder.getPages();
                    }
                }
                catch (NodeException ne) {
                    requestFolderPages = null;
                }
                catch (SecurityException se) {
                    requestFolderPages = null;
                    accessException = se;
                }
                if (requestFolderPages != null && !requestFolderPages.isEmpty()) {
                    String defaultPageName;
                    Page requestPage = (Page)this.folderPageHistory.get(requestFolder);
                    if (requestPage != null && requestFolderPages.contains((Node)requestPage)) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Selected folder historical page: path=" + view.getManagedPage(requestPage).getPath()));
                        }
                        return requestPage;
                    }
                    if (requestFolderPages.size() > 1 && (defaultPageName = requestFolder.getDefaultPage(false)) != null) {
                        try {
                            requestPage = requestFolder.getPage(defaultPageName);
                            if (!requestPage.isHidden()) {
                                this.folderPageHistory.put(requestFolder, requestPage);
                            }
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Selected folder default page: path=" + view.getManagedPage(requestPage).getPath()));
                            }
                            return requestPage;
                        }
                        catch (NodeException ne) {
                        }
                        catch (SecurityException se) {
                            accessException = se;
                        }
                    }
                    if (!(requestPage = (Page)requestFolderPages.iterator().next()).isHidden()) {
                        this.folderPageHistory.put(requestFolder, requestPage);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Selected first folder page, path=" + view.getManagedPage(requestPage).getPath()));
                    }
                    return requestPage;
                }
            } else if (requestNode instanceof Page) {
                Page requestPage = (Page)requestNode;
                Folder requestFolder = (Folder)requestPage.getParent();
                if (!requestPage.isHidden()) {
                    this.folderPageHistory.put(requestFolder, requestPage);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Selected page, path=" + view.getManagedPage(requestPage).getPath()));
                }
                return requestPage;
            }
        }
        if (accessException != null) {
            throw accessException;
        }
        throw new NodeNotFoundException("No page matched " + requestPath + " request in site view.");
    }

    public Folder getRequestRootFolder(Map requestProfileLocators) throws NodeNotFoundException {
        SiteView view;
        if (this.updateSessionProfileLocators(requestProfileLocators) && (view = this.getSiteView()) != null) {
            return view.getRootFolderProxy();
        }
        throw new NodeNotFoundException("No root folder available in site view.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateSessionProfileLocators(Map requestProfileLocators) {
        if (requestProfileLocators != null && !requestProfileLocators.isEmpty()) {
            Object principal;
            String currentUserPrincipal = null;
            Subject subject = Subject.getSubject(AccessController.getContext());
            if (subject != null) {
                Iterator<Principal> principals = subject.getPrincipals().iterator();
                while (principals.hasNext()) {
                    principal = principals.next();
                    if (!(principal instanceof UserPrincipal)) continue;
                    if (currentUserPrincipal == null) {
                        currentUserPrincipal = principal.getName();
                        continue;
                    }
                    currentUserPrincipal = currentUserPrincipal + "|" + principal.getName();
                }
            }
            boolean updated = false;
            principal = this;
            synchronized (principal) {
                if (this.stale || this.userPrincipal == null && currentUserPrincipal != null || this.userPrincipal != null && !this.userPrincipal.equals(currentUserPrincipal) || this.profileLocators == null || !PortalSiteSessionContextImpl.locatorsEquals(this.profileLocators, requestProfileLocators)) {
                    this.clearSessionProfileLocators();
                    this.profileLocators = requestProfileLocators;
                    this.userPrincipal = currentUserPrincipal;
                    updated = true;
                }
            }
            if (updated && log.isDebugEnabled()) {
                StringBuffer debug = new StringBuffer();
                debug.append("Updated context: user=" + this.userPrincipal + ", profileLocators=(");
                if (this.profileLocators != null) {
                    boolean firstEntry = true;
                    Iterator entriesIter = this.profileLocators.entrySet().iterator();
                    while (entriesIter.hasNext()) {
                        Map.Entry entry = entriesIter.next();
                        String locatorName = (String)entry.getKey();
                        ProfileLocator locator = (ProfileLocator)entry.getValue();
                        if (!firstEntry) {
                            debug.append(",");
                        } else {
                            firstEntry = false;
                        }
                        debug.append(locatorName);
                        debug.append("=");
                        debug.append(locator.toString());
                    }
                } else {
                    debug.append("null");
                }
                debug.append(")");
                log.debug((Object)debug);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSessionProfileLocators() {
        PortalSiteSessionContextImpl portalSiteSessionContextImpl = this;
        synchronized (portalSiteSessionContextImpl) {
            this.profileLocators = null;
            this.userPrincipal = null;
            this.siteView = null;
            this.folderPageHistory.clear();
            if (this.menuDefinitionLocatorCache != null) {
                this.menuDefinitionLocatorCache.clear();
            }
            this.stale = false;
        }
    }

    public SiteView getSiteView() {
        if (this.siteView == null && this.pageManager != null && this.profileLocators != null) {
            this.siteView = new SiteView(this.pageManager, this.profileLocators);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Created site view: search paths=" + this.siteView.getSearchPathsString()));
            }
        }
        return this.siteView;
    }

    public PageManager getPageManager() {
        return this.pageManager;
    }

    public Map getProfileLocators() {
        return this.profileLocators;
    }

    public Set getStandardMenuNames() {
        SiteView view = this.getSiteView();
        if (view != null) {
            return view.getStandardMenuNames();
        }
        return null;
    }

    public List getMenuDefinitionLocators(Node node) {
        SiteView view = this.getSiteView();
        if (view != null) {
            return view.getMenuDefinitionLocators(node);
        }
        return null;
    }

    public SiteViewMenuDefinitionLocator getMenuDefinitionLocator(Node node, String name) {
        SiteView view = this.getSiteView();
        if (view != null) {
            return view.getMenuDefinitionLocator(node, name);
        }
        return null;
    }

    public Page getManagedPage(Page page) {
        SiteView view = this.getSiteView();
        if (view != null) {
            return view.getManagedPage(page);
        }
        return null;
    }

    public Map getMenuDefinitionLocatorCache() {
        return this.menuDefinitionLocatorCache;
    }

    public void setMenuDefinitionLocatorCache(Map cache) {
        this.menuDefinitionLocatorCache = cache;
    }

    private static boolean locatorsEquals(Map locators0, Map locators1) {
        if (locators0 == locators1) {
            return true;
        }
        if (locators0.size() != locators1.size()) {
            return false;
        }
        Iterator entriesIter = locators0.entrySet().iterator();
        if (entriesIter.hasNext()) {
            Map.Entry entry = entriesIter.next();
            ProfileLocator locator0 = (ProfileLocator)entry.getValue();
            ProfileLocator locator1 = (ProfileLocator)locators1.get(entry.getKey());
            if (locator1 == null) {
                return false;
            }
            ProfileLocatorProperty[] properties0 = (ProfileLocatorProperty[])locator0.iterator().next();
            ProfileLocatorProperty[] properties1 = (ProfileLocatorProperty[])locator1.iterator().next();
            if (properties0 != null || properties1 != null) {
                if (properties0 == null || properties1 == null || properties0.length != properties1.length) {
                    return false;
                }
                int limit = properties0.length;
                for (int i = 0; i < limit; ++i) {
                    if (!(!properties0[i].getName().equals(properties1[i].getName()) || properties0[i].isControl() && !properties1[i].isControl() || properties0[i].isNavigation() && !properties1[i].isNavigation() || properties0[i].getValue() == null && properties1[i].getValue() != null) && (properties0[i].getValue() == null || properties0[i].getValue().equals(properties1[i].getValue()))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static String locatorRequestPath(ProfileLocator locator) {
        return PortalSiteSessionContextImpl.locatorRequestPath(locator, locator.getRequestPath());
    }

    private static String locatorRequestPath(ProfileLocator locator, String requestPath) {
        ProfileLocatorProperty[] properties = (ProfileLocatorProperty[])locator.iterator().next();
        int limit = properties.length;
        for (int i = 0; i < limit; ++i) {
            if (properties[i].isControl() || properties[i].isNavigation() || properties[i].getValue() == null) continue;
            String locatorPath = properties[i].getValue();
            if (locatorPath.startsWith("/")) {
                return locatorPath;
            }
            if (locatorPath.indexOf("/") == -1 && !locatorPath.endsWith(".psml")) {
                locatorPath = locatorPath + ".psml";
            }
            boolean rootFolderRequest = requestPath.equals("/");
            boolean folderRequest = !requestPath.endsWith(".psml");
            int lastSeparatorIndex = requestPath.lastIndexOf(47);
            if (lastSeparatorIndex > 0 && (!folderRequest || requestPath.endsWith("/"))) {
                return requestPath.substring(0, lastSeparatorIndex) + "/" + locatorPath;
            }
            if (!rootFolderRequest && folderRequest) {
                return requestPath + "/" + locatorPath;
            }
            return "/" + locatorPath;
        }
        return requestPath;
    }

    public void newNode(Node node) {
        this.updatedNode(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatedNode(Node node) {
        PortalSiteSessionContextImpl portalSiteSessionContextImpl = this;
        synchronized (portalSiteSessionContextImpl) {
            this.stale = true;
        }
        if (log.isDebugEnabled()) {
            if (node != null) {
                log.debug((Object)("Page manager update event, (node=" + node.getPath() + "): set session context state stale"));
            } else {
                log.debug((Object)"Page manager update event: set session context state stale");
            }
        }
    }

    public void removedNode(Node node) {
        this.updatedNode(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionDidActivate(HttpSessionEvent event) {
        PortalSiteSessionContextImpl portalSiteSessionContextImpl = this;
        synchronized (portalSiteSessionContextImpl) {
            this.stale = true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Session activation event: set session context state stale");
        }
    }

    public void sessionWillPassivate(HttpSessionEvent event) {
        this.clearSessionProfileLocators();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Session deactivation event: clear session context state");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valueBound(HttpSessionBindingEvent event) {
        PortalSiteSessionContextImpl portalSiteSessionContextImpl = this;
        synchronized (portalSiteSessionContextImpl) {
            if (!this.subscribed) {
                this.pageManager.addListener((PageManagerEventListener)this);
                this.subscribed = true;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Session bound event: setup page manager listener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valueUnbound(HttpSessionBindingEvent event) {
        PortalSiteSessionContextImpl portalSiteSessionContextImpl = this;
        synchronized (portalSiteSessionContextImpl) {
            if (this.subscribed) {
                this.pageManager.removeListener((PageManagerEventListener)this);
                this.subscribed = false;
            }
        }
        this.clearSessionProfileLocators();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Session unbound event: clear page manager listener and session context state");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

