/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portalsite.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.page.document.NodeException;
import org.apache.jetspeed.page.document.NodeNotFoundException;
import org.apache.jetspeed.page.document.NodeSet;
import org.apache.jetspeed.page.document.proxy.NodeSetImpl;
import org.apache.jetspeed.portalsite.Menu;
import org.apache.jetspeed.portalsite.PortalSiteRequestContext;
import org.apache.jetspeed.portalsite.PortalSiteSessionContext;
import org.apache.jetspeed.portalsite.impl.MenuImpl;
import org.apache.jetspeed.portalsite.impl.PortalSiteSessionContextImpl;
import org.apache.jetspeed.portalsite.view.SiteViewMenuDefinitionLocator;

public class PortalSiteRequestContextImpl
implements PortalSiteRequestContext {
    private PortalSiteSessionContextImpl sessionContext;
    private Map requestProfileLocators;
    private Page requestPage;
    private NodeSet siblingPages;
    private boolean siblingPagesCached;
    private NodeSet siblingFolders;
    private boolean siblingFoldersCached;
    private Folder requestRootFolder;
    private NodeSet rootLinks;
    private boolean rootLinksCached;
    private Set pageMenuDefinitionNames;
    private Map menuDefinitionLocatorCache;

    public PortalSiteRequestContextImpl(PortalSiteSessionContextImpl sessionContext, Map requestProfileLocators) {
        this.sessionContext = sessionContext;
        this.requestProfileLocators = requestProfileLocators;
    }

    public PortalSiteSessionContext getSessionContext() {
        return this.sessionContext;
    }

    public Map getLocators() {
        return this.requestProfileLocators;
    }

    public Page getManagedPage() throws NodeNotFoundException {
        return this.sessionContext.getManagedPage(this.getPage());
    }

    public Page getPage() throws NodeNotFoundException {
        if (this.requestPage == null) {
            this.requestPage = this.sessionContext.selectRequestPage(this.requestProfileLocators);
        }
        return this.requestPage;
    }

    public Folder getFolder() throws NodeNotFoundException {
        Page page = this.getPage();
        if (page != null) {
            return (Folder)page.getParent();
        }
        return null;
    }

    public NodeSet getSiblingPages() throws NodeNotFoundException {
        Folder folder;
        if (!this.siblingPagesCached && (folder = this.getFolder()) != null) {
            try {
                this.siblingPages = PortalSiteRequestContextImpl.filterHiddenNodes(folder.getPages());
                this.siblingPagesCached = true;
            }
            catch (NodeException ne) {
                NodeNotFoundException nnfe = new NodeNotFoundException("Sibling pages not found.");
                nnfe.initCause((Throwable)ne);
                throw nnfe;
            }
        }
        return this.siblingPages;
    }

    public Folder getParentFolder() throws NodeNotFoundException {
        Folder parent;
        Folder folder = this.getFolder();
        if (folder != null && (parent = (Folder)folder.getParent()) != null && !parent.isHidden()) {
            return parent;
        }
        return null;
    }

    public NodeSet getSiblingFolders() throws NodeNotFoundException {
        Folder folder;
        if (!this.siblingFoldersCached && (folder = this.getFolder()) != null) {
            try {
                this.siblingFolders = PortalSiteRequestContextImpl.filterHiddenNodes(folder.getFolders());
                this.siblingFoldersCached = true;
            }
            catch (NodeException ne) {
                NodeNotFoundException nnfe = new NodeNotFoundException("Sibling folders not found.");
                nnfe.initCause((Throwable)ne);
                throw nnfe;
            }
        }
        return this.siblingFolders;
    }

    public Folder getRootFolder() throws NodeNotFoundException {
        if (this.requestRootFolder == null) {
            this.requestRootFolder = this.sessionContext.getRequestRootFolder(this.requestProfileLocators);
        }
        return this.requestRootFolder;
    }

    public NodeSet getRootLinks() throws NodeNotFoundException {
        Folder rootFolder;
        if (!this.rootLinksCached && (rootFolder = this.getRootFolder()) != null) {
            try {
                this.rootLinks = PortalSiteRequestContextImpl.filterHiddenNodes(rootFolder.getLinks());
                this.rootLinksCached = true;
            }
            catch (NodeException ne) {
                NodeNotFoundException nnfe = new NodeNotFoundException("Root links not found.");
                nnfe.initCause((Throwable)ne);
                throw nnfe;
            }
        }
        return this.rootLinks;
    }

    public Set getStandardMenuNames() {
        return this.sessionContext.getStandardMenuNames();
    }

    public Set getCustomMenuNames() throws NodeNotFoundException {
        Page page = this.getPage();
        Set standardMenuNames = this.sessionContext.getStandardMenuNames();
        if (page != null && standardMenuNames != null && this.pageMenuDefinitionNames == null) {
            List locators = this.sessionContext.getMenuDefinitionLocators((Node)page);
            if (locators != null) {
                this.pageMenuDefinitionNames = new HashSet(locators.size());
                Iterator locatorsIter = locators.iterator();
                while (locatorsIter.hasNext()) {
                    String definitionName = ((SiteViewMenuDefinitionLocator)locatorsIter.next()).getName();
                    if (standardMenuNames.contains(definitionName)) continue;
                    this.pageMenuDefinitionNames.add(definitionName);
                }
            } else {
                this.pageMenuDefinitionNames = new HashSet(0);
            }
        }
        return this.pageMenuDefinitionNames;
    }

    public Menu getMenu(String name) throws NodeNotFoundException {
        return this.getMenu(name, null);
    }

    public Menu getMenu(String name, Set names) throws NodeNotFoundException {
        SiteViewMenuDefinitionLocator locator;
        Page page = this.getPage();
        if (page != null && name != null && (locator = this.sessionContext.getMenuDefinitionLocator((Node)page, name)) != null) {
            MenuImpl menu;
            if (this.menuDefinitionLocatorCache != null && (menu = (MenuImpl)this.menuDefinitionLocatorCache.get(locator)) != null) {
                return menu;
            }
            if (this.sessionContext.getMenuDefinitionLocatorCache() != null && (menu = (MenuImpl)this.sessionContext.getMenuDefinitionLocatorCache().get(locator)) != null) {
                return menu;
            }
            menu = new MenuImpl(locator.getMenuDefinition(), this, names);
            if (page.isHidden() || menu.isElementRelative()) {
                if (this.menuDefinitionLocatorCache == null) {
                    this.menuDefinitionLocatorCache = new HashMap(8);
                }
                this.menuDefinitionLocatorCache.put(locator, menu);
            } else {
                if (this.sessionContext.getMenuDefinitionLocatorCache() == null) {
                    this.sessionContext.setMenuDefinitionLocatorCache(new HashMap(8));
                }
                this.sessionContext.getMenuDefinitionLocatorCache().put(locator, menu);
            }
            return menu;
        }
        return null;
    }

    private static NodeSet filterHiddenNodes(NodeSet nodes) {
        if (nodes != null && !nodes.isEmpty()) {
            ArrayList<Node> filteredNodes = null;
            Iterator nodesIter = nodes.iterator();
            while (nodesIter.hasNext()) {
                Node node = (Node)nodesIter.next();
                if (node.isHidden()) {
                    Node copyNode;
                    if (filteredNodes != null) continue;
                    filteredNodes = new ArrayList<Node>(nodes.size());
                    Iterator copyIter = nodes.iterator();
                    while (copyIter.hasNext() && (copyNode = (Node)copyIter.next()) != node) {
                        filteredNodes.add(copyNode);
                    }
                    continue;
                }
                if (filteredNodes == null) continue;
                filteredNodes.add(node);
            }
            if (filteredNodes != null) {
                return new NodeSetImpl(filteredNodes);
            }
        }
        return nodes;
    }
}

