/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portalsite.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jetspeed.om.common.GenericMetadata;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.folder.MenuDefinition;
import org.apache.jetspeed.om.folder.MenuExcludeDefinition;
import org.apache.jetspeed.om.folder.MenuIncludeDefinition;
import org.apache.jetspeed.om.folder.MenuOptionsDefinition;
import org.apache.jetspeed.om.folder.MenuSeparatorDefinition;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.page.document.NodeNotFoundException;
import org.apache.jetspeed.portalsite.Menu;
import org.apache.jetspeed.portalsite.MenuElement;
import org.apache.jetspeed.portalsite.MenuOption;
import org.apache.jetspeed.portalsite.PortalSiteRequestContext;
import org.apache.jetspeed.portalsite.impl.MenuElementImpl;
import org.apache.jetspeed.portalsite.impl.MenuOptionImpl;
import org.apache.jetspeed.portalsite.impl.MenuSeparatorImpl;
import org.apache.jetspeed.portalsite.impl.PortalSiteRequestContextImpl;
import org.apache.jetspeed.portalsite.impl.PortalSiteSessionContextImpl;
import org.apache.jetspeed.portalsite.menu.DefaultMenuDefinition;
import org.apache.jetspeed.portalsite.menu.DefaultMenuOptionsDefinition;
import org.apache.jetspeed.portalsite.view.SiteView;

public class MenuImpl
extends MenuElementImpl
implements Menu,
Cloneable {
    private MenuDefinition definition;
    private List elements;
    private boolean elementRelative;

    public MenuImpl(MenuImpl parent, MenuDefinition definition, PortalSiteRequestContextImpl context, Set menus) {
        super(parent);
        this.definition = definition;
        SiteView view = ((PortalSiteSessionContextImpl)context.getSessionContext()).getSiteView();
        if (view != null) {
            String options = definition.getOptions();
            Node optionProxy = null;
            if (options != null && options.indexOf(44) == -1) {
                try {
                    optionProxy = view.getNodeProxy(options, (Node)context.getPage(), true, true);
                }
                catch (NodeNotFoundException nnfe) {
                }
                catch (SecurityException se) {
                    // empty catch block
                }
                if (optionProxy != null) {
                    this.setNode(optionProxy);
                }
            }
            if (definition.getMenuElements() == null || definition.getMenuElements().isEmpty()) {
                List<Object> overrideOptionProxies = null;
                if (optionProxy != null) {
                    if (optionProxy instanceof Folder && !definition.isPaths() && definition.getDepth() != 0) {
                        String folderChildrenPath = null;
                        folderChildrenPath = !options.endsWith("/") ? options + "/" + "*" : options + "*";
                        List folderChildren = null;
                        try {
                            folderChildren = view.getNodeProxies(folderChildrenPath, (Node)context.getPage(), true, true);
                        }
                        catch (NodeNotFoundException nnfe) {
                        }
                        catch (SecurityException se) {
                            // empty catch block
                        }
                        if (folderChildren != null && !folderChildren.isEmpty()) {
                            overrideOptionProxies = folderChildren;
                        }
                    } else {
                        overrideOptionProxies = new ArrayList<Node>(1);
                        overrideOptionProxies.add(optionProxy);
                    }
                    if (overrideOptionProxies != null) {
                        this.elementRelative = this.elementRelative || !options.startsWith("/");
                    }
                }
                this.elements = this.constructMenuElements(context, view, options, overrideOptionProxies, definition.getDepth(), definition.isPaths(), definition.isRegexp(), definition.getProfile(), definition.getOrder());
            } else {
                boolean menuNameReferenced = false;
                if (definition.getName() != null && parent == null) {
                    if (menus == null) {
                        menus = new HashSet<String>(4);
                    }
                    menuNameReferenced = menus.add(definition.getName());
                }
                MenuSeparatorImpl separator = null;
                List separatedElements = null;
                Iterator menuElementsIter = definition.getMenuElements().iterator();
                while (menuElementsIter.hasNext()) {
                    Object menuElement = menuElementsIter.next();
                    if (menuElement instanceof MenuOptionsDefinition) {
                        List optionsAndMenus;
                        String order;
                        MenuOptionsDefinition optionDefinition = (MenuOptionsDefinition)menuElement;
                        String locatorName = optionDefinition.getProfile();
                        if (locatorName == null) {
                            locatorName = definition.getProfile();
                        }
                        if ((order = optionDefinition.getOrder()) == null) {
                            order = definition.getOrder();
                        }
                        if ((optionsAndMenus = this.constructMenuElements(context, view, optionDefinition.getOptions(), null, optionDefinition.getDepth(), optionDefinition.isPaths(), optionDefinition.isRegexp(), locatorName, order)) == null) continue;
                        if (separatedElements == null) {
                            separatedElements = optionsAndMenus;
                            continue;
                        }
                        this.appendMenuElements(optionsAndMenus, separatedElements);
                        continue;
                    }
                    if (menuElement instanceof MenuSeparatorDefinition) {
                        if (separatedElements != null && !separatedElements.isEmpty()) {
                            if (this.elements == null) {
                                int initialSize = separatedElements.size();
                                if (separator != null) {
                                    ++initialSize;
                                }
                                this.elements = new ArrayList(initialSize);
                            }
                            if (separator != null) {
                                this.elements.add(separator);
                            }
                            this.elements.addAll(separatedElements);
                        }
                        MenuSeparatorDefinition separatorDefinition = (MenuSeparatorDefinition)menuElement;
                        separator = new MenuSeparatorImpl(this, separatorDefinition);
                        if (separatedElements == null) continue;
                        separatedElements.clear();
                        continue;
                    }
                    if (menuElement instanceof MenuDefinition) {
                        MenuDefinition menuDefinition = (MenuDefinition)menuElement;
                        MenuImpl nestedMenu = new MenuImpl(this, menuDefinition, context, menus);
                        if (separatedElements == null) {
                            separatedElements = new ArrayList(1);
                        }
                        this.appendMenuElement(nestedMenu, separatedElements);
                        this.elementRelative = this.elementRelative || nestedMenu.isElementRelative();
                        continue;
                    }
                    if (menuElement instanceof MenuIncludeDefinition) {
                        MenuIncludeDefinition includeDefinition = (MenuIncludeDefinition)menuElement;
                        if (menus != null && menus.contains(includeDefinition.getName())) continue;
                        MenuImpl includeMenu = null;
                        try {
                            includeMenu = (MenuImpl)context.getMenu(includeDefinition.getName());
                        }
                        catch (NodeNotFoundException nnfe) {
                        }
                        catch (SecurityException se) {
                            // empty catch block
                        }
                        if (includeMenu == null) continue;
                        if (includeDefinition.isNest()) {
                            try {
                                includeMenu = (MenuImpl)includeMenu.clone();
                                includeMenu.setParentMenu(this);
                                if (separatedElements == null) {
                                    separatedElements = new ArrayList(1);
                                }
                                this.appendMenuElement(includeMenu, separatedElements);
                            }
                            catch (CloneNotSupportedException cnse) {}
                        } else if (!includeMenu.isEmpty()) {
                            Iterator elementsIter = includeMenu.getElements().iterator();
                            while (elementsIter.hasNext()) {
                                MenuElementImpl includeElement = (MenuElementImpl)elementsIter.next();
                                try {
                                    includeElement = (MenuElementImpl)includeElement.clone();
                                    includeElement.setParentMenu(this);
                                    if (includeElement instanceof MenuSeparatorImpl) {
                                        if (separatedElements != null && !separatedElements.isEmpty()) {
                                            if (this.elements == null) {
                                                int initialSize = separatedElements.size();
                                                if (separator != null) {
                                                    ++initialSize;
                                                }
                                                this.elements = new ArrayList(initialSize);
                                            }
                                            if (separator != null) {
                                                this.elements.add(separator);
                                            }
                                            this.elements.addAll(separatedElements);
                                        }
                                        separator = (MenuSeparatorImpl)includeElement;
                                        if (separatedElements == null) continue;
                                        separatedElements.clear();
                                        continue;
                                    }
                                    if (separatedElements == null) {
                                        separatedElements = new ArrayList(includeMenu.getElements().size());
                                    }
                                    this.appendMenuElement(includeElement, separatedElements);
                                }
                                catch (CloneNotSupportedException cnse) {}
                            }
                        }
                        this.elementRelative = this.elementRelative || includeMenu.isElementRelative();
                        continue;
                    }
                    if (!(menuElement instanceof MenuExcludeDefinition) || separatedElements == null || separatedElements.isEmpty()) continue;
                    MenuExcludeDefinition excludeDefinition = (MenuExcludeDefinition)menuElement;
                    if (menus != null && menus.contains(excludeDefinition.getName())) continue;
                    MenuImpl excludeMenu = null;
                    try {
                        excludeMenu = (MenuImpl)context.getMenu(excludeDefinition.getName());
                    }
                    catch (NodeNotFoundException nnfe) {
                    }
                    catch (SecurityException se) {
                        // empty catch block
                    }
                    if (excludeMenu == null) continue;
                    this.removeMenuElements(excludeMenu.getElements(), separatedElements);
                    this.elementRelative = this.elementRelative || excludeMenu.isElementRelative();
                }
                if (separatedElements != null && !separatedElements.isEmpty()) {
                    if (this.elements == null) {
                        this.elements = separatedElements;
                        if (separator != null) {
                            this.elements.add(0, separator);
                        }
                    } else {
                        if (separator != null) {
                            this.elements.add(separator);
                        }
                        this.elements.addAll(separatedElements);
                    }
                }
                if (menuNameReferenced) {
                    menus.remove(definition.getName());
                }
            }
        }
    }

    public MenuImpl(MenuDefinition definition, PortalSiteRequestContextImpl context, Set menus) {
        this(null, definition, context, menus);
    }

    private void appendMenuElement(MenuElementImpl appendMenuElement, List menuElements) {
        if (appendMenuElement != null && !menuElements.contains(appendMenuElement)) {
            menuElements.add(appendMenuElement);
        }
    }

    private void appendMenuElements(List appendMenuElements, List menuElements) {
        if (appendMenuElements != null) {
            Iterator elementsIter = appendMenuElements.iterator();
            while (elementsIter.hasNext()) {
                this.appendMenuElement((MenuElementImpl)elementsIter.next(), menuElements);
            }
        }
    }

    private void removeMenuElements(List removeMenuElements, List menuElements) {
        if (removeMenuElements != null) {
            menuElements.removeAll(removeMenuElements);
        }
    }

    private List constructMenuElements(PortalSiteRequestContextImpl context, SiteView view, String options, List overrideElementProxies, int depth, boolean paths, boolean regexp, String locatorName, String order) {
        if (options != null) {
            ArrayList<Node> elementProxies = overrideElementProxies;
            if (elementProxies == null) {
                String[] optionPaths = options.split(",");
                for (int i = 0; i < optionPaths.length; ++i) {
                    String optionPath = optionPaths[i].trim();
                    if (optionPath.length() <= 0) continue;
                    if (regexp) {
                        List pathProxies = null;
                        try {
                            pathProxies = view.getNodeProxies(optionPath, (Node)context.getPage(), true, true);
                        }
                        catch (NodeNotFoundException nnfe) {
                        }
                        catch (SecurityException se) {
                            // empty catch block
                        }
                        if (pathProxies != null) {
                            Iterator pathProxiesIter = pathProxies.iterator();
                            while (pathProxiesIter.hasNext()) {
                                Node pathProxy = (Node)pathProxiesIter.next();
                                if (locatorName != null && !locatorName.equals("*") && !locatorName.equals(view.getProfileLocatorName(pathProxy))) continue;
                                if (elementProxies == null) {
                                    elementProxies = new ArrayList();
                                }
                                this.appendMenuElementProxies(pathProxy, elementProxies);
                            }
                        }
                    } else {
                        Node pathProxy = null;
                        try {
                            pathProxy = view.getNodeProxy(optionPath, (Node)context.getPage(), true, true);
                        }
                        catch (NodeNotFoundException nnfe) {
                        }
                        catch (SecurityException se) {
                            // empty catch block
                        }
                        if (pathProxy != null && (locatorName == null || locatorName.equals("*") || locatorName.equals(view.getProfileLocatorName(pathProxy)))) {
                            if (elementProxies == null) {
                                elementProxies = new ArrayList();
                            }
                            this.appendMenuElementProxies(pathProxy, elementProxies);
                        }
                    }
                    this.elementRelative = this.elementRelative || !optionPath.startsWith("/");
                }
                if (elementProxies == null) {
                    return null;
                }
            }
            if (order != null && elementProxies.size() > 1) {
                ArrayList<Node> orderedElementProxies = new ArrayList<Node>(elementProxies.size());
                String[] orderings = MenuImpl.orderRegexpPattern(order).split(",");
                for (int i = 0; i < orderings.length && elementProxies.size() > 1; ++i) {
                    String ordering = orderings[i].trim();
                    if (ordering.length() <= 0) continue;
                    Pattern pattern = Pattern.compile(ordering);
                    Matcher matcher = null;
                    Iterator elementProxiesIter = elementProxies.iterator();
                    while (elementProxiesIter.hasNext()) {
                        Node elementProxy = (Node)elementProxiesIter.next();
                        String test = null;
                        test = ordering.charAt(0) == '/' ? elementProxy.getUrl() : elementProxy.getName();
                        if (matcher == null) {
                            matcher = pattern.matcher(test);
                        } else {
                            matcher.reset(test);
                        }
                        if (!matcher.matches()) continue;
                        orderedElementProxies.add(elementProxy);
                        elementProxiesIter.remove();
                    }
                }
                orderedElementProxies.addAll(elementProxies);
                elementProxies = orderedElementProxies;
            }
            if (paths && depth == 0 && elementProxies.size() == 1 && (elementProxies.get(0) instanceof Folder || elementProxies.get(0) instanceof Page)) {
                for (Node parentNode = ((Node)elementProxies.get(0)).getParent(); parentNode != null; parentNode = parentNode.getParent()) {
                    elementProxies.add(0, parentNode);
                }
            }
            DefaultMenuOptionsDefinition defaultMenuOptionsDefinition = null;
            ListIterator<MenuOptionImpl> elementProxiesIter = elementProxies.listIterator();
            while (elementProxiesIter.hasNext()) {
                Node elementProxy = (Node)elementProxiesIter.next();
                MenuElementImpl menuElement = null;
                if (elementProxy instanceof Folder && (depth < 0 || depth > 1) && !paths) {
                    DefaultMenuDefinition nestedMenuDefinition = new DefaultMenuDefinition(elementProxy.getUrl(), depth - 1, locatorName);
                    menuElement = new MenuImpl(this, nestedMenuDefinition, context, null);
                } else {
                    if (defaultMenuOptionsDefinition == null) {
                        defaultMenuOptionsDefinition = new DefaultMenuOptionsDefinition(options, depth, paths, regexp, locatorName, order);
                    }
                    menuElement = new MenuOptionImpl(this, elementProxy, defaultMenuOptionsDefinition);
                }
                elementProxiesIter.set((MenuOptionImpl)menuElement);
            }
            ArrayList<Node> menuElements = elementProxies;
            return menuElements;
        }
        return null;
    }

    private void appendMenuElementProxies(Node pathProxy, List elementProxies) {
        if (!elementProxies.contains(pathProxy)) {
            elementProxies.add(pathProxy);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        MenuImpl copy = (MenuImpl)super.clone();
        if (copy.elements != null) {
            Iterator elementsIter = copy.elements.iterator();
            copy.elements = new ArrayList(copy.elements.size());
            while (elementsIter.hasNext()) {
                MenuElementImpl elementCopy = (MenuElementImpl)((MenuElementImpl)elementsIter.next()).clone();
                elementCopy.setParentMenu(copy);
                copy.elements.add(elementCopy);
            }
        }
        return copy;
    }

    public String getElementType() {
        return "menu";
    }

    public String getName() {
        return this.definition.getName();
    }

    public String getTitle() {
        String title = this.definition.getTitle();
        if (title != null) {
            return title;
        }
        return super.getTitle();
    }

    public String getShortTitle() {
        String title = this.definition.getShortTitle();
        if (title != null) {
            return title;
        }
        return super.getShortTitle();
    }

    public String getTitle(Locale locale) {
        String title = this.definition.getTitle(locale);
        if (title != null) {
            return title;
        }
        return super.getTitle(locale);
    }

    public String getShortTitle(Locale locale) {
        String title = this.definition.getShortTitle(locale);
        if (title != null) {
            return title;
        }
        return super.getShortTitle(locale);
    }

    public GenericMetadata getMetadata() {
        GenericMetadata metadata = this.definition.getMetadata();
        if (metadata != null && metadata.getFields() != null && !metadata.getFields().isEmpty()) {
            return metadata;
        }
        return super.getMetadata();
    }

    public String getSkin() {
        String skin = this.definition.getSkin();
        if (skin == null) {
            skin = super.getSkin();
        }
        return skin;
    }

    public String getUrl() {
        if (this.getNode() != null) {
            return this.getNode().getUrl();
        }
        return null;
    }

    public boolean isHidden() {
        if (this.getNode() != null) {
            return this.getNode().isHidden();
        }
        return false;
    }

    public boolean isSelected(PortalSiteRequestContext context) {
        return this.getSelectedElement(context) != null;
    }

    public List getElements() {
        return this.elements;
    }

    public boolean isEmpty() {
        return this.elements == null || this.elements.isEmpty();
    }

    public boolean isElementRelative() {
        return this.elementRelative;
    }

    public MenuElement getSelectedElement(PortalSiteRequestContext context) {
        if (this.elements != null) {
            Iterator elementsIter = this.elements.iterator();
            while (elementsIter.hasNext()) {
                MenuElement element = (MenuElement)elementsIter.next();
                boolean selected = false;
                if (element instanceof MenuOption) {
                    selected = ((MenuOption)element).isSelected(context);
                } else if (element instanceof Menu) {
                    selected = ((Menu)element).isSelected(context);
                }
                if (!selected) continue;
                return element;
            }
        }
        return null;
    }

    private static String orderRegexpPattern(String regexp) {
        StringBuffer pattern = null;
        int limit = regexp.length();
        block9: for (int i = 0; i < limit; ++i) {
            char regexpChar = regexp.charAt(i);
            switch (regexpChar) {
                case '*': 
                case '.': 
                case '?': 
                case '[': {
                    if (pattern == null) {
                        pattern = new StringBuffer(regexp.length() * 2);
                        pattern.append(regexp.substring(0, i));
                    }
                    switch (regexpChar) {
                        case '*': {
                            pattern.append("[^/]*");
                            break;
                        }
                        case '.': {
                            pattern.append("\\.");
                            break;
                        }
                        case '?': {
                            pattern.append("[^/]");
                            break;
                        }
                        case '[': {
                            pattern.append('[');
                        }
                    }
                    continue block9;
                }
                default: {
                    if (pattern == null) continue block9;
                    pattern.append(regexpChar);
                }
            }
        }
        if (pattern != null) {
            return pattern.toString();
        }
        return regexp;
    }
}

