/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portalsite.impl;

import java.util.Locale;
import org.apache.jetspeed.om.common.GenericMetadata;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.portalsite.Menu;
import org.apache.jetspeed.portalsite.MenuElement;
import org.apache.jetspeed.portalsite.impl.MenuImpl;

public abstract class MenuElementImpl
implements MenuElement,
Cloneable {
    private MenuImpl parent;
    private Node node;
    private String skin;
    private boolean skinInherited;

    protected MenuElementImpl(MenuImpl parent) {
        this.parent = parent;
    }

    protected MenuElementImpl(MenuImpl parent, Node node) {
        this(parent);
        this.node = node;
    }

    public Object clone() throws CloneNotSupportedException {
        MenuElementImpl copy = (MenuElementImpl)super.clone();
        copy.parent = null;
        return copy;
    }

    public boolean equals(Object obj) {
        if (this.getClass().equals(obj.getClass())) {
            String url = this.getUrl();
            String name = this.getName();
            if (url != null || name != null) {
                String objUrl = ((MenuElementImpl)obj).getUrl();
                String objName = ((MenuElementImpl)obj).getName();
                return (name == null && objName == null || name != null && name.equals(objName)) && (url != null && url.equals(objUrl) || url == null && objUrl == null);
            }
        }
        return false;
    }

    public abstract String getElementType();

    public Menu getParentMenu() {
        return this.parent;
    }

    protected void setParentMenu(Menu parentMenu) {
        this.parent = (MenuImpl)parentMenu;
    }

    public String getName() {
        return null;
    }

    public String getUrl() {
        return null;
    }

    public String getTitle() {
        if (this.node != null) {
            return this.node.getTitle();
        }
        return this.getName();
    }

    public String getShortTitle() {
        if (this.node != null) {
            return this.node.getShortTitle();
        }
        return this.getName();
    }

    public String getTitle(Locale locale) {
        if (this.node != null) {
            return this.node.getTitle(locale);
        }
        return this.getName();
    }

    public String getShortTitle(Locale locale) {
        if (this.node != null) {
            return this.node.getShortTitle(locale);
        }
        return this.getName();
    }

    public GenericMetadata getMetadata() {
        GenericMetadata metadata;
        if (this.node != null && (metadata = this.node.getMetadata()) != null && (metadata.getFields() == null || metadata.getFields().isEmpty())) {
            return metadata;
        }
        return null;
    }

    public String getSkin() {
        if (!this.skinInherited) {
            if (this.parent != null) {
                this.skin = this.parent.getSkin();
            }
            this.skinInherited = true;
        }
        return this.skin;
    }

    protected Node getNode() {
        return this.node;
    }

    protected void setNode(Node node) {
        this.node = node;
    }
}

