/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.page.document.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.folder.MenuDefinition;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.portalsite.view.SiteView;
import org.apache.jetspeed.portalsite.view.SiteViewMenuDefinitionLocator;
import org.apache.jetspeed.portalsite.view.SiteViewProxy;

public abstract class NodeProxy
extends SiteViewProxy {
    protected static final Method EQUALS_METHOD = NodeProxy.reflectMethod(class$java$lang$Object == null ? (class$java$lang$Object = NodeProxy.class$("java.lang.Object")) : class$java$lang$Object, "equals", new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = NodeProxy.class$("java.lang.Object")) : class$java$lang$Object});
    protected static final Method GET_PARENT_METHOD = NodeProxy.reflectMethod(class$org$apache$jetspeed$page$document$Node == null ? (class$org$apache$jetspeed$page$document$Node = NodeProxy.class$("org.apache.jetspeed.page.document.Node")) : class$org$apache$jetspeed$page$document$Node, "getParent", null);
    protected static final Method GET_PATH_METHOD = NodeProxy.reflectMethod(class$org$apache$jetspeed$page$document$Node == null ? (class$org$apache$jetspeed$page$document$Node = NodeProxy.class$("org.apache.jetspeed.page.document.Node")) : class$org$apache$jetspeed$page$document$Node, "getPath", null);
    protected static final Method GET_URL_METHOD = NodeProxy.reflectMethod(class$org$apache$jetspeed$page$document$Node == null ? (class$org$apache$jetspeed$page$document$Node = NodeProxy.class$("org.apache.jetspeed.page.document.Node")) : class$org$apache$jetspeed$page$document$Node, "getUrl", null);
    protected static final Method HASH_CODE_METHOD = NodeProxy.reflectMethod(class$java$lang$Object == null ? (class$java$lang$Object = NodeProxy.class$("java.lang.Object")) : class$java$lang$Object, "hashCode", null);
    protected static final Method IS_HIDDEN_METHOD = NodeProxy.reflectMethod(class$org$apache$jetspeed$page$document$Node == null ? (class$org$apache$jetspeed$page$document$Node = NodeProxy.class$("org.apache.jetspeed.page.document.Node")) : class$org$apache$jetspeed$page$document$Node, "isHidden", null);
    protected static final Method TO_STRING_METHOD = NodeProxy.reflectMethod(class$java$lang$Object == null ? (class$java$lang$Object = NodeProxy.class$("java.lang.Object")) : class$java$lang$Object, "toString", null);
    private Folder parent;
    private String path;
    private boolean hidden;
    private List menuDefinitionLocators;
    private boolean menuDefinitionLocatorsAggregated;
    private List menuDefinitions;
    private boolean menuDefinitionsAggregated;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$apache$jetspeed$page$document$Node;

    protected NodeProxy(SiteView view, String locatorName, Folder parent, String name, boolean hidden) {
        super(view, locatorName);
        this.parent = parent;
        if (parent != null && name != null) {
            NodeProxy parentProxy = NodeProxy.getNodeProxy(parent);
            String parentPath = parentProxy.getPath();
            this.path = parentPath.endsWith("/") ? parentPath + name : parentPath + "/" + name;
            this.hidden = hidden || parentProxy.isHidden();
        } else {
            this.path = "/";
            this.hidden = hidden;
        }
    }

    public Node getParent() {
        return this.parent;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public String getUrl() {
        return this.path;
    }

    public List getMenuDefinitions() {
        if (!this.menuDefinitionsAggregated) {
            List locators = this.getMenuDefinitionLocators();
            if (locators != null) {
                this.menuDefinitions = new ArrayList(locators.size());
                Iterator locatorsIter = locators.iterator();
                while (locatorsIter.hasNext()) {
                    this.menuDefinitions.add(((SiteViewMenuDefinitionLocator)locatorsIter.next()).getMenuDefinition());
                }
            }
            this.menuDefinitionsAggregated = true;
        }
        return this.menuDefinitions;
    }

    public List getMenuDefinitionLocators() {
        if (!this.menuDefinitionLocatorsAggregated) {
            this.aggregateMenuDefinitionLocators();
            this.menuDefinitionLocatorsAggregated = true;
        }
        return this.menuDefinitionLocators;
    }

    public SiteViewMenuDefinitionLocator getMenuDefinitionLocator(String name) {
        List locators = this.getMenuDefinitionLocators();
        if (locators != null) {
            return this.findMenuDefinitionLocator(name);
        }
        return null;
    }

    protected void aggregateMenuDefinitionLocators() {
    }

    protected void mergeMenuDefinitionLocators(List definitions, Node node) {
        if (definitions != null) {
            Iterator definitionsIter = definitions.iterator();
            while (definitionsIter.hasNext()) {
                MenuDefinition definition = (MenuDefinition)definitionsIter.next();
                String definitionName = definition.getName();
                if (definitionName == null || this.menuDefinitionLocatorsContains(definitionName)) continue;
                if (this.menuDefinitionLocators == null) {
                    this.menuDefinitionLocators = new ArrayList(definitions.size() * 2);
                }
                this.menuDefinitionLocators.add(new SiteViewMenuDefinitionLocator(definition, node));
            }
        }
    }

    protected void mergeMenuDefinitionLocators(List locators) {
        if (locators != null) {
            Iterator locatorsIter = locators.iterator();
            while (locatorsIter.hasNext()) {
                SiteViewMenuDefinitionLocator locator = (SiteViewMenuDefinitionLocator)locatorsIter.next();
                String definitionName = locator.getName();
                if (this.menuDefinitionLocatorsContains(definitionName)) continue;
                if (this.menuDefinitionLocators == null) {
                    this.menuDefinitionLocators = new ArrayList(locators.size() * 2);
                }
                this.menuDefinitionLocators.add(locator);
            }
        }
    }

    private boolean menuDefinitionLocatorsContains(String name) {
        return this.findMenuDefinitionLocator(name) != null;
    }

    private SiteViewMenuDefinitionLocator findMenuDefinitionLocator(String name) {
        if (this.menuDefinitionLocators != null && name != null) {
            Iterator locatorsIter = this.menuDefinitionLocators.iterator();
            while (locatorsIter.hasNext()) {
                SiteViewMenuDefinitionLocator locator = (SiteViewMenuDefinitionLocator)locatorsIter.next();
                if (!name.equals(locator.getName())) continue;
                return locator;
            }
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object != null) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof NodeProxy)) {
                object = NodeProxy.getNodeProxy(object);
            }
            if (object instanceof NodeProxy) {
                return this.path.equals(((NodeProxy)object).path);
            }
        }
        return false;
    }

    public String toString() {
        return this.path;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public static NodeProxy getNodeProxy(Object node) {
        InvocationHandler nodeProxyHandler;
        if (node != null && Proxy.isProxyClass(node.getClass()) && (nodeProxyHandler = Proxy.getInvocationHandler(node)) instanceof NodeProxy) {
            return (NodeProxy)((Object)nodeProxyHandler);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

