/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.folder.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.apache.jetspeed.om.common.GenericMetadata;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.folder.FolderMetaData;
import org.apache.jetspeed.om.folder.FolderNotFoundException;
import org.apache.jetspeed.om.page.Link;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.om.page.proxy.LinkProxy;
import org.apache.jetspeed.om.page.proxy.PageProxy;
import org.apache.jetspeed.page.PageNotFoundException;
import org.apache.jetspeed.page.document.DocumentException;
import org.apache.jetspeed.page.document.DocumentNotFoundException;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.page.document.NodeException;
import org.apache.jetspeed.page.document.NodeSet;
import org.apache.jetspeed.page.document.proxy.NodeProxy;
import org.apache.jetspeed.page.document.proxy.NodeSetImpl;
import org.apache.jetspeed.portalsite.view.SiteView;
import org.apache.jetspeed.portalsite.view.SiteViewSearchPath;

public class FolderProxy
extends NodeProxy
implements InvocationHandler {
    protected static final Method GET_ALL_METHOD = FolderProxy.reflectMethod(class$org$apache$jetspeed$om$folder$Folder == null ? (class$org$apache$jetspeed$om$folder$Folder = FolderProxy.class$("org.apache.jetspeed.om.folder.Folder")) : class$org$apache$jetspeed$om$folder$Folder, "getAll", null);
    protected static final Method GET_DEFAULT_PAGE_METHOD = FolderProxy.reflectMethod(class$org$apache$jetspeed$om$folder$Folder == null ? (class$org$apache$jetspeed$om$folder$Folder = FolderProxy.class$("org.apache.jetspeed.om.folder.Folder")) : class$org$apache$jetspeed$om$folder$Folder, "getDefaultPage", new Class[]{Boolean.TYPE});
    protected static final Method GET_FOLDERS_METHOD = FolderProxy.reflectMethod(class$org$apache$jetspeed$om$folder$Folder == null ? (class$org$apache$jetspeed$om$folder$Folder = FolderProxy.class$("org.apache.jetspeed.om.folder.Folder")) : class$org$apache$jetspeed$om$folder$Folder, "getFolders", null);
    protected static final Method GET_FOLDER_METHOD = FolderProxy.reflectMethod(class$org$apache$jetspeed$om$folder$Folder == null ? (class$org$apache$jetspeed$om$folder$Folder = FolderProxy.class$("org.apache.jetspeed.om.folder.Folder")) : class$org$apache$jetspeed$om$folder$Folder, "getFolder", new Class[]{class$java$lang$String == null ? (class$java$lang$String = FolderProxy.class$("java.lang.String")) : class$java$lang$String});
    protected static final Method GET_LINKS_METHOD = FolderProxy.reflectMethod(class$org$apache$jetspeed$om$folder$Folder == null ? (class$org$apache$jetspeed$om$folder$Folder = FolderProxy.class$("org.apache.jetspeed.om.folder.Folder")) : class$org$apache$jetspeed$om$folder$Folder, "getLinks", null);
    protected static final Method GET_LINK_METHOD = FolderProxy.reflectMethod(class$org$apache$jetspeed$om$folder$Folder == null ? (class$org$apache$jetspeed$om$folder$Folder = FolderProxy.class$("org.apache.jetspeed.om.folder.Folder")) : class$org$apache$jetspeed$om$folder$Folder, "getLink", new Class[]{class$java$lang$String == null ? (class$java$lang$String = FolderProxy.class$("java.lang.String")) : class$java$lang$String});
    protected static final Method GET_MENU_DEFINITIONS_METHOD = FolderProxy.reflectMethod(class$org$apache$jetspeed$om$folder$Folder == null ? (class$org$apache$jetspeed$om$folder$Folder = FolderProxy.class$("org.apache.jetspeed.om.folder.Folder")) : class$org$apache$jetspeed$om$folder$Folder, "getMenuDefinitions", null);
    protected static final Method GET_METADATA_METHOD = FolderProxy.reflectMethod(class$org$apache$jetspeed$om$folder$Folder == null ? (class$org$apache$jetspeed$om$folder$Folder = FolderProxy.class$("org.apache.jetspeed.om.folder.Folder")) : class$org$apache$jetspeed$om$folder$Folder, "getMetadata", null);
    protected static final Method GET_NAME_METHOD = FolderProxy.reflectMethod(class$org$apache$jetspeed$om$folder$Folder == null ? (class$org$apache$jetspeed$om$folder$Folder = FolderProxy.class$("org.apache.jetspeed.om.folder.Folder")) : class$org$apache$jetspeed$om$folder$Folder, "getName", null);
    protected static final Method GET_PAGES_METHOD = FolderProxy.reflectMethod(class$org$apache$jetspeed$om$folder$Folder == null ? (class$org$apache$jetspeed$om$folder$Folder = FolderProxy.class$("org.apache.jetspeed.om.folder.Folder")) : class$org$apache$jetspeed$om$folder$Folder, "getPages", null);
    protected static final Method GET_PAGE_METHOD = FolderProxy.reflectMethod(class$org$apache$jetspeed$om$folder$Folder == null ? (class$org$apache$jetspeed$om$folder$Folder = FolderProxy.class$("org.apache.jetspeed.om.folder.Folder")) : class$org$apache$jetspeed$om$folder$Folder, "getPage", new Class[]{class$java$lang$String == null ? (class$java$lang$String = FolderProxy.class$("java.lang.String")) : class$java$lang$String});
    protected static final Method GET_PAGE_SECURITY_METHOD = FolderProxy.reflectMethod(class$org$apache$jetspeed$om$folder$Folder == null ? (class$org$apache$jetspeed$om$folder$Folder = FolderProxy.class$("org.apache.jetspeed.om.folder.Folder")) : class$org$apache$jetspeed$om$folder$Folder, "getPageSecurity", null);
    protected static final Method GET_SHORT_TITLE_LOCALE_METHOD = FolderProxy.reflectMethod(class$org$apache$jetspeed$om$folder$Folder == null ? (class$org$apache$jetspeed$om$folder$Folder = FolderProxy.class$("org.apache.jetspeed.om.folder.Folder")) : class$org$apache$jetspeed$om$folder$Folder, "getShortTitle", new Class[]{class$java$util$Locale == null ? (class$java$util$Locale = FolderProxy.class$("java.util.Locale")) : class$java$util$Locale});
    protected static final Method GET_SHORT_TITLE_METHOD = FolderProxy.reflectMethod(class$org$apache$jetspeed$om$folder$Folder == null ? (class$org$apache$jetspeed$om$folder$Folder = FolderProxy.class$("org.apache.jetspeed.om.folder.Folder")) : class$org$apache$jetspeed$om$folder$Folder, "getShortTitle", null);
    protected static final Method GET_TITLE_LOCALE_METHOD = FolderProxy.reflectMethod(class$org$apache$jetspeed$om$folder$Folder == null ? (class$org$apache$jetspeed$om$folder$Folder = FolderProxy.class$("org.apache.jetspeed.om.folder.Folder")) : class$org$apache$jetspeed$om$folder$Folder, "getTitle", new Class[]{class$java$util$Locale == null ? (class$java$util$Locale = FolderProxy.class$("java.util.Locale")) : class$java$util$Locale});
    protected static final Method GET_TITLE_METHOD = FolderProxy.reflectMethod(class$org$apache$jetspeed$om$folder$Folder == null ? (class$org$apache$jetspeed$om$folder$Folder = FolderProxy.class$("org.apache.jetspeed.om.folder.Folder")) : class$org$apache$jetspeed$om$folder$Folder, "getTitle", null);
    private Folder defaultFolder;
    private Folder titledFolder;
    private NodeSet children;
    private boolean childrenAggregated;
    private NodeSet folders;
    private boolean foldersAggregated;
    private NodeSet pages;
    private boolean pagesAggregated;
    private NodeSet links;
    private boolean linksAggregated;
    private List searchFolders;
    private List inheritanceFolders;
    static /* synthetic */ Class class$org$apache$jetspeed$om$folder$Folder;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Locale;

    public static Folder newInstance(SiteView view, String locatorName, Folder parentFolder, Folder folder) {
        return (Folder)Proxy.newProxyInstance(folder.getClass().getClassLoader(), new Class[]{class$org$apache$jetspeed$om$folder$Folder == null ? (class$org$apache$jetspeed$om$folder$Folder = FolderProxy.class$("org.apache.jetspeed.om.folder.Folder")) : class$org$apache$jetspeed$om$folder$Folder}, (InvocationHandler)new FolderProxy(view, locatorName, parentFolder, folder));
    }

    private FolderProxy(SiteView view, String locatorName, Folder parentFolder, Folder folder) {
        super(view, locatorName, parentFolder, folder.getName(), folder.isHidden());
        this.defaultFolder = this.selectDefaultFromAggregateFolders(folder);
        this.titledFolder = this.selectTitledFromAggregateFolders(this.defaultFolder);
    }

    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        if (m.equals(GET_ALL_METHOD)) {
            return this.getAll(proxy);
        }
        if (m.equals(GET_DEFAULT_PAGE_METHOD)) {
            return this.getDefaultPage(proxy, (Boolean)args[0]);
        }
        if (m.equals(GET_FOLDERS_METHOD)) {
            return this.getFolders(proxy);
        }
        if (m.equals(GET_FOLDER_METHOD)) {
            return this.getFolder(proxy, (String)args[0]);
        }
        if (m.equals(GET_LINKS_METHOD)) {
            return this.getLinks(proxy);
        }
        if (m.equals(GET_LINK_METHOD)) {
            return this.getLink(proxy, (String)args[0]);
        }
        if (m.equals(GET_MENU_DEFINITIONS_METHOD)) {
            return this.getMenuDefinitions();
        }
        if (m.equals(GET_METADATA_METHOD)) {
            return this.getMetadata();
        }
        if (m.equals(GET_NAME_METHOD)) {
            return this.getName();
        }
        if (m.equals(GET_PAGES_METHOD)) {
            return this.getPages(proxy);
        }
        if (m.equals(GET_PAGE_METHOD)) {
            return this.getPage(proxy, (String)args[0]);
        }
        if (m.equals(GET_SHORT_TITLE_LOCALE_METHOD)) {
            return this.getShortTitle((Locale)args[0]);
        }
        if (m.equals(GET_SHORT_TITLE_METHOD)) {
            return this.getShortTitle();
        }
        if (m.equals(GET_TITLE_LOCALE_METHOD)) {
            return this.getTitle((Locale)args[0]);
        }
        if (m.equals(GET_TITLE_METHOD)) {
            return this.getTitle();
        }
        if (m.equals(GET_PARENT_METHOD)) {
            return this.getParent();
        }
        if (m.equals(GET_PATH_METHOD)) {
            return this.getPath();
        }
        if (m.equals(GET_URL_METHOD)) {
            return this.getUrl();
        }
        if (m.equals(EQUALS_METHOD)) {
            return new Boolean(this.equals(args[0]));
        }
        if (m.equals(HASH_CODE_METHOD)) {
            return new Integer(this.hashCode());
        }
        if (m.equals(IS_HIDDEN_METHOD)) {
            return new Boolean(this.isHidden());
        }
        if (m.equals(TO_STRING_METHOD)) {
            return this.toString();
        }
        if (m.equals(GET_PAGE_SECURITY_METHOD) || m.getName().startsWith("set")) {
            throw new RuntimeException("Folder instance is immutable from proxy.");
        }
        return m.invoke((Object)this.defaultFolder, args);
    }

    public NodeSet getAll(Object proxy) throws FolderNotFoundException, DocumentException {
        if (!this.childrenAggregated) {
            this.children = this.aggregateChildren(proxy);
            this.childrenAggregated = true;
        }
        return this.children;
    }

    public String getDefaultPage(Object proxy, boolean allowDefaulting) {
        Page defaultPage = this.selectDefaultPageFromAggregateFolders(proxy);
        if (defaultPage != null) {
            return defaultPage.getName();
        }
        if (allowDefaulting) {
            try {
                NodeSet pages = this.getPages(proxy);
                if (pages != null && !pages.isEmpty()) {
                    return ((Page)pages.iterator().next()).getName();
                }
            }
            catch (NodeException ne) {
            }
            catch (SecurityException se) {
                // empty catch block
            }
            return "page_not_found.psml";
        }
        return null;
    }

    public NodeSet getFolders(Object proxy) throws FolderNotFoundException, DocumentException {
        if (!this.foldersAggregated) {
            NodeSet allChildren = this.getAll(proxy);
            if (allChildren != null) {
                this.folders = allChildren.subset("folder");
            }
            this.foldersAggregated = true;
        }
        return this.folders;
    }

    public Folder getFolder(Object proxy, String name) throws FolderNotFoundException, DocumentException {
        Folder folder;
        NodeSet allFolders = this.getFolders(proxy);
        if (allFolders != null && (folder = (Folder)allFolders.get(name)) != null) {
            return folder;
        }
        throw new FolderNotFoundException("Folder " + name + " not found at " + this.getPath());
    }

    public NodeSet getLinks(Object proxy) throws NodeException {
        if (!this.linksAggregated) {
            NodeSet allChildren = this.getAll(proxy);
            if (allChildren != null) {
                this.links = allChildren.subset(".link");
            }
            this.linksAggregated = true;
        }
        return this.links;
    }

    public Link getLink(Object proxy, String name) throws DocumentNotFoundException, NodeException {
        Link link;
        NodeSet allLinks = this.getLinks(proxy);
        if (allLinks != null && (link = (Link)allLinks.get(name)) != null) {
            return link;
        }
        throw new DocumentNotFoundException("Link " + name + " not found at " + this.getPath());
    }

    public String getName() {
        if (this.getPath().equals("/")) {
            return "/";
        }
        return this.defaultFolder.getName();
    }

    public NodeSet getPages(Object proxy) throws NodeException {
        if (!this.pagesAggregated) {
            NodeSet allChildren = this.getAll(proxy);
            if (allChildren != null) {
                this.pages = allChildren.subset(".psml");
            }
            this.pagesAggregated = true;
        }
        return this.pages;
    }

    public Page getPage(Object proxy, String name) throws PageNotFoundException, NodeException {
        Page page;
        NodeSet allPages = this.getPages(proxy);
        if (allPages != null && (page = (Page)allPages.get(name)) != null) {
            return page;
        }
        throw new PageNotFoundException("Page " + name + " not found at " + this.getPath());
    }

    public GenericMetadata getMetadata() {
        return this.titledFolder.getMetadata();
    }

    public String getTitle() {
        return this.titledFolder.getTitle();
    }

    public String getShortTitle() {
        return this.titledFolder.getShortTitle();
    }

    public String getTitle(Locale locale) {
        return this.titledFolder.getTitle(locale);
    }

    public String getShortTitle(Locale locale) {
        return this.titledFolder.getShortTitle(locale);
    }

    public Folder getDefaultFolder() {
        return this.defaultFolder;
    }

    protected void aggregateMenuDefinitionLocators() {
        try {
            Iterator foldersIter = this.getInheritanceFolders().iterator();
            while (foldersIter.hasNext()) {
                Folder folder = (Folder)foldersIter.next();
                this.mergeMenuDefinitionLocators(folder.getMenuDefinitions(), (Node)folder);
            }
        }
        catch (FolderNotFoundException folderNotFoundException) {
            // empty catch block
        }
        this.mergeMenuDefinitionLocators(this.getView().getStandardMenuDefinitionLocators());
    }

    private Folder selectDefaultFromAggregateFolders(Folder defaultFolder) {
        try {
            return ((SearchFolder)this.getSearchFolders().get((int)0)).folder;
        }
        catch (FolderNotFoundException folderNotFoundException) {
            return defaultFolder;
        }
    }

    private Folder selectTitledFromAggregateFolders(Folder defaultFolder) {
        try {
            Iterator foldersIter = this.getSearchFolders().iterator();
            while (foldersIter.hasNext()) {
                Folder folder = ((SearchFolder)foldersIter.next()).folder;
                GenericMetadata folderMetadata = folder.getMetadata();
                if (folder.getTitle() == folder.getShortTitle() && (folderMetadata == null || folderMetadata.getFields() == null || folderMetadata.getFields().isEmpty())) continue;
                return folder;
            }
        }
        catch (FolderNotFoundException folderNotFoundException) {
            // empty catch block
        }
        return defaultFolder;
    }

    private Page selectDefaultPageFromAggregateFolders(Object proxy) {
        try {
            boolean fallbackDefaultPageNotFound = false;
            Iterator foldersIter = this.getSearchFolders().iterator();
            while (foldersIter.hasNext()) {
                Folder folder = ((SearchFolder)foldersIter.next()).folder;
                String defaultPageName = folder.getFolderMetaData().getDefaultPage();
                if (defaultPageName != null) {
                    try {
                        return this.getPage(proxy, defaultPageName);
                    }
                    catch (NodeException ne) {
                        continue;
                    }
                    catch (SecurityException se) {
                        continue;
                    }
                }
                if (fallbackDefaultPageNotFound) continue;
                try {
                    return this.getPage(proxy, "default-page.psml");
                }
                catch (NodeException ne) {
                    fallbackDefaultPageNotFound = true;
                }
                catch (SecurityException se) {
                    fallbackDefaultPageNotFound = true;
                }
            }
        }
        catch (FolderNotFoundException folderNotFoundException) {
            // empty catch block
        }
        return null;
    }

    private NodeSet aggregateChildren(Object proxy) {
        try {
            ArrayList<Object> allChildren = new ArrayList<Object>();
            Vector folderDocumentOrder = null;
            Iterator foldersIter = this.getSearchFolders().iterator();
            while (foldersIter.hasNext()) {
                Vector documentOrder;
                FolderMetaData metadata;
                SearchFolder searchFolder = (SearchFolder)foldersIter.next();
                Folder folder = searchFolder.folder;
                String locatorName = searchFolder.locatorName;
                NodeSet children = folder.getAll();
                Iterator childrenIter = children.iterator();
                while (childrenIter.hasNext()) {
                    Node child = (Node)childrenIter.next();
                    String childName = child.getName();
                    if (child instanceof Folder && (childName.startsWith("__") || childName.startsWith("_"))) continue;
                    boolean childUnique = true;
                    Iterator allChildrenIter = allChildren.iterator();
                    while (childUnique && allChildrenIter.hasNext()) {
                        childUnique = !childName.equals(((Node)allChildrenIter.next()).getName());
                    }
                    if (!childUnique) continue;
                    if (child instanceof Folder) {
                        allChildren.add(FolderProxy.newInstance(this.getView(), locatorName, (Folder)proxy, (Folder)child));
                        continue;
                    }
                    if (child instanceof Page) {
                        allChildren.add(PageProxy.newInstance(this.getView(), locatorName, (Folder)proxy, (Page)child));
                        continue;
                    }
                    if (!(child instanceof Link)) continue;
                    allChildren.add(LinkProxy.newInstance(this.getView(), locatorName, (Folder)proxy, (Link)child));
                }
                if (folderDocumentOrder != null || (metadata = folder.getFolderMetaData()) == null || (documentOrder = metadata.getDocumentOrder()) == null || documentOrder.isEmpty()) continue;
                folderDocumentOrder = documentOrder;
            }
            if (allChildren.size() > 1) {
                final Vector order = folderDocumentOrder;
                Comparator comparator = new Comparator(){

                    public int compare(Object proxyNode1, Object proxyNode2) {
                        String name1 = ((Node)proxyNode1).getName();
                        String name2 = ((Node)proxyNode2).getName();
                        if (order != null) {
                            int index1 = order.indexOf(name1);
                            int index2 = order.indexOf(name2);
                            if (index1 != -1 || index2 != -1) {
                                if (index1 == -1 && index2 != -1) {
                                    return 1;
                                }
                                if (index1 != -1 && index2 == -1) {
                                    return -1;
                                }
                                return index1 - index2;
                            }
                        }
                        return name1.compareTo(name2);
                    }
                };
                Collections.sort(allChildren, comparator);
            }
            if (!allChildren.isEmpty()) {
                return new NodeSetImpl(allChildren);
            }
        }
        catch (FolderNotFoundException fnfe) {
        }
        catch (DocumentException documentException) {
            // empty catch block
        }
        return null;
    }

    private List getSearchFolders() throws FolderNotFoundException {
        if (this.searchFolders == null) {
            List searchPaths = this.getView().getSearchPaths();
            this.searchFolders = new ArrayList(searchPaths.size());
            Iterator pathsIter = searchPaths.iterator();
            while (pathsIter.hasNext()) {
                SiteViewSearchPath searchPath = (SiteViewSearchPath)pathsIter.next();
                String path = searchPath.toString();
                path = !path.equals("/") ? path + this.getPath() : this.getPath();
                try {
                    Folder folder = this.getView().getPageManager().getFolder(path);
                    if (folder == null) continue;
                    this.searchFolders.add(new SearchFolder(folder, searchPath.getLocatorName()));
                }
                catch (NodeException ne) {
                }
                catch (SecurityException se) {}
            }
        }
        if (!this.searchFolders.isEmpty()) {
            return this.searchFolders;
        }
        throw new FolderNotFoundException("Search folders at " + this.getPath() + " not found or accessible");
    }

    private List getInheritanceFolders() throws FolderNotFoundException {
        if (this.inheritanceFolders == null) {
            FolderProxy folder = this;
            List searchFolders = folder.getSearchFolders();
            this.inheritanceFolders = this.getParent() != null ? new ArrayList(searchFolders.size() * 2) : new ArrayList(searchFolders.size());
            do {
                Iterator foldersIter = searchFolders.iterator();
                while (foldersIter.hasNext()) {
                    this.inheritanceFolders.add(((SearchFolder)foldersIter.next()).folder);
                }
                if ((folder = (FolderProxy)FolderProxy.getNodeProxy(folder.getParent())) == null) continue;
                searchFolders = folder.getSearchFolders();
            } while (folder != null);
        }
        if (!this.inheritanceFolders.isEmpty()) {
            return this.inheritanceFolders;
        }
        throw new FolderNotFoundException("Inheritance folders at " + this.getPath() + " not found or accessible");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SearchFolder {
        public Folder folder;
        public String locatorName;

        public SearchFolder(Folder folder, String locatorName) {
            this.folder = folder;
            this.locatorName = locatorName;
        }
    }
}

